% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exchange.R
\name{exchange}
\alias{exchange}
\title{Exchange two random elements}
\usage{
exchange(X, j)
}
\arguments{
\item{X}{A matrix object. In general, \code{X} stands for the design matrix.}

\item{j}{A positive integer, which stands for the j^{th} column of \code{X}, and it should be in [1,ncol(X)].}
}
\value{
If all inputs are logical, then the output will be a new design matrix after the exchange.
}
\description{
\code{exchange} returns a new design matrix after two randomly selected elements are switched from a user-defined column
}
\examples{
#create a toy LHD with 5 rows and 3 columns
toy=rLHD(n=5,k=3);toy

#Choose the first column of toy and exchange two randomly selected elements.
toy_new=exchange(X=toy,j=1)
toy;toy_new
}
