% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLP.R
\name{GLP}
\alias{GLP}
\title{Good Lattice Point Design}
\usage{
GLP(n, k, h = sample(seq(from = 1, to = (n - 1)), k))
}
\arguments{
\item{n}{A positive integer, which stands for the number of rows (or run size).}

\item{k}{A positive integer, which stands for the number of columns (or factor size). \code{k} must be smaller than \code{n}. In GLP designs, \code{k} <= the total number of positive integers that are smaller than and coprime to \code{n}.}

\item{h}{A vector whose length is \code{k}, with its elements that are smaller than and coprime to \code{n}. The default is set to be a random sample of \code{k} elements between 1 and \code{n-1}.}
}
\value{
If all inputs are logical, then the output will be a \code{n} by \code{k} GLP design matrix.
}
\description{
\code{GLP} returns a design matrix generated by good lattice point (GLP)
}
\examples{
#generate a 5 by 3 GLP design with the default setting
try=GLP(n=5,k=3)
try

#Another example
#generate a 8 by 4 GLP design with given h vector
try2=GLP(n=8,k=4,h=c(1,3,5,7))
try2
}
\references{
Korobov, A.N. (1959) The approximate computation of multiple integrals. \emph{Dokl. Akad. Nauk SSSR}, \strong{124}, 1207-1210.
}
