% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{juliaFun}
\alias{juliaFun}
\title{Wrap a Julia function in an R function}
\usage{
juliaFun(name, ...)
}
\arguments{
\item{name}{the name of the Julia function}

\item{...}{optional arguments for currying:
The resulting function will be called using these arguments.}
}
\description{
Creates an R function that will call the Julia function with the given name
when it is called. Like any R function, the returned function can
also be passed as a function argument to Julia functions.
}
\examples{
if (juliaSetupOk()) {

   # Wrap a Julia function and use it
   juliaSqrt <- juliaFun("sqrt")
   juliaSqrt(2)
   # In the following call, the sqrt function is called without
   # a callback to R because the linked function object is used.
   juliaCall("map", juliaSqrt, c(1,4,9))

   # may also be used with arguments
   plus1 <- juliaFun("+", 1)
   plus1(2)
   # Results in an R callback (calling Julia again)
   # because there is no linked function object in Julia.
   juliaCall("map", plus1, c(1,2,3))

}

\dontshow{
JuliaConnectoR:::stopJulia()
}
}
