% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdt_within_wide.R
\name{mdt_within_wide}
\alias{mdt_within_wide}
\title{Joint-significance test for simple mediation (wide-format input)}
\usage{
mdt_within_wide(data, DV_A, DV_B, M_A, M_B)
}
\arguments{
\item{data}{a data frame containing the variables in the model.}

\item{DV_A}{an unquoted numeric variable in the data frame which will be used
as the dependent variable value for the "A" independent variable condition.}

\item{DV_B}{an unquoted numeric variable in the data frame which will be used
as the dependent variable value for the "B" independent variable condition.}

\item{M_A}{an unquoted numeric variable in the data frame which will be used
as the mediatior variable value for the "A" independent variable condition.}

\item{M_B}{an unquoted numeric variable in the data frame which will be used
as the mediatior variable value for the "b" independent variable condition.}
}
\value{
Returns an object of class "\code{mediation_model}".

An object of class "\code{mediation_model}" is a list containing at least
the components:

\item{type}{A character string containing the type of model that has been
conducted (e.g., \code{"simple mediation"}).}
\item{method}{A character string containing the approach that has been
used to conduct the mediation analysis (usually
\code{"joint significance"}).} \item{params}{A named list of character
strings describing the variables used in the model.}
\item{paths}{A named list containing information on each relevant path of
the mediation model.}
\item{indirect_index}{A boolean indicating whether an indirect effect index
has been computed or not. Defaults to \code{FALSE}. See
\code{\link{add_index}} to compute mediation index.}
\item{indirect_index_infos}{(Optional) An object of class
\code{"indirect_index"}. Appears when one applies \code{\link{add_index}}
to an object of class \code{"mediation_model"}.}
\item{js_models}{A list of objects of class \code{"lm"}. Contains every
model relevant to joint-significance testing.}
\item{data}{The original data frame that has been passed through
\code{data} argument.}
}
\description{
Given a data frame, a predictor (\code{IV}), an outcome
(\code{DV}), a mediator (\code{M}), and a grouping variable (\code{group})
conducts a joint-significant test for within-participant mediation (see
Yzerbyt, Muller, Batailler, & Judd, 2018).
}
\details{
With within-participant mediation analysis, one tests whether the
effect of \eqn{X} on \eqn{Y} goes through a third variable \eqn{M}. The
specificity of within-participant mediation analysis lies in the repeated
measures design it relies on. With such a design, each sampled unit (e.g.,
participant) is measured on the dependent variable \eqn{Y} and the mediator
\eqn{M} in the two conditions of \eqn{X}. The hypothesis behind this test
is that \eqn{X} has an effect on \eqn{M} (\eqn{a}) which has an effect on
\eqn{Y} (\eqn{b}), meaning that \eqn{X} has an indirect effect on \eqn{Y}
through \eqn{M}.

As with simple mediation, the total effect of \eqn{X} on \eqn{Y} can be
conceptually described as follows:

\deqn{c = c' + ab}

with \eqn{c} the total effect of \eqn{X} on \eqn{Y}, \eqn{c'} the direct of
\eqn{X} on \eqn{Y}, and \eqn{ab} the indirect effect of \eqn{X} on \eqn{Y}
through {M} (see Models section).

To assess whether the indirect effect is different from the null, one has
to assess the significance against the null for both \eqn{a} (the effect of
\eqn{X} on \eqn{M}) and \eqn{b} (effect of \eqn{M} on \eqn{Y} controlling
for the effect of \eqn{X}). Both \eqn{a} and \eqn{b} need to be
simultaneously significant for an indirect effect to be claimed (Judd,
Kenny, & McClelland, 2001; Montoya & Hayes, 2011).
}
\section{Data formatting}{
 To be consistent with other \code{mdt_*} family
functions, \code{mdt_within} takes a long-format data frame as \code{data}
argument. With this kind of format, each sampled unit has two rows, one for
the first within-participant condition and one for the second
within-participant condition. In addition, each row has one observation for
the outcome and one observation for the mediator (see
\code{\link{dohle_siegrist}} for an example.

Because such formatting is not the most common among social scientists
interested in within-participant mediation, \pkg{JSmediation} contains the
\code{\link{mdt_within_wide}} function which handles wide-formatted data
input (but is syntax-inconsistent with other \code{mdt_*} family
functions).
}

\section{Variable coding}{
 Models underlying within-participant mediation use
difference scores as DV (see Models section).  \code{mdt_within_wide} uses
\code{M_A} \eqn{-} \code{M_B} and \code{DV_A} \eqn{-} \code{DV_B} in these
models.
}

\section{Models}{
 For within-participant mediation, three models will be
fitted:
\itemize{
\item \eqn{Y_{2i} - Y_{1i} = c_{11}}{Y2i - Y1i = c11}
\item \eqn{M_{2i} - M_{1i} = a_{21}}{M2i - M1i = a21}
\item \eqn{Y_{2i} - Y_{1i} = c'_{31} + b_{32}(M_{2i} - M_{1i}) +
  d_{33}[0.5(M_{1i} + M_{2i}) - 0.5(\overline{M_{1} + M_{2}})]}{Y2i - Y1i =
  c'31 + b32 * (M2i + M1i) + d33 * [0.5 * (M1i + M2i) - 0.5 * mean(M1 + M2)]}
}

with \eqn{Y_{2i} - Y_{1i}}{Y2i - Y1i} the difference score between DV
conditions for the outcome variable for the \emph{i}th observation,
\eqn{M_{2i} - M_{1i}}{M2i - M1i} the difference score between DV conditions
for the mediator variable for the \emph{i}th observation, \eqn{M_{1i} +
  M_{2i}}{M1i + M2i} the sum of mediator variables values for DV conditions
for the \emph{i}th observation, and \eqn{\overline{M_{1} + M_{2}}}{mean(M1i
  + M2i)} the mean sum of mediator variables values for DV conditions across
observations (see Montoya & Hayes, 2011).

Coefficients associated with \eqn{a}, \eqn{b}, \eqn{c}, and \eqn{c'} paths
are respectively \eqn{a_{21}}{a21}, \eqn{b_{32}}{b32}, \eqn{c_{11}}{c11},
and \eqn{c'_{31}}{c'31}.
}

\references{
Judd, C. M., Kenny, D. A., & McClelland, G. H. (2001). Estimating
and testing mediation and moderation in within-subject designs.
\emph{Psychological Methods}, \emph{6}(2), 115-134. doi:
10.1037//1082-989X.6.2.115

Montoya, A. K., & Hayes, A. F. (2017). Two-condition within-participant
statistical mediation analysis: A path-analytic framework.
\emph{Psychological Methods}, \emph{22}(1), 6-27. doi: 10.1037/met0000086

Yzerbyt, V., Muller, D., Batailler, C., & Judd, C. M. (2018). New
recommendations for testing indirect effects in mediational models: The
need to report and test component paths. \emph{Journal of Personality and
Social Psychology}, \emph{115}(6), 929–943. doi: 10.1037/pspa0000132
}
