/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import org.rosuda.JGR.JGRHelp;

public class FindReplaceDialog
extends JDialog
implements ActionListener {
    private Frame parent;
    private JTextComponent comp;
    private JTextField findField;
    private JTextField replaceField;
    private JButton replaceButton = new JButton("Replace");
    private JButton replaceAllButton = new JButton("Replace All");
    private JButton findPreviousButton = new JButton("Previous");
    private JButton findNextButton = new JButton("Next");
    private Highlighter.HighlightPainter highLighter = new FoundHighlighter(SystemColor.textHighlight);
    private static FindReplaceDialog instance;
    private String currentPattern;
    private String currentReplaceStr;
    private int currentPosition;
    private boolean haveFound = false;
    private boolean startLoop = false;
    boolean replaceing = false;
    private boolean replaceingall = false;
    private int replacements = 0;

    private FindReplaceDialog(Frame frame, JTextComponent jTextComponent) {
        this.setTitle("Find");
        this.parent = frame;
        this.comp = jTextComponent;
        this.setResizable(false);
        this.setSize(450, 140);
        this.replaceButton.setActionCommand("replace");
        this.replaceButton.addActionListener(this);
        this.replaceAllButton.setActionCommand("replaceAll");
        this.replaceAllButton.addActionListener(this);
        this.findNextButton.setActionCommand("findNext");
        this.findNextButton.addActionListener(this);
        this.findPreviousButton.setActionCommand("findPrevious");
        this.findPreviousButton.addActionListener(this);
        this.findField = new JTextField();
        this.findField.setPreferredSize(new Dimension(330, 25));
        this.findField.setMinimumSize(new Dimension(330, 25));
        this.findField.setMaximumSize(new Dimension(330, 25));
        this.replaceField = new JTextField();
        this.replaceField.setPreferredSize(new Dimension(330, 25));
        this.replaceField.setMinimumSize(new Dimension(330, 25));
        this.replaceField.setMaximumSize(new Dimension(330, 25));
        JPanel jPanel = new JPanel(new FlowLayout(0));
        JLabel jLabel = new JLabel("Find:");
        jLabel.setPreferredSize(new Dimension(95, 25));
        jLabel.setMinimumSize(new Dimension(95, 25));
        jLabel.setMaximumSize(new Dimension(95, 25));
        jPanel.add(jLabel);
        jPanel.add(this.findField);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JLabel jLabel2 = new JLabel("Replace with:");
        jLabel2.setPreferredSize(new Dimension(95, 25));
        jLabel2.setMinimumSize(new Dimension(95, 525));
        jLabel2.setMaximumSize(new Dimension(95, 25));
        jPanel2.add(jLabel2);
        jPanel2.add(this.replaceField);
        JPanel jPanel3 = new JPanel(new FlowLayout(2));
        jPanel3.add(this.replaceAllButton);
        jPanel3.add(this.replaceButton);
        jPanel3.add(this.findPreviousButton);
        jPanel3.add(this.findNextButton);
        this.setLayout(new GridLayout(3, 1, 5, 5));
        this.add(jPanel);
        this.add(jPanel2);
        this.add(jPanel3);
        this.getRootPane().setDefaultButton(this.findNextButton);
    }

    public static void findExt(Frame frame, JTextComponent jTextComponent) {
        if (frame == null || jTextComponent == null) {
            return;
        }
        if (instance == null) {
            instance = new FindReplaceDialog(frame, jTextComponent);
        } else if (FindReplaceDialog.instance.comp != null && FindReplaceDialog.instance.comp.equals(jTextComponent)) {
            FindReplaceDialog.instance.findField.selectAll();
        } else {
            instance.clean();
        }
        FindReplaceDialog.instance.comp = jTextComponent;
        FindReplaceDialog.instance.replaceField.setEditable(jTextComponent.isEditable());
        FindReplaceDialog.instance.replaceField.setEnabled(jTextComponent.isEditable());
        FindReplaceDialog.instance.parent = frame;
        instance.setLocation((int)(frame.getLocation().getX() + frame.getSize().getWidth() / 2.0 + 200.0), (int)(frame.getLocation().getY() + frame.getSize().getHeight() / 2.0 + 70.0));
        instance.setVisible(true);
    }

    public void clean() {
        this.currentPattern = null;
        this.currentReplaceStr = null;
        this.currentPosition = -1;
        this.findField.setText("");
        this.replaceField.setText("");
        this.haveFound = false;
        this.removeHighlights(this.comp);
    }

    public static void findNextExt(Frame frame, JTextComponent jTextComponent) {
        if (instance == null) {
            instance = new FindReplaceDialog(frame, jTextComponent);
        }
        FindReplaceDialog.instance.comp = jTextComponent;
        FindReplaceDialog.instance.replaceField.setEditable(jTextComponent.isEditable());
        FindReplaceDialog.instance.replaceField.setEnabled(jTextComponent.isEditable());
        FindReplaceDialog.instance.parent = frame;
        instance.setLocation((int)(frame.getLocation().getX() + frame.getSize().getWidth() / 2.0 + 200.0), (int)(frame.getLocation().getY() + frame.getSize().getHeight() / 2.0 + 70.0));
        if (FindReplaceDialog.instance.currentPattern == null || FindReplaceDialog.instance.currentPattern.length() <= 0) {
            instance.setVisible(true);
        } else {
            instance.findNext();
        }
    }

    private void findNext() {
        this.currentPattern = this.findField.getText().toLowerCase().trim();
        if (this.currentPattern == null || this.currentPattern.length() <= 0) {
            return;
        }
        if (this.parent instanceof JGRHelp) {
            int n = this.comp.getCaretPosition();
            this.comp.selectAll();
            this.currentPosition = this.comp.getSelectedText().toLowerCase().indexOf(this.currentPattern, this.currentPosition + 1);
            this.comp.select(n, n);
        } else {
            this.currentPosition = this.comp.getText().toLowerCase().indexOf(this.currentPattern, this.currentPosition + 1);
        }
        if (this.currentPosition == -1) {
            if (this.startLoop) {
                if (this.replaceing) {
                    JOptionPane.showMessageDialog(this, this.replaceingall ? this.replacements + " replacements done." : "No more replacements possible.", "Not found!", 1);
                }
                this.startLoop = false;
                this.haveFound = false;
                return;
            }
            this.removeHighlights(this.comp);
            if (!this.haveFound) {
                JOptionPane.showMessageDialog(this, "Couldn't find: " + this.currentPattern, "Not found!", 1);
            } else {
                this.startLoop = true;
                this.findNext();
            }
            this.haveFound = false;
        } else {
            this.highlight(this.comp, this.currentPosition, this.currentPosition + this.currentPattern.length());
            this.comp.select(this.currentPosition, this.currentPosition + this.currentPattern.length());
            this.haveFound = true;
            this.startLoop = false;
            if (!this.replaceing) {
                this.setVisible(false);
            }
        }
    }

    private void findPrevious() {
        this.currentPattern = this.findField.getText().toLowerCase().trim();
        if (this.currentPattern == null || this.currentPattern.length() <= 0) {
            return;
        }
        try {
            if (this.parent instanceof JGRHelp) {
                int n = this.comp.getCaretPosition();
                this.comp.select(0, this.currentPosition == -1 ? this.comp.getText().length() : this.currentPosition);
                this.currentPosition = this.comp.getSelectedText().toLowerCase().indexOf(this.currentPattern, this.currentPosition + 1);
                this.comp.select(n, n);
            } else {
                this.currentPosition = this.comp.getText(0, this.currentPosition == -1 ? this.comp.getText().length() : this.currentPosition).toLowerCase().lastIndexOf(this.currentPattern);
            }
        }
        catch (BadLocationException badLocationException) {
            if (!this.haveFound) {
                JOptionPane.showMessageDialog(this, "Couldn't find: " + this.currentPattern, "Not found!", 1);
            } else {
                JOptionPane.showMessageDialog(this, "Couldn't find anymore: " + this.currentPattern, "No more results!", 1);
            }
            this.haveFound = false;
        }
        if (this.currentPosition == -1) {
            if (this.startLoop) {
                if (this.replaceing) {
                    JOptionPane.showMessageDialog(this, this.replaceingall ? this.replacements + " replacements done." : "No more replacements possible.", "Not found!", 1);
                }
                this.startLoop = false;
                this.haveFound = false;
                return;
            }
            this.removeHighlights(this.comp);
            if (!this.haveFound) {
                JOptionPane.showMessageDialog(this, "Couldn't find: " + this.currentPattern, "Not found!", 1);
            } else {
                this.findPrevious();
            }
            this.haveFound = false;
        } else {
            this.highlight(this.comp, this.currentPosition, this.currentPosition + this.currentPattern.length());
            this.comp.select(this.currentPosition, this.currentPosition + this.currentPattern.length());
            this.haveFound = true;
            this.startLoop = false;
            if (!this.replaceing) {
                this.setVisible(false);
            }
        }
    }

    private boolean replace() {
        this.currentReplaceStr = this.replaceField.getText().trim();
        if (this.currentReplaceStr == null || this.currentReplaceStr.length() <= 0) {
            return false;
        }
        this.replaceing = true;
        if (this.comp.getSelectedText() == null || !this.comp.getSelectedText().equalsIgnoreCase(this.currentPattern)) {
            this.findNext();
        }
        this.replaceing = false;
        if (this.currentPosition != -1) {
            this.comp.replaceSelection(this.currentReplaceStr);
            return true;
        }
        return false;
    }

    private void replaceAll() {
        this.currentReplaceStr = this.replaceField.getText().trim();
        if (this.currentReplaceStr == null || this.currentReplaceStr.length() <= 0) {
            return;
        }
        this.replacements = 0;
        this.replaceingall = true;
        while (this.replace()) {
            ++this.replacements;
        }
        this.replaceingall = false;
    }

    private void highlight(JTextComponent jTextComponent, int n, int n2) {
        this.removeHighlights(jTextComponent);
        try {
            Highlighter highlighter = jTextComponent.getHighlighter();
            highlighter.addHighlight(n, n2, this.highLighter);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void removeHighlights(JTextComponent jTextComponent) {
        Highlighter highlighter = jTextComponent.getHighlighter();
        Highlighter.Highlight[] highlightArray = highlighter.getHighlights();
        for (int i = 0; i < highlightArray.length; ++i) {
            if (!(highlightArray[i].getPainter() instanceof FoundHighlighter)) continue;
            highlighter.removeHighlight(highlightArray[i]);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "findPrevious") {
            this.findPrevious();
        } else if (string == "findNext") {
            this.findNext();
        } else if (string == "replace") {
            this.replace();
        } else if (string == "replaceAll") {
            this.replaceAll();
        }
    }

    class FoundHighlighter
    extends DefaultHighlighter.DefaultHighlightPainter {
        public FoundHighlighter(Color color) {
            super(color);
        }
    }
}

