/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR;

import java.io.File;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.JGRPackageManager;
import org.rosuda.JGR.robjects.RModel;
import org.rosuda.JGR.robjects.RObject;
import org.rosuda.JGR.toolkit.Editor;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.JRI.REXP;
import org.rosuda.ibase.SVar;
import org.rosuda.ibase.SVarDouble;
import org.rosuda.ibase.SVarFact;
import org.rosuda.ibase.SVarInt;
import org.rosuda.ibase.SVarObj;
import org.rosuda.ibase.SVarSet;
import org.rosuda.util.Global;

public class RController {
    public static Object dummy = new Object();

    public static String getRHome() {
        REXP rEXP = JGR.R.eval("R.home()");
        if (rEXP != null && rEXP.asStringArray() != null) {
            return rEXP.asStringArray()[0];
        }
        return "";
    }

    public static String[] getRLibs() {
        REXP rEXP = JGR.R.eval(".libPaths()");
        if (rEXP != null && rEXP.asStringArray() != null) {
            return rEXP.asStringArray();
        }
        return null;
    }

    public static String getRPrompt() {
        REXP rEXP = JGR.R.eval("try(as.character(options('prompt')),silent=TRUE)");
        if (rEXP != null && rEXP.asStringArray() != null) {
            return rEXP.asStringArray() == null ? "> " : rEXP.asStringArray()[0];
        }
        return "> ";
    }

    public static String getRContinue() {
        REXP rEXP = JGR.R.eval("try(as.character(options('continue')),silent=TRUE)");
        if (rEXP != null && rEXP.asStringArray() != null) {
            return rEXP.asStringArray() == null ? "> " : rEXP.asStringArray()[0];
        }
        return "> ";
    }

    public static String getCurrentPackages() {
        REXP rEXP = JGR.R.eval(".packages(TRUE)");
        if (rEXP != null && rEXP.asStringArray() != null) {
            String string = "";
            for (int i = 0; i < rEXP.asStringArray().length - 1; ++i) {
                string = string + rEXP.asStringArray()[i] + ",";
            }
            string = string + rEXP.asStringArray()[rEXP.asStringArray().length - 1];
            return string;
        }
        return null;
    }

    public static String[] getDefaultPackages() {
        REXP rEXP = JGR.R.eval("getOption(\"defaultPackages\")");
        if (rEXP != null && rEXP.asStringArray() != null) {
            return rEXP.asStringArray();
        }
        return new String[0];
    }

    public static String[] completeCommand(String string) {
        if (!JGR.STARTED) {
            return null;
        }
        int n = string.length() - 1;
        if (string.trim().length() == 0) {
            return null;
        }
        string = string.replaceAll("\\.", "\\\\\\\\.");
        REXP rEXP = JGR.R.idleEval("try(.completeCommand(\"" + string + "\"),silent=TRUE)");
        String[] stringArray = null;
        if (rEXP != null && (stringArray = rEXP.asStringArray()) != null) {
            return stringArray;
        }
        return null;
    }

    public static String[] completeFile(String string) {
        Object object;
        string = string.replaceFirst("~", System.getProperty("user.home"));
        int n = string.length();
        int n2 = n - 1;
        int n3 = 0;
        if (n == 0) {
            n2 = 0;
        }
        String string2 = null;
        boolean bl = false;
        String string3 = null;
        if (System.getProperty("os.name").startsWith("Windows")) {
            string = string.replaceAll(":/", "://");
        }
        while (n2 > 0 && string.charAt(n2) != '/') {
            --n2;
        }
        if (n2 == 0 && (n == 0 || string.charAt(n2) != '/')) {
            bl = true;
        }
        string2 = bl ? "." : (n2 == 0 ? "/" : string.substring(0, n2));
        n3 = n2;
        if (n3 < n && string.charAt(n3) == '/') {
            ++n3;
        }
        string3 = n3 < n ? string.substring(n3) : "";
        File file = null;
        String[] stringArray = null;
        file = new File(string2);
        if (file.exists()) {
            stringArray = file.list();
        }
        if (stringArray == null) {
            return null;
        }
        int n4 = -1;
        int n5 = 0;
        Vector<String> vector = new Vector<String>();
        String string4 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            if (!((String)object).startsWith(string3)) continue;
            if (n5 == 0) {
                n4 = i;
                string4 = object;
            } else {
                string4 = RController.commonWithPrefix(string4, (String)object);
            }
            ++n5;
            if (JGRPrefs.showHiddenFiles) {
                vector.add((String)object);
                continue;
            }
            if (((String)object).trim().startsWith(".")) continue;
            vector.add((String)object);
        }
        if (string4 != null && vector.size() == 1) {
            String string5 = string4.replace('\\', '/');
            object = null;
            boolean bl2 = false;
            string5 = string2 == "." ? string5 : (string2 == "/" ? "/" + string5 : string2 + "/" + string5);
            object = new File(string5);
            if (((File)object).exists() && (bl2 = ((File)object).isDirectory())) {
                string5 = string5 + "/";
            }
            if (string5.endsWith("//")) {
                string5 = "";
            }
            return new String[]{string5.replaceFirst(string, "")};
        }
        if (vector.size() > 1) {
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public static String[] getKeyWords() {
        REXP rEXP = JGR.R.idleEval(".refreshKeyWords()");
        String[] stringArray = null;
        if (rEXP != null && (stringArray = rEXP.asStringArray()) != null) {
            return stringArray;
        }
        return stringArray;
    }

    public static String[] getObjects() {
        REXP rEXP = JGR.R.idleEval(".refreshObjects()");
        String[] stringArray = null;
        if (rEXP != null && (stringArray = rEXP.asStringArray()) != null) {
            return stringArray;
        }
        return stringArray;
    }

    public static void refreshObjects() {
        String[] stringArray;
        String[] stringArray2;
        int n;
        int n2;
        String[] stringArray3;
        String[] stringArray4;
        JGR.DATA.clear();
        JGR.OTHERS.clear();
        JGR.MODELS.clear();
        JGR.FUNCTIONS.clear();
        REXP rEXP = JGR.R.idleEval(".getModels()");
        if (rEXP != null && (stringArray4 = rEXP.asStringArray()) != null) {
            for (int i = 0; i < stringArray4.length; ++i) {
                JGR.MODELS.add(RController.createRModel(stringArray4[i], stringArray4[++i]));
            }
        }
        if ((rEXP = JGR.R.idleEval(".getDataObjects()")) != null && (stringArray3 = rEXP.asStringArray()) != null) {
            int n3 = 1;
            for (n2 = 0; n2 < stringArray3.length; ++n2) {
                n = stringArray3[n2].equals("null") || stringArray3[n2].trim().length() == 0 ? 1 : 0;
                String string = n != 0 ? n3 + "" : stringArray3[n2];
                JGR.DATA.add(RController.createRObject(string, stringArray3[++n2], null, n == 0));
                ++n3;
            }
        }
        if ((rEXP = JGR.R.idleEval(".getOtherObjects()")) != null && (stringArray2 = rEXP.asStringArray()) != null) {
            n2 = 1;
            for (n = 0; n < stringArray2.length; ++n) {
                boolean bl = stringArray2[n].equals("null") || stringArray2[n].trim().length() == 0;
                String string = bl ? n2 + "" : stringArray2[n];
                JGR.OTHERS.add(RController.createRObject(string, stringArray2[++n], null, !bl));
                ++n2;
            }
        }
        if ((rEXP = JGR.R.idleEval(".getFunctionsInWS()")) != null && (stringArray = rEXP.asStringArray()) != null) {
            n = 1;
            for (int i = 0; i < stringArray.length; ++i) {
                JGR.FUNCTIONS.add(RController.createRObject(stringArray[i], "function", null, true));
                ++n;
            }
        }
    }

    public static Object[][] refreshPackages() {
        Object[][] objectArray = null;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        REXP rEXP = JGR.R.eval("sort(.packages(all.available=T))");
        if (rEXP != null && rEXP.asStringArray() != null) {
            int n;
            String[] stringArray;
            REXP rEXP2 = JGR.R.eval("(.packages())");
            if (rEXP2 != null && (stringArray = rEXP2.asStringArray()) != null) {
                for (n = 0; n < stringArray.length; ++n) {
                    hashtable.put(stringArray[n], dummy);
                }
            }
            stringArray = rEXP.asStringArray();
            objectArray = new Object[stringArray.length][4];
            for (n = 0; n < stringArray.length; ++n) {
                objectArray[n][2] = new String(stringArray[n]);
                try {
                    objectArray[n][3] = JGR.R.eval("packageDescription(\"" + stringArray[n] + "\",fields=\"Title\")").asString();
                }
                catch (Exception exception) {
                    objectArray[n][1] = "";
                }
                objectArray[n][0] = hashtable.containsKey(stringArray[n]) ? new Boolean(true) : new Boolean(false);
                objectArray[n][1] = new Boolean(false);
                for (int i = 0; i < JGRPackageManager.defaultPackages.length; ++i) {
                    if (!stringArray[n].equals(JGRPackageManager.defaultPackages[i]) && !JGRPackageManager.neededPackages.containsKey(stringArray[n])) continue;
                    objectArray[n][1] = new Boolean(true);
                }
            }
        }
        return objectArray;
    }

    public static Vector createContent(RObject rObject, Collection collection) {
        String[] stringArray;
        REXP rEXP;
        Vector<RObject> vector = new Vector<RObject>();
        String string = "";
        if (rObject.getParent() != null && rObject.getParent().getType().equals("table")) {
            string = "," + rObject.getParent().getRName();
        }
        if ((rEXP = JGR.R.eval("suppressWarnings(try(.getContent(" + rObject.getRName() + string + "),silent=TRUE))")) != null && (stringArray = rEXP.asStringArray()) != null && !stringArray[0].startsWith("Error")) {
            int n = 1;
            for (int i = 0; i < stringArray.length; ++i) {
                RObject rObject2;
                boolean bl = stringArray[i].equals("null") || stringArray[i].trim().length() == 0;
                String string2 = bl ? n + "" : stringArray[i];
                if ((rObject2 = RController.createRObject(string2, stringArray[++i], rObject, !bl)) != null) {
                    vector.add(rObject2);
                }
                ++n;
            }
        }
        return vector;
    }

    public static RObject createRObject(String string, String string2, RObject rObject, boolean bl) {
        REXP rEXP;
        RObject rObject2 = new RObject(string, string2, rObject, bl);
        if (string2.equals("data.frame")) {
            REXP rEXP2 = JGR.R.eval("dim(" + rObject2.getRName() + ")");
            if (rEXP2 != null && rEXP2.asIntArray() != null) {
                rObject2.setInfo("dim(" + rEXP2.asIntArray()[0] + ":" + rEXP2.asIntArray()[1] + ")");
            }
        } else if (string2.equals("matrix")) {
            REXP rEXP3 = JGR.R.eval("dim(" + rObject2.getRName() + ")");
            if (rEXP3 != null && rEXP3.asIntArray() != null) {
                rObject2.setInfo("dim(" + rEXP3.asIntArray()[0] + ":" + rEXP3.asIntArray()[1] + ")");
            }
        } else if (string2.equals("factor")) {
            REXP rEXP4 = JGR.R.eval("length(levels(" + rObject2.getRName() + "))");
            if (rEXP4 != null && rEXP4.asIntArray() != null) {
                rObject2.setInfo("levels: " + rEXP4.asIntArray()[0]);
            }
        } else if (string2.equals("list")) {
            REXP rEXP5 = JGR.R.eval("length(" + rObject2.getRName() + ")");
            if (rEXP5 != null && rEXP5.asIntArray() != null) {
                rObject2.setInfo("length: " + rEXP5.asIntArray()[0]);
            }
        } else if (string2.equals("table")) {
            REXP rEXP6 = JGR.R.eval("length(dim(" + rObject2.getRName() + "))");
            if (rEXP6 != null && rEXP6.asIntArray() != null) {
                rObject2.setInfo("dim: " + rEXP6.asIntArray()[0]);
            }
        } else if (string2.equals("function")) {
            rObject2.setInfo("arguments: " + RController.getFunHelp(rObject2.getRName()).replaceFirst(rObject2.getRName(), "").replaceAll("<br>", ""));
        } else if (rObject != null && rObject.getType().equals("table") && (rEXP = JGR.R.eval("length(dimnames(" + rObject.getRName() + ")[[\"" + rObject2.getName() + "\"]])")) != null && rEXP.asIntArray() != null) {
            rObject2.setInfo("cats: " + rEXP.asIntArray()[0]);
        }
        return rObject2;
    }

    public static RModel createRModel(String string, String string2) {
        int n;
        String string3;
        String[] stringArray;
        int[] nArray;
        double[] dArray;
        RModel rModel = new RModel(string, string2);
        REXP rEXP = JGR.R.eval("summary(" + string + ")[[\"r.squared\"]]");
        if (rEXP != null && (dArray = rEXP.asDoubleArray()) != null) {
            rModel.setRsquared(dArray[0]);
        }
        if ((rEXP = JGR.R.eval("AIC(" + string + ")")) != null && (dArray = rEXP.asDoubleArray()) != null) {
            rModel.setAic(dArray[0]);
        }
        if ((rEXP = JGR.R.eval("deviance(" + string + ")")) != null && (dArray = rEXP.asDoubleArray()) != null) {
            rModel.setDeviance(dArray[0]);
        }
        if ((rEXP = JGR.R.eval("summary(" + string + ")[[\"df\"]]")) != null && (nArray = rEXP.asIntArray()) != null) {
            rModel.setDf(nArray[0]);
        }
        if ((rEXP = JGR.R.eval("family(" + string + ")[[\"family\"]]")) != null && (stringArray = rEXP.asStringArray()) != null) {
            rModel.setFamily(stringArray[0]);
        }
        if ((rEXP = JGR.R.eval("suppressWarnings(try(capture.output(" + string + "[[\"call\"]][[\"formula\"]])))")) != null && (stringArray = rEXP.asStringArray()) != null) {
            string3 = "";
            for (n = 0; n < stringArray.length; ++n) {
                string3 = string3 + stringArray[n];
            }
            rModel.setCall(string3);
        }
        if ((rEXP = JGR.R.eval("suppressWarnings(try(capture.output(" + string + "[[\"call\"]][[\"data\"]])))")) != null && (stringArray = rEXP.asStringArray()) != null) {
            string3 = "";
            for (n = 0; n < stringArray.length; ++n) {
                string3 = string3 + stringArray[n];
            }
            if (!string3.trim().equals("NULL")) {
                rModel.setData(string3);
            }
        }
        return rModel;
    }

    public static String getFunHelpTip(String string) {
        String string2 = RController.getFunHelp(string);
        return string2 != null ? "<html><pre>" + string2 + "</pre></html>" : null;
    }

    private static String getFunHelp(String string) {
        REXP rEXP;
        if (string == null) {
            return null;
        }
        String string2 = null;
        String[] stringArray = null;
        try {
            rEXP = JGR.R.idleEval("try(deparse(args(" + string + ")),silent=T)");
        }
        catch (Exception exception) {
            return null;
        }
        if (rEXP != null && (stringArray = rEXP.asStringArray()) != null) {
            string2 = "";
            int n = -1;
            for (int i = 0; i < (n = stringArray.length); ++i) {
                if (n - 2 == i && !stringArray[i].trim().equals("NULL")) {
                    string2 = string2 + stringArray[i].replaceFirst("function", string);
                    continue;
                }
                if (stringArray[i].trim().equals("NULL")) continue;
                string2 = string2 + stringArray[i].replaceFirst("function", string) + "<br>";
            }
        } else {
            return null;
        }
        string2 = string2 + "";
        if (string2.trim().length() == 0) {
            return null;
        }
        return string2.indexOf("Error") >= 0 ? null : string2;
    }

    public static String getSummary(RObject rObject) {
        int n;
        REXP rEXP;
        if (rObject.getType().equals("function")) {
            return "<html><pre>" + RController.getFunHelp(rObject.getRName()) + "</pre></html>";
        }
        String string = "";
        String[] stringArray = null;
        try {
            rEXP = JGR.R.idleEval("suppressWarnings(try(capture.output(summary(" + rObject.getRName() + ")),silent=TRUE))");
        }
        catch (Exception exception) {
            return null;
        }
        if (rEXP != null && (stringArray = rEXP.asStringArray()) != null && !stringArray[0].startsWith("Error")) {
            n = -1;
            for (int i = ((n = stringArray.length) > 10 ? 10 : n) - 1; i >= 0; --i) {
                string = i < n - 1 ? stringArray[i] + "<br>" + string : stringArray[i] + "       ";
            }
        } else {
            return null;
        }
        string = "<html><pre>" + string + (n > 10 ? "..." : "") + "</pre></html>";
        return string.startsWith("<html><pre>Error") ? null : string;
    }

    public static void newFunction(RObject rObject) {
        String[] stringArray;
        REXP rEXP = JGR.R.eval("suppressWarnings(try(capture.output(" + rObject.getRName() + "),silent=TRUE))");
        if (rEXP != null && (stringArray = rEXP.asStringArray()) != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                if (i == 0) {
                    stringBuffer.append(rObject.getRName() + " <- " + stringArray[i] + "\n");
                    continue;
                }
                stringBuffer.append(stringArray[i] + "\n");
            }
            if (stringBuffer.length() > 0) {
                new Editor().setText(stringBuffer);
            }
        }
    }

    public static SVarSet newSet(RObject rObject) {
        SVar sVar;
        String[] stringArray;
        SVarSet sVarSet = new SVarSet();
        sVarSet.setName(rObject.getRName());
        if (rObject.getType().equals("function")) {
            String[] stringArray2;
            REXP rEXP = JGR.R.eval("suppressWarnings(try(capture.output(" + rObject.getRName() + "),silent=TRUE))");
            if (rEXP != null && (stringArray2 = rEXP.asStringArray()) != null) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (i == 0) {
                        stringBuffer.append(rObject.getRName() + " <- " + stringArray2[i] + "\n");
                        continue;
                    }
                    stringBuffer.append(stringArray2[i] + "\n");
                }
                if (stringBuffer.length() > 0) {
                    new Editor().setText(stringBuffer);
                }
            }
            return null;
        }
        REXP rEXP = JGR.R.eval("suppressWarnings(try(attributes(" + rObject.getRName() + ")[[\"row.names\"]],silent=TRUE))");
        if (rEXP != null && (stringArray = rEXP.asStringArray()) != null && !stringArray[0].startsWith("Error")) {
            sVar = RController.newVar(sVarSet, "row.names", rEXP.asStringArray());
            sVarSet.add(sVar);
        }
        if (!(sVar = RController.createContent(rObject, null).iterator()).hasNext()) {
            sVarSet.add(RController.createSVar(sVarSet, rObject));
        }
        while (sVar.hasNext()) {
            RObject rObject2 = (RObject)sVar.next();
            sVarSet.add(RController.createSVar(sVarSet, rObject2));
        }
        return sVarSet;
    }

    private static SVar createSVar(SVarSet sVarSet, RObject rObject) {
        REXP rEXP = JGR.R.eval("suppressWarnings(try(" + rObject.getRName() + ",silent=TRUE))");
        if (rEXP != null && rEXP.asStringArray() != null && rEXP.asStringArray().length > 0 && rEXP.asStringArray()[0].startsWith("Error")) {
            return null;
        }
        SVar sVar = null;
        if (rObject.getType().equals("factor")) {
            REXP rEXP2 = JGR.R.eval("suppressWarnings(try(levels(" + rObject.getRName() + "),silent=TRUE))");
            rEXP = JGR.R.eval("suppressWarnings(try(as.integer(" + rObject.getRName() + "),silent=TRUE))");
            if (rEXP2 != null && rEXP != null && rEXP2.asStringArray() != null && rEXP.asIntArray() != null) {
                int[] nArray = new int[rEXP.asIntArray().length];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = rEXP.asIntArray()[i];
                }
                sVar = RController.newVar(sVarSet, rObject.getName(), nArray, rEXP2.asStringArray());
            }
        } else if (rObject.getType().equals("character")) {
            if (rEXP != null && rEXP.asStringArray() != null) {
                sVar = RController.newVar(sVarSet, rObject.getName(), rEXP.asStringArray());
            }
        } else if (rEXP != null && rEXP.asIntArray() != null) {
            sVar = RController.newVar(sVarSet, rObject.getName(), rEXP.asIntArray());
        } else if (rEXP != null && rEXP.asDoubleArray() != null) {
            sVar = RController.newVar(sVarSet, rObject.getName(), rEXP.asDoubleArray());
        }
        return sVar;
    }

    public static SVar newVar(SVarSet sVarSet, String string, double[] object) {
        Object object2;
        if (object == null) {
            return null;
        }
        if (Global.DEBUG > 0) {
            System.out.println("newVar: double[" + ((double[])object).length + "]");
        }
        if (sVarSet.count() > 0 && sVarSet.at(0).size() != ((double[])object).length) {
            object2 = new double[sVarSet.at(0).size()];
            for (int i = 0; i < ((double[])object).length && i < ((SVarDouble)object2).length; ++i) {
                object2[i] = (SVarDouble)object[i];
            }
            object = object2;
        }
        object2 = new SVarDouble(string, object);
        return object2;
    }

    public static SVar newVar(SVarSet sVarSet, String string, int[] object) {
        Object object2;
        if (object == null) {
            return null;
        }
        if (Global.DEBUG > 0) {
            System.out.println("newVar: int[" + ((int[])object).length + "]");
        }
        if (sVarSet.count() > 0 && sVarSet.at(0).size() != ((int[])object).length) {
            object2 = new int[sVarSet.at(0).size()];
            for (int i = 0; i < ((int[])object).length && i < ((SVarInt)object2).length; ++i) {
                object2[i] = (SVarInt)object[i];
            }
            object = object2;
        }
        object2 = new SVarInt(string, object);
        return object2;
    }

    public static SVar newVar(SVarSet sVarSet, String string, String[] stringArray) {
        int n;
        String[] stringArray2;
        if (stringArray == null) {
            return null;
        }
        if (Global.DEBUG > 0) {
            System.out.println("newVar: String[]");
        }
        if (sVarSet.count() > 0 && sVarSet.at(0).size() != stringArray.length) {
            stringArray2 = new String[sVarSet.at(0).size()];
            for (n = 0; n < stringArray.length && n < stringArray2.length; ++n) {
                stringArray2[n] = stringArray[n];
            }
            stringArray = stringArray2;
        }
        stringArray2 = new SVarObj(string);
        n = 0;
        while (n < stringArray.length) {
            stringArray2.add((Object)stringArray[n++]);
        }
        return stringArray2;
    }

    public static SVar newVar(SVarSet sVarSet, String string, int[] nArray, String[] stringArray) {
        if (nArray == null) {
            return null;
        }
        if (stringArray == null) {
            return RController.newVar(sVarSet, string, nArray);
        }
        if (Global.DEBUG > 0) {
            System.out.println("newVar: int[" + nArray.length + "] + levels[" + stringArray.length + "]");
        }
        if (sVarSet.count() > 0 && sVarSet.at(0).size() != nArray.length) {
            int[] nArray2 = new int[sVarSet.at(0).size()];
            for (int i = 0; i < stringArray.length && i < nArray2.length; ++i) {
                nArray2[i] = nArray[i];
            }
            nArray = nArray2;
        }
        int n = 0;
        while (n < nArray.length) {
            int n2 = n++;
            nArray[n2] = nArray[n2] - 1;
        }
        SVarFact sVarFact = new SVarFact(string, nArray, stringArray);
        return sVarFact;
    }

    public static boolean export(SVarSet sVarSet, String string) {
        boolean bl = false;
        if (string == null || string.equals("data.frame")) {
            bl = RController.exportDataFrame(sVarSet);
        } else if (string != null && string.equals("matrix")) {
            bl = RController.exportMatrix(sVarSet);
        } else if (string != null && string.equals("list")) {
            bl = RController.exportList(sVarSet);
        } else if (string != null && string.equals("numeric")) {
            bl = RController.exportNumeric(sVarSet);
        } else if (string != null && string.equals("integer")) {
            bl = RController.exportInteger(sVarSet);
        } else if (string != null && string.equals("character")) {
            bl = RController.exportCharacter(sVarSet);
        } else if (string != null && string.equals("factor")) {
            bl = RController.exportFactor(sVarSet);
        }
        return bl;
    }

    private static boolean setName(String string) {
        try {
            JGR.R.eval(string + "<- jgrtemp");
            JGR.R.eval("rm(jgrtemp)");
            return true;
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
            return false;
        }
    }

    private static boolean exportNumeric(SVarSet sVarSet) {
        try {
            if (sVarSet.count() > 1) {
                return false;
            }
            long l = JGR.R.rniPutDoubleArray(((SVarDouble)sVarSet.at((int)0)).cont);
            JGR.R.rniAssign("jgrtemp", l, 0L);
            return RController.setName(sVarSet.getName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private static boolean exportInteger(SVarSet sVarSet) {
        try {
            if (sVarSet.count() > 1) {
                return false;
            }
            long l = JGR.R.rniPutIntArray(((SVarInt)sVarSet.at((int)0)).cont);
            JGR.R.rniAssign("jgrtemp", l, 0L);
            return RController.setName(sVarSet.getName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private static boolean exportFactor(SVarSet sVarSet) {
        try {
            if (sVarSet.count() > 1) {
                return false;
            }
            int[] nArray = new int[((SVarFact)sVarSet.at((int)0)).cont.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = ((SVarFact)sVarSet.at((int)0)).cont[i] + 1;
            }
            long l = JGR.R.rniPutIntArray(nArray);
            long l2 = JGR.R.rniPutString("factor");
            JGR.R.rniSetAttr(l, "class", l2);
            long l3 = JGR.R.rniPutStringArray(((SVarFact)sVarSet.at((int)0)).cats);
            JGR.R.rniSetAttr(l, "levels", l3);
            JGR.R.rniAssign("jgrtemp", l, 0L);
            return RController.setName(sVarSet.getName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private static boolean exportCharacter(SVarSet sVarSet) {
        try {
            if (sVarSet.count() > 1) {
                return false;
            }
            long l = JGR.R.rniPutStringArray(((SVarObj)sVarSet.at(0)).getContent());
            JGR.R.rniAssign("jgrtemp", l, 0L);
            return RController.setName(sVarSet.getName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private static boolean exportDataFrame(SVarSet sVarSet) {
        try {
            long l;
            int n;
            boolean bl = false;
            String[] stringArray = new String[sVarSet.length()];
            SVar sVar = null;
            int n2 = 0;
            for (int i = 0; i < sVarSet.count(); ++i) {
                if (!sVarSet.at(i).getName().equals("row.names")) continue;
                int n3 = stringArray.length;
                for (n = 0; n < stringArray.length; ++n) {
                    Object object = ((SVarObj)sVarSet.at(i)).at(n);
                    if (object != null) {
                        stringArray[n] = object.toString();
                        continue;
                    }
                    stringArray[n] = n3 - 1 + "";
                    ++n3;
                }
                bl = true;
                n2 = i;
                sVar = sVarSet.at(i);
                sVarSet.remove(i);
                break;
            }
            long[] lArray = new long[sVarSet.count()];
            String[] stringArray2 = new String[sVarSet.count()];
            for (n = 0; n < sVarSet.count(); ++n) {
                long l2;
                stringArray2[n] = sVarSet.at(n).getName();
                if (sVarSet.at(n).getClass().getName().equals("org.rosuda.ibase.SVarDouble")) {
                    long l3;
                    lArray[n] = l3 = JGR.R.rniPutDoubleArray(((SVarDouble)sVarSet.at((int)n)).cont);
                    continue;
                }
                if (sVarSet.at(n).getClass().getName().equals("org.rosuda.ibase.SVarInt")) {
                    long l4;
                    lArray[n] = l4 = JGR.R.rniPutIntArray(((SVarInt)sVarSet.at((int)n)).cont);
                    continue;
                }
                if (sVarSet.at(n).getClass().getName().equals("org.rosuda.ibase.SVarFact")) {
                    int[] nArray = new int[((SVarFact)sVarSet.at((int)n)).cont.length];
                    String[] stringArray3 = ((SVarFact)sVarSet.at((int)n)).cats;
                    boolean bl2 = false;
                    for (int i = 0; i < nArray.length; ++i) {
                        nArray[i] = ((SVarFact)sVarSet.at((int)n)).cont[i] + 1;
                        if (nArray[i] != 0) continue;
                        bl2 = true;
                        nArray[i] = stringArray3.length + 1;
                    }
                    if (bl2) {
                        String[] stringArray4 = new String[stringArray3.length + 1];
                        System.arraycopy(stringArray3, 0, stringArray4, 0, stringArray3.length);
                        stringArray4[stringArray4.length - 1] = "NA";
                        stringArray3 = stringArray4;
                        bl2 = false;
                    }
                    long l5 = JGR.R.rniPutIntArray(nArray);
                    l = JGR.R.rniPutString("factor");
                    JGR.R.rniSetAttr(l5, "class", l);
                    long l6 = JGR.R.rniPutStringArray(stringArray3);
                    JGR.R.rniSetAttr(l5, "levels", l6);
                    lArray[n] = l5;
                    continue;
                }
                if (!sVarSet.at(n).getClass().getName().equals("org.rosuda.ibase.SVarObj")) continue;
                lArray[n] = l2 = JGR.R.rniPutStringArray(((SVarObj)sVarSet.at(n)).getContent());
            }
            long l7 = JGR.R.rniPutVector(lArray);
            long l8 = JGR.R.rniPutStringArray(stringArray2);
            JGR.R.rniSetAttr(l7, "names", l8);
            if (!bl) {
                for (int i = 1; i <= stringArray.length; ++i) {
                    stringArray[i - 1] = i + "";
                }
            }
            long l9 = JGR.R.rniPutStringArray(stringArray);
            JGR.R.rniSetAttr(l7, "row.names", l9);
            l = JGR.R.rniPutString("data.frame");
            JGR.R.rniSetAttr(l7, "class", l);
            JGR.R.rniAssign("jgrtemp", l7, 0L);
            if (bl) {
                sVarSet.insert(n2, sVar);
            }
            return RController.setName(sVarSet.getName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private static boolean exportMatrix(SVarSet sVarSet) {
        try {
            long l;
            Object[] objectArray;
            String[] stringArray = new String[sVarSet.count()];
            int n = sVarSet.at(0).size();
            boolean bl = false;
            if (sVarSet.at(0).getClass().getName().equals("org.rosuda.ibase.SVarDouble")) {
                objectArray = new double[sVarSet.count() * n];
            } else if (sVarSet.at(0).getClass().getName().equals("org.rosuda.ibase.SVarInt")) {
                objectArray = new int[sVarSet.count() * n];
                bl = true;
            } else {
                return false;
            }
            for (int i = 0; i < sVarSet.count(); ++i) {
                stringArray[i] = sVarSet.at(i).getName();
                if (bl) {
                    System.arraycopy(((SVarInt)sVarSet.at((int)i)).cont, 0, objectArray, i * n, n);
                    continue;
                }
                System.arraycopy(((SVarDouble)sVarSet.at((int)i)).cont, 0, objectArray, i * n, n);
            }
            long l2 = bl ? JGR.R.rniPutIntArray((int[])objectArray) : JGR.R.rniPutDoubleArray(objectArray);
            long[] lArray = new long[2];
            long l3 = JGR.R.rniPutStringArray(stringArray);
            String[] stringArray2 = new String[sVarSet.length()];
            for (int i = 1; i <= stringArray2.length; ++i) {
                stringArray2[i - 1] = i + "";
            }
            lArray[0] = l = JGR.R.rniPutStringArray(stringArray2);
            lArray[1] = l3;
            long l4 = JGR.R.rniPutVector(lArray);
            double[] dArray = new double[]{n, sVarSet.count()};
            long l5 = JGR.R.rniPutDoubleArray(dArray);
            JGR.R.rniSetAttr(l2, "dim", l5);
            JGR.R.rniSetAttr(l2, "dimnames", l4);
            long l6 = JGR.R.rniPutString("matrix");
            JGR.R.rniSetAttr(l2, "class", l6);
            JGR.R.rniAssign("jgrtemp", l2, 0L);
            return RController.setName(sVarSet.getName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private static boolean exportList(SVarSet sVarSet) {
        try {
            long l;
            long[] lArray = new long[sVarSet.count()];
            String[] stringArray = new String[sVarSet.count()];
            for (int i = 0; i < sVarSet.count(); ++i) {
                long l2;
                stringArray[i] = sVarSet.at(i).getName();
                if (sVarSet.at(i).getClass().getName().equals("org.rosuda.ibase.SVarDouble")) {
                    long l3;
                    lArray[i] = l3 = JGR.R.rniPutDoubleArray(((SVarDouble)sVarSet.at((int)i)).cont);
                    continue;
                }
                if (sVarSet.at(i).getClass().getName().equals("org.rosuda.ibase.SVarInt")) {
                    long l4;
                    lArray[i] = l4 = JGR.R.rniPutIntArray(((SVarInt)sVarSet.at((int)i)).cont);
                    continue;
                }
                if (sVarSet.at(i).getClass().getName().equals("org.rosuda.ibase.SVarFact")) {
                    int[] nArray = new int[((SVarFact)sVarSet.at((int)i)).cont.length];
                    for (int j = 0; j < nArray.length; ++j) {
                        nArray[j] = ((SVarFact)sVarSet.at((int)i)).cont[j] + 1;
                    }
                    l = JGR.R.rniPutIntArray(nArray);
                    long l5 = JGR.R.rniPutString("factor");
                    JGR.R.rniSetAttr(l, "class", l5);
                    long l6 = JGR.R.rniPutStringArray(((SVarFact)sVarSet.at((int)i)).cats);
                    JGR.R.rniSetAttr(l, "levels", l6);
                    lArray[i] = l;
                    continue;
                }
                if (!sVarSet.at(i).getClass().getName().equals("org.rosuda.ibase.SVarObj")) continue;
                lArray[i] = l2 = JGR.R.rniPutStringArray(((SVarObj)sVarSet.at(i)).getContent());
            }
            long l7 = JGR.R.rniPutVector(lArray);
            l = JGR.R.rniPutStringArray(stringArray);
            JGR.R.rniSetAttr(l7, "names", l);
            JGR.R.rniAssign("jgrtemp", l7, 0L);
            return RController.setName(sVarSet.getName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static String commonWithPrefix(String string, String string2) {
        int n = Math.min(string.length(), string2.length());
        String string3 = "";
        String string4 = "";
        for (int i = 0; i < n && (string4 = string.substring(i, i + 1)).equals(string2.substring(i, i + 1)); ++i) {
            string3 = string3 + string4;
        }
        return string3;
    }
}

