/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.toolkit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.ibase.Common;

public class PrefsDialog
extends JDialog
implements ActionListener,
ItemListener {
    private final Dimension screenSize = Common.getScreenRes();
    private final String[] sizes = new String[]{"2", "4", "6", "8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24"};
    private String[] fonts;
    private final JComboBox font = new JComboBox();
    private final JComboBox size = new JComboBox();
    private DefaultComboBoxModel mf;
    private DefaultComboBoxModel ms;
    private final JSpinner helptabs = new JSpinner();
    private final JSpinner tabWidth = new JSpinner();
    private final JCheckBox useHelpAgent = new JCheckBox("Use Help Agent", JGRPrefs.useHelpAgent);
    private final JCheckBox useHelpAgentConsole = new JCheckBox("in Console", JGRPrefs.useHelpAgentConsole);
    private final JCheckBox useHelpAgentEditor = new JCheckBox("in Editor", JGRPrefs.useHelpAgentEditor);
    private final JCheckBox useEmacsKeyBindings = new JCheckBox("Use Emacs Key Bindings", JGRPrefs.useEmacsKeyBindings);
    private final JCheckBox showHiddenFiles = new JCheckBox("Show hidden files", JGRPrefs.showHiddenFiles);
    private final JTextField workinDirectory = new JTextField(JGRPrefs.workingDirectory);
    private final JButton cancel = new JButton("Cancel");
    private final JButton apply = new JButton("Apply");
    private final JButton save = new JButton("Save");

    public PrefsDialog() {
        this((JFrame)null);
    }

    public PrefsDialog(JFrame jFrame) {
        super(jFrame, "Preferences", false);
        this.helptabs.setMinimumSize(new Dimension(40, 24));
        this.helptabs.setPreferredSize(new Dimension(40, 24));
        this.helptabs.setMaximumSize(new Dimension(40, 24));
        this.helptabs.setValue(new Integer(JGRPrefs.maxHelpTabs));
        this.tabWidth.setMinimumSize(new Dimension(40, 24));
        this.tabWidth.setPreferredSize(new Dimension(40, 24));
        this.tabWidth.setMaximumSize(new Dimension(40, 24));
        this.tabWidth.setValue(new Integer(JGRPrefs.tabWidth));
        this.fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.mf = new DefaultComboBoxModel<String>(this.fonts);
        this.font.setModel(this.mf);
        this.ms = new DefaultComboBoxModel<String>(this.sizes);
        this.size.setModel(this.ms);
        this.mf.setSelectedItem(JGRPrefs.FontName);
        this.ms.setSelectedItem(new Integer(JGRPrefs.FontSize));
        this.font.setMinimumSize(new Dimension(200, 22));
        this.font.setPreferredSize(new Dimension(200, 22));
        this.font.setMaximumSize(new Dimension(200, 22));
        this.size.setMinimumSize(new Dimension(50, 22));
        this.size.setPreferredSize(new Dimension(50, 22));
        this.size.setMaximumSize(new Dimension(50, 22));
        this.size.setEditable(true);
        this.workinDirectory.setMinimumSize(new Dimension(300, 22));
        this.workinDirectory.setPreferredSize(new Dimension(300, 22));
        this.workinDirectory.setMaximumSize(new Dimension(300, 22));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(new JLabel("Font: "));
        jPanel2.add(this.font);
        jPanel2.add(new JLabel(" Size: "));
        jPanel2.add(this.size);
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.add(new JLabel("#Help Pages: "));
        jPanel3.add(this.helptabs);
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        jPanel4.add(new JLabel("Tabwidth:"));
        jPanel4.add(this.tabWidth);
        this.useHelpAgentConsole.setEnabled(this.useHelpAgent.isSelected());
        this.useHelpAgentEditor.setEnabled(this.useHelpAgent.isSelected());
        JPanel jPanel5 = new JPanel(new FlowLayout(0));
        jPanel5.add(new JLabel("  "));
        jPanel5.add(this.useHelpAgentConsole);
        JPanel jPanel6 = new JPanel(new FlowLayout(0));
        jPanel6.add(new JLabel("  "));
        jPanel6.add(this.useHelpAgentEditor);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 2, 2, 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.useHelpAgent, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)jPanel5, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)jPanel6, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        jPanel.add((Component)this.useEmacsKeyBindings, gridBagConstraints);
        gridBagConstraints.gridy = 6;
        jPanel.add((Component)new JLabel("* Emacs Keybindings are only advisable for Mac OS X!"), gridBagConstraints);
        gridBagConstraints.gridy = 7;
        jPanel.add((Component)this.showHiddenFiles, gridBagConstraints);
        gridBagConstraints.gridy = 8;
        jPanel.add((Component)jPanel4, gridBagConstraints);
        gridBagConstraints.gridy = 9;
        jPanel.add((Component)new JLabel(" Default working directory:"), gridBagConstraints);
        gridBagConstraints.gridy = 10;
        JButton jButton = new JButton("...");
        jButton.setMinimumSize(new Dimension(40, 22));
        jButton.setPreferredSize(new Dimension(40, 22));
        jButton.setMaximumSize(new Dimension(40, 22));
        jButton.setActionCommand("chooseWD");
        jButton.addActionListener(this);
        JPanel jPanel7 = new JPanel(new FlowLayout(0));
        jPanel7.add(this.workinDirectory);
        jPanel7.add(jButton);
        jPanel.add((Component)jPanel7, gridBagConstraints);
        this.cancel.setActionCommand("cancel");
        this.apply.setActionCommand("apply");
        this.save.setActionCommand("save");
        this.cancel.addActionListener(this);
        this.apply.addActionListener(this);
        this.save.addActionListener(this);
        this.cancel.setToolTipText("Cancel");
        this.apply.setToolTipText("Apply changes to current session");
        this.save.setToolTipText("Save changes for future sessions and quit");
        this.useHelpAgent.addItemListener(this);
        JPanel jPanel8 = new JPanel(new FlowLayout(2));
        jPanel8.add(this.cancel);
        jPanel8.add(this.apply);
        jPanel8.add(this.save);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "North");
        this.getContentPane().add((Component)jPanel8, "South");
        this.getRootPane().setDefaultButton(this.save);
        this.setResizable(false);
        this.setSize(new Dimension(420, 470));
        this.setLocation((this.screenSize.width - this.getSize().width) / 2, (this.screenSize.height - this.getSize().height) / 2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PrefsDialog.this.dispose();
            }
        });
        this.setVisible(true);
    }

    public void applyChanges() {
        JGRPrefs.FontName = this.font.getSelectedItem().toString();
        JGRPrefs.FontSize = new Integer(this.size.getSelectedItem().toString());
        JGRPrefs.maxHelpTabs = (Integer)this.helptabs.getValue();
        JGRPrefs.useHelpAgent = this.useHelpAgent.isSelected();
        JGRPrefs.useHelpAgentConsole = this.useHelpAgentConsole.isSelected();
        JGRPrefs.useHelpAgentEditor = this.useHelpAgentEditor.isSelected();
        JGRPrefs.useEmacsKeyBindings = this.useEmacsKeyBindings.isSelected();
        JGRPrefs.showHiddenFiles = this.showHiddenFiles.isSelected();
        JGRPrefs.workingDirectory = this.workinDirectory.getText().trim().length() == 0 ? System.getProperty("user.home") : this.workinDirectory.getText().trim();
        JGRPrefs.tabWidth = (Integer)this.tabWidth.getValue();
        JGRPrefs.apply();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "apply") {
            this.applyChanges();
        } else if (string == "cancel") {
            this.dispose();
        } else if (string == "chooseWD") {
            JFileChooser jFileChooser = new JFileChooser(JGRPrefs.workingDirectory);
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setDialogTitle("Choose Working Directory");
            jFileChooser.setApproveButtonText("Choose");
            int n = jFileChooser.showOpenDialog(this);
            if (n == 1) {
                return;
            }
            if (jFileChooser.getSelectedFile() != null) {
                this.workinDirectory.setText(jFileChooser.getSelectedFile().toString());
            }
        } else if (string == "save") {
            this.applyChanges();
            JGRPrefs.writePrefs(false);
            this.dispose();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.useHelpAgentConsole.setEnabled(this.useHelpAgent.isSelected());
        this.useHelpAgentEditor.setEnabled(this.useHelpAgent.isSelected());
        if (!this.useHelpAgent.isSelected()) {
            this.useHelpAgentEditor.setSelected(false);
            this.useHelpAgentConsole.setSelected(false);
        }
    }
}

