% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IIWcode.R
\name{extent.of.irregularity}
\alias{extent.of.irregularity}
\title{Measures of extent of visit irregularity
Provides visual and numeric measures of the extent of irregularity in observation times in a longitudinal dataset}
\usage{
extent.of.irregularity(
  data,
  time = "time",
  id = "id",
  scheduledtimes = NULL,
  cutpoints = NULL,
  ncutpts = NULL,
  maxfu = NULL,
  plot = FALSE,
  legendx = NULL,
  legendy = NULL,
  formula = NULL,
  tau = NULL
)
}
\arguments{
\item{data}{The data containing information on subject identifiers and visit times}

\item{time}{A character indicating which column of the data contains the times at which each of the observations in data was made}

\item{id}{A character indicating which column of the data contains subject identifiers. ids are assumed to be consecutive integers, with the first subject having id 1}

\item{scheduledtimes}{For studies with protocol-specified visit times, a vector of these times. Defaults to NULL, in which case it is assumed that there are no protocolized visit times}

\item{cutpoints}{For studies with scheduled visit times, an array of dimension ncutpts by length(scheduledtimes) by 2 giving, for ncutpts sets of left and right cutpoints for each protocolized scheduled visit times. The left-hand cutpoints correspond to cutpoints[,,1] and the right-hand cutpoints to cutpoints[,,2]. Defaults to NULL, in which case cutpoints are computed as described below.}

\item{ncutpts}{The number of sets of cutpoints to consider}

\item{maxfu}{The maximum follow-up time per subject. If all subjects have the same follow-up time, this can be supplied as a single number. Otherwise, maxfu should be a dataframe with the first column specifying subject identifiers and the second giving the follow-up time for each subject.}

\item{plot}{logical parameter indicating whether plots should be produced.}

\item{legendx}{The x-coordinate for the position of the legend in the plot of mean proportion of individuals with 0, 1 and $>$ 1 visit per bin.}

\item{legendy}{The y-coordinate for the position of the legend in the plot of mean proportion of individuals with 0, 1 and $>$ 1 visit per bin.}

\item{formula}{For studies without protocolized visit times, the formula for the null counting process model for the visit times}

\item{tau}{The maximum time of interest}
}
\value{
a list with counts equal to a 3-dimensional by ncutpts matrix giving, for each set of cutpoints, the mean proportion of individuals with zero, 1 and >1 visits per bin, and AUC, the area under the curve of the plot of the proportion of individuals with >1 visit per bin vs. the proportion of individuals with 0 visits per bin.
}
\description{
Measures of extent of visit irregularity
Provides visual and numeric measures of the extent of irregularity in observation times in a longitudinal dataset
}
\details{
This function provides plots and a numerical summary of the extent of irregularity in visit times. For any given set of cutpoints, it computes the proportion of individuals with 0, 1 and >1 observation(s) in each bin, then takes the mean over bins. The sizes of the bins are varied and these proportions are plotted against bin size. In addition, then mean proportion of individuals with >1 visit per bin is plotted vs. the mean proportion of individuals with 0 visits per bin, and the area under the curve is calculated (AUC). An AUC of 0 represents perfect repeated measures while a Poisson Process has an AUC of 0. If cutpoints are not supplied, they are computed as follows: (a) for studies with protocolized visit times, the left- and right-hand cutpoints are positioned at the protocolized time minus (or plus, for right-hand cutpoints) (1,...,ncutpts)/ncutpts times the gap to the previous (or next, respectively) protocolized visit time; (b) for studies with no protocolized visit times, cutpoints are calculated by finding, for each j in {1,...,ncutpts} the largest times for which the cumulative hazard is less than j divided by the cumulative hazard evaluated at the maximum time of interest. This corresponds to choosing cutpoints such that the expected number of visits per bin is roughly equal within each set.
}
