% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IIWcode.R
\name{iiw}
\alias{iiw}
\title{Given a proportional hazards model for visit intensities, compute inverse-intensity weights.}
\usage{
iiw(phfit, data, id, time, first)
}
\arguments{
\item{phfit}{coxph object for the visit process}

\item{data}{The dataset featuring longitudinal data subject to irregular observation for which inverse-intensity weights are desired}

\item{id}{character string indicating which column of the data identifies subjects}

\item{time}{character string indicating which column of the data contains the time at which the visit occurred}

\item{first}{logical variable. If TRUE, the first observation for each individual is assigned an intensity of 1. This is appropriate if the first visit is a baseline visit at which recruitment to the study occurred; in this case the baseline visit is observed with probability 1.}
}
\value{
A vector of inverse-intensity weights for each row of the dataset. The first observation for each subject is assumed to have an intensity of 1.
}
\description{
For a longitudinal dataset subject to irregular observation, use a Cox proportional hazards model for visit intensities to compute inverse intensity weights
}
\examples{
library(nlme)
data(Phenobarb)
library(survival)
library(geepack)
Phenobarb$id <- as.numeric(Phenobarb$Subject)
Phenobarb$event <- as.numeric(is.finite(Phenobarb$conc))
Phenobarb.conc <- Phenobarb[is.finite(Phenobarb$conc),]
Phenobarb.conc <- lagfn(Phenobarb.conc,c("time","conc"),"id","time")

mph <- coxph(Surv(time.lag,time,event)~I(conc.lag>0) + conc.lag + cluster(id),data=Phenobarb.conc)
summary(mph)
Phenobarb.conc$weight <- iiw(mph,Phenobarb.conc,"id","time",TRUE)
head(Phenobarb)
}
\seealso{
Other iiw: \code{\link{iiw.weights}}, \code{\link{iiwgee}}
}
\concept{iiw}
