/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver;

import cern.colt.matrix.Norm;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DenseDoubleAlgebra;
import cern.colt.matrix.tdouble.algo.solver.AbstractDoubleIterativeSolver;
import cern.colt.matrix.tdouble.algo.solver.DoubleNotConvergedException;
import cern.colt.matrix.tdouble.algo.solver.IterativeSolverDoubleNotConvergedException;
import cern.colt.matrix.tdouble.algo.solver.preconditioner.DoublePreconditioner;
import cern.jet.math.tdouble.DoubleFunctions;

public class DoubleQMR
extends AbstractDoubleIterativeSolver {
    private DoublePreconditioner M1;
    private DoublePreconditioner M2;
    private DoubleMatrix1D r;
    private DoubleMatrix1D y;
    private DoubleMatrix1D z;
    private DoubleMatrix1D v;
    private DoubleMatrix1D w;
    private DoubleMatrix1D p;
    private DoubleMatrix1D q;
    private DoubleMatrix1D d;
    private DoubleMatrix1D s;
    private DoubleMatrix1D v_tld;
    private DoubleMatrix1D w_tld;
    private DoubleMatrix1D y_tld;
    private DoubleMatrix1D z_tld;
    private DoubleMatrix1D p_tld;

    public DoubleQMR(DoubleMatrix1D doubleMatrix1D) {
        this.M1 = this.M;
        this.M2 = this.M;
        this.r = doubleMatrix1D.copy();
        this.y = doubleMatrix1D.copy();
        this.z = doubleMatrix1D.copy();
        this.v = doubleMatrix1D.copy();
        this.w = doubleMatrix1D.copy();
        this.p = doubleMatrix1D.copy();
        this.q = doubleMatrix1D.copy();
        this.d = doubleMatrix1D.copy();
        this.s = doubleMatrix1D.copy();
        this.v_tld = doubleMatrix1D.copy();
        this.w_tld = doubleMatrix1D.copy();
        this.y_tld = doubleMatrix1D.copy();
        this.z_tld = doubleMatrix1D.copy();
        this.p_tld = doubleMatrix1D.copy();
    }

    public DoubleQMR(DoubleMatrix1D doubleMatrix1D, DoublePreconditioner doublePreconditioner, DoublePreconditioner doublePreconditioner2) {
        this.M1 = doublePreconditioner;
        this.M2 = doublePreconditioner2;
        this.r = doubleMatrix1D.copy();
        this.y = doubleMatrix1D.copy();
        this.z = doubleMatrix1D.copy();
        this.v = doubleMatrix1D.copy();
        this.w = doubleMatrix1D.copy();
        this.p = doubleMatrix1D.copy();
        this.q = doubleMatrix1D.copy();
        this.d = doubleMatrix1D.copy();
        this.s = doubleMatrix1D.copy();
        this.v_tld = doubleMatrix1D.copy();
        this.w_tld = doubleMatrix1D.copy();
        this.y_tld = doubleMatrix1D.copy();
        this.z_tld = doubleMatrix1D.copy();
        this.p_tld = doubleMatrix1D.copy();
    }

    public DoubleMatrix1D solve(DoubleMatrix2D doubleMatrix2D, DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) throws IterativeSolverDoubleNotConvergedException {
        this.checkSizes(doubleMatrix2D, doubleMatrix1D, doubleMatrix1D2);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 1.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = -1.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        doubleMatrix2D.zMult(doubleMatrix1D2, this.r.assign(doubleMatrix1D), -1.0, 1.0, false);
        this.v_tld.assign(this.r);
        this.M1.apply(this.v_tld, this.y);
        d = DenseDoubleAlgebra.DEFAULT.norm(this.y, Norm.Two);
        this.w_tld.assign(this.r);
        this.M2.transApply(this.w_tld, this.z);
        d3 = DenseDoubleAlgebra.DEFAULT.norm(this.z, Norm.Two);
        this.iter.setFirst();
        while (!this.iter.converged(this.r, doubleMatrix1D2)) {
            if (d == 0.0) {
                throw new IterativeSolverDoubleNotConvergedException(DoubleNotConvergedException.Reason.Breakdown, "rho", this.iter);
            }
            if (d3 == 0.0) {
                throw new IterativeSolverDoubleNotConvergedException(DoubleNotConvergedException.Reason.Breakdown, "xi", this.iter);
            }
            this.v.assign(this.v_tld, DoubleFunctions.multSecond(1.0 / d));
            this.y.assign(DoubleFunctions.mult(1.0 / d));
            this.w.assign(this.w_tld, DoubleFunctions.multSecond(1.0 / d3));
            this.z.assign(DoubleFunctions.mult(1.0 / d3));
            d9 = this.z.zDotProduct(this.y);
            if (d9 == 0.0) {
                throw new IterativeSolverDoubleNotConvergedException(DoubleNotConvergedException.Reason.Breakdown, "delta", this.iter);
            }
            this.M2.apply(this.y, this.y_tld);
            this.M1.transApply(this.z, this.z_tld);
            if (this.iter.isFirst()) {
                this.p.assign(this.y_tld);
                this.q.assign(this.z_tld);
            } else {
                this.p.assign(this.y_tld, DoubleFunctions.plusMultFirst(-d3 * d9 / d10));
                this.q.assign(this.z_tld, DoubleFunctions.plusMultFirst(-d * d9 / d10));
            }
            doubleMatrix2D.zMult(this.p, this.p_tld);
            d10 = this.q.zDotProduct(this.p_tld);
            if (d10 == 0.0) {
                throw new IterativeSolverDoubleNotConvergedException(DoubleNotConvergedException.Reason.Breakdown, "ep", this.iter);
            }
            d11 = d10 / d9;
            if (d11 == 0.0) {
                throw new IterativeSolverDoubleNotConvergedException(DoubleNotConvergedException.Reason.Breakdown, "beta", this.iter);
            }
            this.v_tld.assign(this.v, DoubleFunctions.multSecond(-d11)).assign(this.p_tld, DoubleFunctions.plus);
            this.M1.apply(this.v_tld, this.y);
            d2 = d;
            d = DenseDoubleAlgebra.DEFAULT.norm(this.y, Norm.Two);
            doubleMatrix2D.zMult(this.q, this.w_tld.assign(this.w, DoubleFunctions.multSecond(-d11)), 1.0, 1.0, true);
            this.M2.transApply(this.w_tld, this.z);
            d3 = DenseDoubleAlgebra.DEFAULT.norm(this.z, Norm.Two);
            d5 = d4;
            d7 = d6;
            d6 = d / (d5 * d11);
            d4 = 1.0 / Math.sqrt(1.0 + d6 * d6);
            if (d4 == 0.0) {
                throw new IterativeSolverDoubleNotConvergedException(DoubleNotConvergedException.Reason.Breakdown, "gamma", this.iter);
            }
            d8 = -d8 * d2 * d4 * d4 / (d11 * d5 * d5);
            if (this.iter.isFirst()) {
                this.d.assign(this.p, DoubleFunctions.multSecond(d8));
                this.s.assign(this.p_tld, DoubleFunctions.multSecond(d8));
            } else {
                double d12 = d7 * d7 * d4 * d4;
                this.d.assign(DoubleFunctions.mult(d12)).assign(this.p, DoubleFunctions.plusMultSecond(d8));
                this.s.assign(DoubleFunctions.mult(d12)).assign(this.p_tld, DoubleFunctions.plusMultSecond(d8));
            }
            doubleMatrix1D2.assign(this.d, DoubleFunctions.plus);
            this.r.assign(this.s, DoubleFunctions.minus);
            this.iter.next();
        }
        return doubleMatrix1D2;
    }

    public void setPreconditioner(DoublePreconditioner doublePreconditioner) {
        super.setPreconditioner(doublePreconditioner);
        this.M1 = doublePreconditioner;
        this.M2 = doublePreconditioner;
    }
}

