/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo;

import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.function.tdouble.DoubleFunction;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DenseDoubleAlgebra;
import cern.colt.matrix.tdouble.algo.DoubleBlas;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.jet.math.tdouble.DoubleFunctions;
import cern.jet.math.tdouble.DoublePlusMultSecond;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class SmpDoubleBlas
implements DoubleBlas {
    public void assign(DoubleMatrix2D doubleMatrix2D, DoubleFunction doubleFunction) {
        doubleMatrix2D.assign(doubleFunction);
    }

    public void assign(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2, DoubleDoubleFunction doubleDoubleFunction) {
        doubleMatrix2D.assign(doubleMatrix2D2, doubleDoubleFunction);
    }

    public double dasum(DoubleMatrix1D doubleMatrix1D) {
        return doubleMatrix1D.aggregate(DoubleFunctions.plus, DoubleFunctions.abs);
    }

    public void daxpy(double d, DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        doubleMatrix1D2.assign(doubleMatrix1D, DoubleFunctions.plusMultSecond(d));
    }

    public void daxpy(double d, DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2) {
        doubleMatrix2D2.assign(doubleMatrix2D, DoubleFunctions.plusMultSecond(d));
    }

    public void dcopy(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        doubleMatrix1D2.assign(doubleMatrix1D);
    }

    public void dcopy(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2) {
        doubleMatrix2D2.assign(doubleMatrix2D);
    }

    public double ddot(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        return doubleMatrix1D.zDotProduct(doubleMatrix1D2);
    }

    public void dgemm(boolean bl, boolean bl2, double d, DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2, double d2, DoubleMatrix2D doubleMatrix2D3) {
        doubleMatrix2D.zMult(doubleMatrix2D2, doubleMatrix2D3, d, d2, bl, bl2);
    }

    public void dgemv(boolean bl, double d, DoubleMatrix2D doubleMatrix2D, DoubleMatrix1D doubleMatrix1D, double d2, DoubleMatrix1D doubleMatrix1D2) {
        doubleMatrix2D.zMult(doubleMatrix1D, doubleMatrix1D2, d, d2, bl);
    }

    public void dger(double d, DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2, DoubleMatrix2D doubleMatrix2D) {
        DoublePlusMultSecond doublePlusMultSecond = DoublePlusMultSecond.plusMult(0.0);
        int n = doubleMatrix2D.rows();
        for (int i = 0; i < n; ++i) {
            doublePlusMultSecond.multiplicator = d * doubleMatrix1D.getQuick(i);
            doubleMatrix2D.viewRow(i).assign(doubleMatrix1D2, doublePlusMultSecond);
        }
    }

    public double dnrm2(DoubleMatrix1D doubleMatrix1D) {
        return DenseDoubleAlgebra.DEFAULT.norm2(doubleMatrix1D);
    }

    public void drot(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2, double d, double d2) {
        doubleMatrix1D.checkSize(doubleMatrix1D2);
        DoubleMatrix1D doubleMatrix1D3 = doubleMatrix1D.copy();
        doubleMatrix1D.assign(DoubleFunctions.mult(d));
        doubleMatrix1D.assign(doubleMatrix1D2, DoubleFunctions.plusMultSecond(d2));
        doubleMatrix1D2.assign(DoubleFunctions.mult(d));
        doubleMatrix1D2.assign(doubleMatrix1D3, DoubleFunctions.minusMult(d2));
    }

    public void drotg(double d, double d2, double[] dArray) {
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8 = d2;
        if (Math.abs(d) > Math.abs(d2)) {
            d8 = d;
        }
        if ((d7 = Math.abs(d) + Math.abs(d2)) != 0.0) {
            double d9 = d / d7;
            double d10 = d2 / d7;
            d6 = d7 * Math.sqrt(d9 * d9 + d10 * d10);
            d6 = this.sign(1.0, d8) * d6;
            d5 = d / d6;
            d4 = d2 / d6;
            d3 = 1.0;
            if (Math.abs(d) > Math.abs(d2)) {
                d3 = d4;
            }
            if (Math.abs(d2) >= Math.abs(d) && d5 != 0.0) {
                d3 = 1.0 / d5;
            }
        } else {
            d5 = 1.0;
            d4 = 0.0;
            d6 = 0.0;
            d3 = 0.0;
        }
        d = d6;
        d2 = d3;
        dArray[0] = d;
        dArray[1] = d2;
        dArray[2] = d5;
        dArray[3] = d4;
    }

    public void dscal(double d, DoubleMatrix1D doubleMatrix1D) {
        doubleMatrix1D.assign(DoubleFunctions.mult(d));
    }

    public void dscal(double d, DoubleMatrix2D doubleMatrix2D) {
        doubleMatrix2D.assign(DoubleFunctions.mult(d));
    }

    public void dswap(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        doubleMatrix1D2.swap(doubleMatrix1D);
    }

    public void dswap(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2) {
        doubleMatrix2D.checkShape(doubleMatrix2D2);
        int n = doubleMatrix2D.rows();
        for (int i = 0; i < n; ++i) {
            doubleMatrix2D.viewRow(i).swap(doubleMatrix2D2.viewRow(i));
        }
    }

    public void dsymv(boolean bl, final double d, DoubleMatrix2D doubleMatrix2D, final DoubleMatrix1D doubleMatrix1D, final double d2, final DoubleMatrix1D doubleMatrix1D2) {
        final DoubleMatrix2D doubleMatrix2D2 = bl ? doubleMatrix2D.viewDice() : doubleMatrix2D;
        DoubleProperty.DEFAULT.checkSquare(doubleMatrix2D2);
        int n = doubleMatrix2D2.rows();
        if ((long)n != doubleMatrix1D.size() || (long)n != doubleMatrix1D2.size()) {
            throw new IllegalArgumentException(doubleMatrix2D2.toStringShort() + ", " + doubleMatrix1D.toStringShort() + ", " + doubleMatrix1D2.toStringShort());
        }
        final DoubleMatrix1D doubleMatrix1D3 = doubleMatrix1D.like();
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, n);
            Future[] futureArray = new Future[n2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            int n;
                            double d3 = 0.0;
                            for (n = 0; n <= i; ++n) {
                                d3 += doubleMatrix2D2.getQuick(i, n) * doubleMatrix1D.getQuick(n);
                            }
                            for (n = i + 1; n < n5; ++n) {
                                d3 += doubleMatrix2D2.getQuick(n, i) * doubleMatrix1D.getQuick(n);
                            }
                            doubleMatrix1D3.setQuick(i, d * d3 + d2 * doubleMatrix1D2.getQuick(i));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < n; ++i) {
                int n6;
                double d3 = 0.0;
                for (n6 = 0; n6 <= i; ++n6) {
                    d3 += doubleMatrix2D2.getQuick(i, n6) * doubleMatrix1D.getQuick(n6);
                }
                for (n6 = i + 1; n6 < n; ++n6) {
                    d3 += doubleMatrix2D2.getQuick(n6, i) * doubleMatrix1D.getQuick(n6);
                }
                doubleMatrix1D3.setQuick(i, d * d3 + d2 * doubleMatrix1D2.getQuick(i));
            }
        }
        doubleMatrix1D2.assign(doubleMatrix1D3);
    }

    public void dtrmv(boolean bl, boolean bl2, boolean bl3, DoubleMatrix2D doubleMatrix2D, final DoubleMatrix1D doubleMatrix1D) {
        int n;
        boolean bl4;
        DoubleMatrix2D doubleMatrix2D2;
        if (bl2) {
            doubleMatrix2D2 = doubleMatrix2D.viewDice();
            bl4 = !bl;
        } else {
            doubleMatrix2D2 = doubleMatrix2D;
            bl4 = bl;
        }
        DoubleProperty.DEFAULT.checkSquare(doubleMatrix2D2);
        int n2 = doubleMatrix2D2.rows();
        if ((long)n2 != doubleMatrix1D.size()) {
            throw new IllegalArgumentException(doubleMatrix2D2.toStringShort() + ", " + doubleMatrix1D.toStringShort());
        }
        final DoubleMatrix1D doubleMatrix1D2 = doubleMatrix1D.like();
        final DoubleMatrix1D doubleMatrix1D3 = doubleMatrix1D.like();
        if (bl3) {
            doubleMatrix1D3.assign(1.0);
        } else {
            for (n = 0; n < n2; ++n) {
                doubleMatrix1D3.setQuick(n, doubleMatrix2D2.getQuick(n, n));
            }
        }
        n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, n2);
            Future[] futureArray = new Future[n];
            int n3 = n2 / n;
            for (int i = 0; i < n; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n - 1 ? n2 : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            int n;
                            double d = 0.0;
                            if (!bl4) {
                                for (n = 0; n < i; ++n) {
                                    d += doubleMatrix2D2.getQuick(i, n) * doubleMatrix1D.getQuick(n);
                                }
                                d += doubleMatrix1D3.getQuick(i) * doubleMatrix1D.getQuick(i);
                            } else {
                                d += doubleMatrix1D3.getQuick(i) * doubleMatrix1D.getQuick(i);
                                for (n = i + 1; n < n5; ++n) {
                                    d += doubleMatrix2D2.getQuick(i, n) * doubleMatrix1D.getQuick(n);
                                }
                            }
                            doubleMatrix1D2.setQuick(i, d);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < n2; ++i) {
                int n6;
                double d = 0.0;
                if (!bl4) {
                    for (n6 = 0; n6 < i; ++n6) {
                        d += doubleMatrix2D2.getQuick(i, n6) * doubleMatrix1D.getQuick(n6);
                    }
                    d += doubleMatrix1D3.getQuick(i) * doubleMatrix1D.getQuick(i);
                } else {
                    d += doubleMatrix1D3.getQuick(i) * doubleMatrix1D.getQuick(i);
                    for (n6 = i + 1; n6 < n2; ++n6) {
                        d += doubleMatrix2D2.getQuick(i, n6) * doubleMatrix1D.getQuick(n6);
                    }
                }
                doubleMatrix1D2.setQuick(i, d);
            }
        }
        doubleMatrix1D.assign(doubleMatrix1D2);
    }

    public int idamax(DoubleMatrix1D doubleMatrix1D) {
        DoubleMatrix1D doubleMatrix1D2 = doubleMatrix1D.copy();
        doubleMatrix1D2.assign(DoubleFunctions.abs);
        double[] dArray = doubleMatrix1D2.getMaxLocation();
        return (int)dArray[1];
    }

    private double sign(double d, double d2) {
        if (d2 < 0.0) {
            return -Math.abs(d);
        }
        return Math.abs(d);
    }
}

