/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.function.tdcomplex.DComplexDComplexDComplexFunction;
import cern.colt.function.tdcomplex.DComplexDComplexFunction;
import cern.colt.function.tdcomplex.DComplexProcedure;
import cern.colt.function.tdcomplex.DComplexRealFunction;
import cern.colt.function.tdcomplex.IntIntDComplexFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.SelectedDenseColumnDComplexMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseColumnDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.jet.math.tdcomplex.DComplexFunctions;
import cern.jet.math.tdcomplex.DComplexMult;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_2D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DenseColumnDComplexMatrix2D
extends DComplexMatrix2D {
    static final long serialVersionUID = 1020177651L;
    private DoubleFFT_2D fft2;
    protected double[] elements;

    public DenseColumnDComplexMatrix2D(double[][] dArray) {
        this(dArray.length, dArray.length == 0 ? 0 : dArray[0].length / 2);
        this.assign(dArray);
    }

    public DenseColumnDComplexMatrix2D(DoubleMatrix2D doubleMatrix2D) {
        this(doubleMatrix2D.rows(), doubleMatrix2D.columns());
        this.assignReal(doubleMatrix2D);
    }

    public DenseColumnDComplexMatrix2D(int n, int n2) {
        this.setUp(n, n2, 0, 0, 2, 2 * n);
        this.elements = new double[n * 2 * n2];
    }

    public DenseColumnDComplexMatrix2D(int n, int n2, double[] dArray, int n3, int n4, int n5, int n6, boolean bl) {
        this.setUp(n, n2, n3, n4, n5, n6);
        this.elements = dArray;
        this.isNoView = bl;
    }

    @Override
    public double[] aggregate(final DComplexDComplexDComplexFunction dComplexDComplexDComplexFunction, final DComplexDComplexFunction dComplexDComplexFunction) {
        double[] dArray = new double[2];
        if (this.size() == 0L) {
            dArray[0] = Double.NaN;
            dArray[1] = Double.NaN;
            return dArray;
        }
        final int n = (int)this.index(0, 0);
        double[] dArray2 = null;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.columns : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int n3 = n + n4 * DenseColumnDComplexMatrix2D.this.columnStride;
                        double[] dArray = dComplexDComplexFunction.apply(DenseColumnDComplexMatrix2D.this.elements[n3], DenseColumnDComplexMatrix2D.this.elements[n3 + 1]);
                        int n2 = 1;
                        for (int i = n4; i < n5; ++i) {
                            for (int j = n2; j < DenseColumnDComplexMatrix2D.this.rows; ++j) {
                                n3 = n + j * DenseColumnDComplexMatrix2D.this.rowStride + i * DenseColumnDComplexMatrix2D.this.columnStride;
                                dArray = dComplexDComplexDComplexFunction.apply(dArray, dComplexDComplexFunction.apply(DenseColumnDComplexMatrix2D.this.elements[n3], DenseColumnDComplexMatrix2D.this.elements[n3 + 1]));
                            }
                            n2 = 0;
                        }
                        return dArray;
                    }
                });
            }
            dArray2 = ConcurrencyUtils.waitForCompletion(futureArray, dComplexDComplexDComplexFunction);
        } else {
            dArray2 = dComplexDComplexFunction.apply(this.elements[n], this.elements[n + 1]);
            int n6 = 1;
            for (int i = 0; i < this.columns; ++i) {
                for (int j = n6; j < this.rows; ++j) {
                    int n7 = n + j * this.rowStride + i * this.columnStride;
                    dArray2 = dComplexDComplexDComplexFunction.apply(dArray2, dComplexDComplexFunction.apply(this.elements[n7], this.elements[n7 + 1]));
                }
                n6 = 0;
            }
        }
        return dArray2;
    }

    @Override
    public double[] aggregate(DComplexMatrix2D dComplexMatrix2D, final DComplexDComplexDComplexFunction dComplexDComplexDComplexFunction, final DComplexDComplexDComplexFunction dComplexDComplexDComplexFunction2) {
        if (!(dComplexMatrix2D instanceof DenseColumnDComplexMatrix2D)) {
            return super.aggregate(dComplexMatrix2D, dComplexDComplexDComplexFunction, dComplexDComplexDComplexFunction2);
        }
        this.checkShape(dComplexMatrix2D);
        double[] dArray = new double[2];
        if (this.size() == 0L) {
            dArray[0] = Double.NaN;
            dArray[1] = Double.NaN;
            return dArray;
        }
        final int n = (int)this.index(0, 0);
        final int n2 = (int)dComplexMatrix2D.index(0, 0);
        final int n3 = dComplexMatrix2D.rowStride();
        final int n4 = dComplexMatrix2D.columnStride();
        final double[] dArray2 = (double[])dComplexMatrix2D.elements();
        double[] dArray3 = null;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n5 = Math.min(n5, this.columns);
            Future[] futureArray = new Future[n5];
            int n6 = this.columns / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n5 - 1 ? this.columns : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int n5 = n + n7 * DenseColumnDComplexMatrix2D.this.columnStride;
                        int n22 = n2 + n7 * n4;
                        double[] dArray = dComplexDComplexDComplexFunction2.apply(new double[]{DenseColumnDComplexMatrix2D.this.elements[n5], DenseColumnDComplexMatrix2D.this.elements[n5 + 1]}, new double[]{dArray2[n22], dArray2[n22 + 1]});
                        int n32 = 1;
                        for (int i = n7; i < n8; ++i) {
                            for (int j = n32; j < DenseColumnDComplexMatrix2D.this.rows; ++j) {
                                n5 = n + j * DenseColumnDComplexMatrix2D.this.rowStride + i * DenseColumnDComplexMatrix2D.this.columnStride;
                                n22 = n2 + j * n3 + i * n4;
                                dArray = dComplexDComplexDComplexFunction.apply(dArray, dComplexDComplexDComplexFunction2.apply(new double[]{DenseColumnDComplexMatrix2D.this.elements[n5], DenseColumnDComplexMatrix2D.this.elements[n5 + 1]}, new double[]{dArray2[n22], dArray2[n22 + 1]}));
                            }
                            n32 = 0;
                        }
                        return dArray;
                    }
                });
            }
            dArray3 = ConcurrencyUtils.waitForCompletion(futureArray, dComplexDComplexDComplexFunction);
        } else {
            dArray3 = dComplexDComplexDComplexFunction2.apply(new double[]{this.elements[n], this.elements[n + 1]}, new double[]{dArray2[n2], dArray2[n2 + 1]});
            int n9 = 1;
            for (int i = 0; i < this.columns; ++i) {
                for (int j = n9; j < this.rows; ++j) {
                    int n10 = n + j * this.rowStride + i * this.columnStride;
                    int n11 = n2 + j * n3 + i * n4;
                    dArray3 = dComplexDComplexDComplexFunction.apply(dArray3, dComplexDComplexDComplexFunction2.apply(new double[]{this.elements[n10], this.elements[n10 + 1]}, new double[]{dArray2[n11], dArray2[n11 + 1]}));
                }
                n9 = 0;
            }
        }
        return dArray3;
    }

    @Override
    public DComplexMatrix2D assign(final DComplexDComplexFunction dComplexDComplexFunction) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            Object[] objectArray;
            if (dComplexDComplexFunction instanceof DComplexMult) {
                objectArray = ((DComplexMult)dComplexDComplexFunction).multiplicator;
                if (objectArray[0] == 1.0 && objectArray[1] == 0.0) {
                    return this;
                }
                if (objectArray[0] == 0.0 && objectArray[1] == 0.0) {
                    return this.assign(0.0, 0.0);
                }
            }
            n2 = Math.min(n2, this.columns);
            objectArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.columns : n4 + n3;
                objectArray[i] = (double)ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n6 = n + n4 * DenseColumnDComplexMatrix2D.this.columnStride;
                        double[] dArray = new double[2];
                        if (dComplexDComplexFunction instanceof DComplexMult) {
                            double[] dArray2 = ((DComplexMult)dComplexDComplexFunction).multiplicator;
                            for (int i = n4; i < n5; ++i) {
                                int n2 = n6;
                                for (int j = 0; j < DenseColumnDComplexMatrix2D.this.rows; ++j) {
                                    dArray[0] = DenseColumnDComplexMatrix2D.this.elements[n2];
                                    dArray[1] = DenseColumnDComplexMatrix2D.this.elements[n2 + 1];
                                    DenseColumnDComplexMatrix2D.this.elements[n2] = dArray[0] * dArray2[0] - dArray[1] * dArray2[1];
                                    DenseColumnDComplexMatrix2D.this.elements[n2 + 1] = dArray[1] * dArray2[0] + dArray[0] * dArray2[1];
                                    n2 += DenseColumnDComplexMatrix2D.this.rowStride;
                                }
                                n6 += DenseColumnDComplexMatrix2D.this.columnStride;
                            }
                        } else {
                            for (int i = n4; i < n5; ++i) {
                                int n3 = n6;
                                for (int j = 0; j < DenseColumnDComplexMatrix2D.this.rows; ++j) {
                                    dArray = dComplexDComplexFunction.apply(DenseColumnDComplexMatrix2D.this.elements[n3], DenseColumnDComplexMatrix2D.this.elements[n3 + 1]);
                                    DenseColumnDComplexMatrix2D.this.elements[n3] = dArray[0];
                                    DenseColumnDComplexMatrix2D.this.elements[n3 + 1] = dArray[1];
                                    n3 += DenseColumnDComplexMatrix2D.this.rowStride;
                                }
                                n6 += DenseColumnDComplexMatrix2D.this.columnStride;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(objectArray);
        } else {
            int n6 = n;
            double[] dArray = new double[2];
            if (dComplexDComplexFunction instanceof DComplexMult) {
                double[] dArray2 = ((DComplexMult)dComplexDComplexFunction).multiplicator;
                for (int i = 0; i < this.columns; ++i) {
                    int n7 = n6;
                    for (int j = 0; j < this.rows; ++j) {
                        dArray[0] = this.elements[n7];
                        dArray[1] = this.elements[n7 + 1];
                        this.elements[n7] = dArray[0] * dArray2[0] - dArray[1] * dArray2[1];
                        this.elements[n7 + 1] = dArray[1] * dArray2[0] + dArray[0] * dArray2[1];
                        n7 += this.rowStride;
                    }
                    n6 += this.columnStride;
                }
            } else {
                for (int i = 0; i < this.columns; ++i) {
                    int n8 = n6;
                    for (int j = 0; j < this.rows; ++j) {
                        dArray = dComplexDComplexFunction.apply(this.elements[n8], this.elements[n8 + 1]);
                        this.elements[n8] = dArray[0];
                        this.elements[n8 + 1] = dArray[1];
                        n8 += this.rowStride;
                    }
                    n6 += this.columnStride;
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(final DComplexProcedure dComplexProcedure, final DComplexDComplexFunction dComplexDComplexFunction) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.columns : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] dArray = new double[2];
                        int n3 = n + n4 * DenseColumnDComplexMatrix2D.this.columnStride;
                        for (int i = n4; i < n5; ++i) {
                            int n2 = n3;
                            for (int j = 0; j < DenseColumnDComplexMatrix2D.this.rows; ++j) {
                                dArray[0] = DenseColumnDComplexMatrix2D.this.elements[n2];
                                dArray[1] = DenseColumnDComplexMatrix2D.this.elements[n2 + 1];
                                if (dComplexProcedure.apply(dArray)) {
                                    dArray = dComplexDComplexFunction.apply(dArray);
                                    DenseColumnDComplexMatrix2D.this.elements[n2] = dArray[0];
                                    DenseColumnDComplexMatrix2D.this.elements[n2 + 1] = dArray[1];
                                }
                                n2 += DenseColumnDComplexMatrix2D.this.rowStride;
                            }
                            n3 += DenseColumnDComplexMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            double[] dArray = new double[2];
            int n6 = n;
            for (int i = 0; i < this.columns; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.rows; ++j) {
                    dArray[0] = this.elements[n7];
                    dArray[1] = this.elements[n7 + 1];
                    if (dComplexProcedure.apply(dArray)) {
                        dArray = dComplexDComplexFunction.apply(dArray);
                        this.elements[n7] = dArray[0];
                        this.elements[n7 + 1] = dArray[1];
                    }
                    n7 += this.rowStride;
                }
                n6 += this.columnStride;
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(final DComplexProcedure dComplexProcedure, final double[] dArray) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.columns : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = n + n4 * DenseColumnDComplexMatrix2D.this.columnStride;
                        double[] dArray2 = new double[2];
                        for (int i = n4; i < n5; ++i) {
                            int n2 = n3;
                            for (int j = 0; j < DenseColumnDComplexMatrix2D.this.rows; ++j) {
                                dArray2[0] = DenseColumnDComplexMatrix2D.this.elements[n2];
                                dArray2[1] = DenseColumnDComplexMatrix2D.this.elements[n2 + 1];
                                if (dComplexProcedure.apply(dArray2)) {
                                    DenseColumnDComplexMatrix2D.this.elements[n2] = dArray[0];
                                    DenseColumnDComplexMatrix2D.this.elements[n2 + 1] = dArray[1];
                                }
                                n2 += DenseColumnDComplexMatrix2D.this.rowStride;
                            }
                            n3 += DenseColumnDComplexMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            double[] dArray2 = new double[2];
            int n6 = n;
            for (int i = 0; i < this.columns; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.rows; ++j) {
                    dArray2[0] = this.elements[n7];
                    dArray2[1] = this.elements[n7 + 1];
                    if (dComplexProcedure.apply(dArray2)) {
                        this.elements[n7] = dArray[0];
                        this.elements[n7 + 1] = dArray[1];
                    }
                    n7 += this.rowStride;
                }
                n6 += this.columnStride;
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(final DComplexRealFunction dComplexRealFunction) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.columns : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n6 = n + n4 * DenseColumnDComplexMatrix2D.this.columnStride;
                        double[] dArray = new double[2];
                        if (dComplexRealFunction == DComplexFunctions.abs) {
                            for (int i = n4; i < n5; ++i) {
                                int n2 = n6;
                                for (int j = 0; j < DenseColumnDComplexMatrix2D.this.rows; ++j) {
                                    double d;
                                    dArray[0] = DenseColumnDComplexMatrix2D.this.elements[n2];
                                    dArray[1] = DenseColumnDComplexMatrix2D.this.elements[n2 + 1];
                                    double d2 = Math.abs(DenseColumnDComplexMatrix2D.this.elements[n2]);
                                    double d3 = Math.abs(DenseColumnDComplexMatrix2D.this.elements[n2 + 1]);
                                    if (d2 == 0.0 && d3 == 0.0) {
                                        DenseColumnDComplexMatrix2D.this.elements[n2] = 0.0;
                                    } else if (d2 >= d3) {
                                        d = dArray[1] / dArray[0];
                                        DenseColumnDComplexMatrix2D.this.elements[n2] = d2 * Math.sqrt(1.0 + d * d);
                                    } else {
                                        d = dArray[0] / dArray[1];
                                        DenseColumnDComplexMatrix2D.this.elements[n2] = d3 * Math.sqrt(1.0 + d * d);
                                    }
                                    DenseColumnDComplexMatrix2D.this.elements[n2 + 1] = 0.0;
                                    n2 += DenseColumnDComplexMatrix2D.this.rowStride;
                                }
                                n6 += DenseColumnDComplexMatrix2D.this.columnStride;
                            }
                        } else {
                            for (int i = n4; i < n5; ++i) {
                                int n3 = n6;
                                for (int j = 0; j < DenseColumnDComplexMatrix2D.this.rows; ++j) {
                                    dArray[0] = DenseColumnDComplexMatrix2D.this.elements[n3];
                                    dArray[1] = DenseColumnDComplexMatrix2D.this.elements[n3 + 1];
                                    dArray[0] = dComplexRealFunction.apply(dArray);
                                    DenseColumnDComplexMatrix2D.this.elements[n3] = dArray[0];
                                    DenseColumnDComplexMatrix2D.this.elements[n3 + 1] = 0.0;
                                    n3 += DenseColumnDComplexMatrix2D.this.rowStride;
                                }
                                n6 += DenseColumnDComplexMatrix2D.this.columnStride;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n;
            double[] dArray = new double[2];
            if (dComplexRealFunction == DComplexFunctions.abs) {
                for (int i = 0; i < this.columns; ++i) {
                    int n7 = n6;
                    for (int j = 0; j < this.rows; ++j) {
                        double d;
                        dArray[0] = this.elements[n7];
                        dArray[1] = this.elements[n7 + 1];
                        double d2 = Math.abs(dArray[0]);
                        double d3 = Math.abs(dArray[1]);
                        if (d2 == 0.0 && d3 == 0.0) {
                            this.elements[n7] = 0.0;
                        } else if (d2 >= d3) {
                            d = dArray[1] / dArray[0];
                            this.elements[n7] = d2 * Math.sqrt(1.0 + d * d);
                        } else {
                            d = dArray[0] / dArray[1];
                            this.elements[n7] = d3 * Math.sqrt(1.0 + d * d);
                        }
                        this.elements[n7 + 1] = 0.0;
                        n7 += this.rowStride;
                    }
                    n6 += this.columnStride;
                }
            } else {
                for (int i = 0; i < this.columns; ++i) {
                    int n8 = n6;
                    for (int j = 0; j < this.rows; ++j) {
                        dArray[0] = this.elements[n8];
                        dArray[1] = this.elements[n8 + 1];
                        dArray[0] = dComplexRealFunction.apply(dArray);
                        this.elements[n8] = dArray[0];
                        this.elements[n8 + 1] = 0.0;
                        n8 += this.rowStride;
                    }
                    n6 += this.columnStride;
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(DComplexMatrix2D dComplexMatrix2D) {
        Object object;
        if (!(dComplexMatrix2D instanceof DenseColumnDComplexMatrix2D)) {
            super.assign(dComplexMatrix2D);
            return this;
        }
        DenseColumnDComplexMatrix2D denseColumnDComplexMatrix2D = (DenseColumnDComplexMatrix2D)dComplexMatrix2D;
        if (denseColumnDComplexMatrix2D == this) {
            return this;
        }
        this.checkShape(denseColumnDComplexMatrix2D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && denseColumnDComplexMatrix2D.isNoView) {
            System.arraycopy(denseColumnDComplexMatrix2D.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(denseColumnDComplexMatrix2D)) {
            object = denseColumnDComplexMatrix2D.copy();
            if (!(object instanceof DenseColumnDComplexMatrix2D)) {
                super.assign(denseColumnDComplexMatrix2D);
                return this;
            }
            denseColumnDComplexMatrix2D = (DenseColumnDComplexMatrix2D)object;
        }
        object = denseColumnDComplexMatrix2D.elements;
        if (this.elements == null || object == null) {
            throw new InternalError();
        }
        final int n2 = denseColumnDComplexMatrix2D.columnStride;
        int n3 = denseColumnDComplexMatrix2D.rowStride;
        final int n4 = (int)denseColumnDComplexMatrix2D.index(0, 0);
        final int n5 = (int)this.index(0, 0);
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n6 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n - 1 ? this.columns : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable((double[])object, n3){
                    final /* synthetic */ double[] val$elemsOther;
                    final /* synthetic */ int val$rowStrideOther;
                    {
                        this.val$elemsOther = dArray;
                        this.val$rowStrideOther = n6;
                    }

                    public void run() {
                        int n = n5 + n7 * DenseColumnDComplexMatrix2D.this.columnStride;
                        int n22 = n4 + n7 * n2;
                        for (int i = n7; i < n8; ++i) {
                            int n3 = n;
                            int n42 = n22;
                            for (int j = 0; j < DenseColumnDComplexMatrix2D.this.rows; ++j) {
                                DenseColumnDComplexMatrix2D.this.elements[n3] = this.val$elemsOther[n42];
                                DenseColumnDComplexMatrix2D.this.elements[n3 + 1] = this.val$elemsOther[n42 + 1];
                                n3 += DenseColumnDComplexMatrix2D.this.rowStride;
                                n42 += this.val$rowStrideOther;
                            }
                            n += DenseColumnDComplexMatrix2D.this.columnStride;
                            n22 += n2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n5;
            int n10 = n4;
            for (int i = 0; i < this.columns; ++i) {
                int n11 = n9;
                int n12 = n10;
                for (int j = 0; j < this.rows; ++j) {
                    this.elements[n11] = (double)object[n12];
                    this.elements[n11 + 1] = (double)object[n12 + 1];
                    n11 += this.rowStride;
                    n12 += n3;
                }
                n9 += this.columnStride;
                n10 += n2;
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(DComplexMatrix2D dComplexMatrix2D, final DComplexDComplexDComplexFunction dComplexDComplexDComplexFunction) {
        if (!(dComplexMatrix2D instanceof DenseColumnDComplexMatrix2D)) {
            super.assign(dComplexMatrix2D, dComplexDComplexDComplexFunction);
            return this;
        }
        this.checkShape(dComplexMatrix2D);
        final double[] dArray = ((DenseColumnDComplexMatrix2D)dComplexMatrix2D).elements;
        if (this.elements == null || dArray == null) {
            throw new InternalError();
        }
        final int n = dComplexMatrix2D.columnStride();
        final int n2 = dComplexMatrix2D.rowStride();
        final int n3 = (int)dComplexMatrix2D.index(0, 0);
        final int n4 = (int)this.index(0, 0);
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n5 = Math.min(n5, this.columns);
            Future[] futureArray = new Future[n5];
            int n6 = this.columns / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n5 - 1 ? this.columns : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n11 = n4 + n7 * DenseColumnDComplexMatrix2D.this.columnStride;
                        int n22 = n3 + n7 * n;
                        double[] dArray3 = new double[2];
                        double[] dArray2 = new double[2];
                        if (dComplexDComplexDComplexFunction == DComplexFunctions.mult) {
                            for (int i = n7; i < n8; ++i) {
                                int n32 = n11;
                                int n42 = n22;
                                for (int j = 0; j < DenseColumnDComplexMatrix2D.this.rows; ++j) {
                                    dArray3[0] = DenseColumnDComplexMatrix2D.this.elements[n32];
                                    dArray3[1] = DenseColumnDComplexMatrix2D.this.elements[n32 + 1];
                                    dArray2[0] = dArray[n42];
                                    dArray2[1] = dArray[n42 + 1];
                                    DenseColumnDComplexMatrix2D.this.elements[n32] = dArray3[0] * dArray2[0] - dArray3[1] * dArray2[1];
                                    DenseColumnDComplexMatrix2D.this.elements[n32 + 1] = dArray3[1] * dArray2[0] + dArray3[0] * dArray2[1];
                                    n32 += DenseColumnDComplexMatrix2D.this.rowStride;
                                    n42 += n2;
                                }
                                n11 += DenseColumnDComplexMatrix2D.this.columnStride;
                                n22 += n;
                            }
                        } else if (dComplexDComplexDComplexFunction == DComplexFunctions.multConjFirst) {
                            for (int i = n7; i < n8; ++i) {
                                int n5 = n11;
                                int n6 = n22;
                                for (int j = 0; j < DenseColumnDComplexMatrix2D.this.rows; ++j) {
                                    dArray3[0] = DenseColumnDComplexMatrix2D.this.elements[n5];
                                    dArray3[1] = DenseColumnDComplexMatrix2D.this.elements[n5 + 1];
                                    dArray2[0] = dArray[n6];
                                    dArray2[1] = dArray[n6 + 1];
                                    DenseColumnDComplexMatrix2D.this.elements[n5] = dArray3[0] * dArray2[0] + dArray3[1] * dArray2[1];
                                    DenseColumnDComplexMatrix2D.this.elements[n5 + 1] = -dArray3[1] * dArray2[0] + dArray3[0] * dArray2[1];
                                    n5 += DenseColumnDComplexMatrix2D.this.rowStride;
                                    n6 += n2;
                                }
                                n11 += DenseColumnDComplexMatrix2D.this.columnStride;
                                n22 += n;
                            }
                        } else if (dComplexDComplexDComplexFunction == DComplexFunctions.multConjSecond) {
                            for (int i = n7; i < n8; ++i) {
                                int n72 = n11;
                                int n82 = n22;
                                for (int j = 0; j < DenseColumnDComplexMatrix2D.this.rows; ++j) {
                                    dArray3[0] = DenseColumnDComplexMatrix2D.this.elements[n72];
                                    dArray3[1] = DenseColumnDComplexMatrix2D.this.elements[n72 + 1];
                                    dArray2[0] = dArray[n82];
                                    dArray2[1] = dArray[n82 + 1];
                                    DenseColumnDComplexMatrix2D.this.elements[n72] = dArray3[0] * dArray2[0] + dArray3[1] * dArray2[1];
                                    DenseColumnDComplexMatrix2D.this.elements[n72 + 1] = dArray3[1] * dArray2[0] - dArray3[0] * dArray2[1];
                                    n72 += DenseColumnDComplexMatrix2D.this.rowStride;
                                    n82 += n2;
                                }
                                n11 += DenseColumnDComplexMatrix2D.this.columnStride;
                                n22 += n;
                            }
                        } else {
                            for (int i = n7; i < n8; ++i) {
                                int n9 = n11;
                                int n10 = n22;
                                for (int j = 0; j < DenseColumnDComplexMatrix2D.this.rows; ++j) {
                                    dArray3[0] = DenseColumnDComplexMatrix2D.this.elements[n9];
                                    dArray3[1] = DenseColumnDComplexMatrix2D.this.elements[n9 + 1];
                                    dArray2[0] = dArray[n10];
                                    dArray2[1] = dArray[n10 + 1];
                                    dArray3 = dComplexDComplexDComplexFunction.apply(dArray3, dArray2);
                                    DenseColumnDComplexMatrix2D.this.elements[n9] = dArray3[0];
                                    DenseColumnDComplexMatrix2D.this.elements[n9 + 1] = dArray3[1];
                                    n9 += DenseColumnDComplexMatrix2D.this.rowStride;
                                    n10 += n2;
                                }
                                n11 += DenseColumnDComplexMatrix2D.this.columnStride;
                                n22 += n;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            double[] dArray2 = new double[2];
            double[] dArray3 = new double[2];
            int n9 = n4;
            int n10 = n3;
            if (dComplexDComplexDComplexFunction == DComplexFunctions.mult) {
                for (int i = 0; i < this.columns; ++i) {
                    int n11 = n9;
                    int n12 = n10;
                    for (int j = 0; j < this.rows; ++j) {
                        dArray2[0] = this.elements[n11];
                        dArray2[1] = this.elements[n11 + 1];
                        dArray3[0] = dArray[n12];
                        dArray3[1] = dArray[n12 + 1];
                        this.elements[n11] = dArray2[0] * dArray3[0] - dArray2[1] * dArray3[1];
                        this.elements[n11 + 1] = dArray2[1] * dArray3[0] + dArray2[0] * dArray3[1];
                        n11 += this.rowStride;
                        n12 += n2;
                    }
                    n9 += this.columnStride;
                    n10 += n;
                }
            } else if (dComplexDComplexDComplexFunction == DComplexFunctions.multConjFirst) {
                for (int i = 0; i < this.columns; ++i) {
                    int n13 = n9;
                    int n14 = n10;
                    for (int j = 0; j < this.rows; ++j) {
                        dArray2[0] = this.elements[n13];
                        dArray2[1] = this.elements[n13 + 1];
                        dArray3[0] = dArray[n14];
                        dArray3[1] = dArray[n14 + 1];
                        this.elements[n13] = dArray2[0] * dArray3[0] + dArray2[1] * dArray3[1];
                        this.elements[n13 + 1] = -dArray2[1] * dArray3[0] + dArray2[0] * dArray3[1];
                        n13 += this.rowStride;
                        n14 += n2;
                    }
                    n9 += this.columnStride;
                    n10 += n;
                }
            } else if (dComplexDComplexDComplexFunction == DComplexFunctions.multConjSecond) {
                for (int i = 0; i < this.columns; ++i) {
                    int n15 = n9;
                    int n16 = n10;
                    for (int j = 0; j < this.rows; ++j) {
                        dArray2[0] = this.elements[n15];
                        dArray2[1] = this.elements[n15 + 1];
                        dArray3[0] = dArray[n16];
                        dArray3[1] = dArray[n16 + 1];
                        this.elements[n15] = dArray2[0] * dArray3[0] + dArray2[1] * dArray3[1];
                        this.elements[n15 + 1] = dArray2[1] * dArray3[0] - dArray2[0] * dArray3[1];
                        n15 += this.rowStride;
                        n16 += n2;
                    }
                    n9 += this.columnStride;
                    n10 += n;
                }
            } else {
                for (int i = 0; i < this.columns; ++i) {
                    int n17 = n9;
                    int n18 = n10;
                    for (int j = 0; j < this.rows; ++j) {
                        dArray2[0] = this.elements[n17];
                        dArray2[1] = this.elements[n17 + 1];
                        dArray3[0] = dArray[n18];
                        dArray3[1] = dArray[n18 + 1];
                        dArray2 = dComplexDComplexDComplexFunction.apply(dArray2, dArray3);
                        this.elements[n17] = dArray2[0];
                        this.elements[n17 + 1] = dArray2[1];
                        n17 += this.rowStride;
                        n18 += n2;
                    }
                    n9 += this.columnStride;
                    n10 += n;
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(final double d, final double d2) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.columns : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = n + n4 * DenseColumnDComplexMatrix2D.this.columnStride;
                        for (int i = n4; i < n5; ++i) {
                            int n2 = n3;
                            for (int j = 0; j < DenseColumnDComplexMatrix2D.this.rows; ++j) {
                                DenseColumnDComplexMatrix2D.this.elements[n2] = d;
                                DenseColumnDComplexMatrix2D.this.elements[n2 + 1] = d2;
                                n2 += DenseColumnDComplexMatrix2D.this.rowStride;
                            }
                            n3 += DenseColumnDComplexMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n;
            for (int i = 0; i < this.columns; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.rows; ++j) {
                    this.elements[n7] = d;
                    this.elements[n7 + 1] = d2;
                    n7 += this.rowStride;
                }
                n6 += this.columnStride;
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(final double[] dArray) {
        if (dArray.length != this.rows * 2 * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + dArray.length + "rows()*2*columns()=" + this.rows() * 2 * this.columns());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(dArray, 0, this.elements, 0, dArray.length);
        } else {
            final int n2 = (int)this.index(0, 0);
            if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                n = Math.min(n, this.columns);
                Future[] futureArray = new Future[n];
                int n3 = this.columns / n;
                for (int i = 0; i < n; ++i) {
                    final int n4 = i * n3;
                    final int n5 = i == n - 1 ? this.columns : n4 + n3;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n4 * DenseColumnDComplexMatrix2D.this.rows * 2;
                            int n22 = n2 + n4 * DenseColumnDComplexMatrix2D.this.columnStride;
                            for (int i = n4; i < n5; ++i) {
                                int n3 = n22;
                                for (int j = 0; j < DenseColumnDComplexMatrix2D.this.rows; ++j) {
                                    DenseColumnDComplexMatrix2D.this.elements[n3] = dArray[n++];
                                    DenseColumnDComplexMatrix2D.this.elements[n3 + 1] = dArray[n++];
                                    n3 += DenseColumnDComplexMatrix2D.this.rowStride;
                                }
                                n22 += DenseColumnDComplexMatrix2D.this.columnStride;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n6 = 0;
                int n7 = n2;
                for (int i = 0; i < this.columns; ++i) {
                    int n8 = n7;
                    for (int j = 0; j < this.rows; ++j) {
                        this.elements[n8] = dArray[n6++];
                        this.elements[n8 + 1] = dArray[n6++];
                        n8 += this.rowStride;
                    }
                    n7 += this.columnStride;
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(final double[][] dArray) {
        if (dArray.length != this.columns) {
            throw new IllegalArgumentException("Must have same number of columns: values.length=" + dArray.length + "columns()=" + this.columns());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                n = Math.min(n, this.columns);
                Future[] futureArray = new Future[n];
                int n2 = this.columns / n;
                for (int i = 0; i < n; ++i) {
                    final int n3 = i * n2;
                    final int n4 = i == n - 1 ? this.columns : n3 + n2;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = 2 * DenseColumnDComplexMatrix2D.this.rows;
                            int n2 = n3 * DenseColumnDComplexMatrix2D.this.columnStride;
                            for (int i = n3; i < n4; ++i) {
                                double[] dArray2 = dArray[i];
                                if (dArray2.length != n) {
                                    throw new IllegalArgumentException("Must have same number of rows in every column: rows=" + dArray2.length + "2*rows()=" + n);
                                }
                                System.arraycopy(dArray2, 0, DenseColumnDComplexMatrix2D.this.elements, n2, n);
                                n2 += n;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n5 = 2 * this.rows;
                int n6 = 0;
                for (int i = 0; i < this.columns; ++i) {
                    double[] dArray2 = dArray[i];
                    if (dArray2.length != n5) {
                        throw new IllegalArgumentException("Must have same number of rows in every column: rows=" + dArray2.length + "2*rows()=" + n5);
                    }
                    System.arraycopy(dArray2, 0, this.elements, n6, n5);
                    n6 += n5;
                }
            }
        } else {
            final int n7 = (int)this.index(0, 0);
            if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                n = Math.min(n, this.columns);
                Future[] futureArray = new Future[n];
                int n8 = this.columns / n;
                for (int i = 0; i < n; ++i) {
                    final int n9 = i * n8;
                    final int n10 = i == n - 1 ? this.columns : n9 + n8;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n7 + n9 * DenseColumnDComplexMatrix2D.this.columnStride;
                            for (int i = n9; i < n10; ++i) {
                                double[] dArray2 = dArray[i];
                                if (dArray2.length != 2 * DenseColumnDComplexMatrix2D.this.rows) {
                                    throw new IllegalArgumentException("Must have same number of rows in every column: rows=" + dArray2.length + "2*rows()=" + n);
                                }
                                int n2 = n;
                                for (int j = 0; j < DenseColumnDComplexMatrix2D.this.rows; ++j) {
                                    DenseColumnDComplexMatrix2D.this.elements[n2] = dArray2[2 * j];
                                    DenseColumnDComplexMatrix2D.this.elements[n2 + 1] = dArray2[2 * j + 1];
                                    n2 += DenseColumnDComplexMatrix2D.this.rowStride;
                                }
                                n += DenseColumnDComplexMatrix2D.this.columnStride;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n11 = n7;
                for (int i = 0; i < this.columns; ++i) {
                    double[] dArray3 = dArray[i];
                    if (dArray3.length != 2 * this.rows) {
                        throw new IllegalArgumentException("Must have same number of rows in every column: rows=" + dArray3.length + "2*rows()=" + n11);
                    }
                    int n12 = n11;
                    for (int j = 0; j < this.rows; ++j) {
                        this.elements[n12] = dArray3[2 * j];
                        this.elements[n12 + 1] = dArray3[2 * j + 1];
                        n12 += this.rowStride;
                    }
                    n11 += this.columnStride;
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(final float[] fArray) {
        if (fArray.length != this.rows * 2 * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + fArray.length + "rows()*2*columns()=" + this.rows() * 2 * this.columns());
        }
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.columns : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n6 = n4 * DenseColumnDComplexMatrix2D.this.rows * 2;
                        int n2 = n + n4 * DenseColumnDComplexMatrix2D.this.columnStride;
                        for (int i = n4; i < n5; ++i) {
                            int n3 = n2;
                            for (int j = 0; j < DenseColumnDComplexMatrix2D.this.rows; ++j) {
                                DenseColumnDComplexMatrix2D.this.elements[n3] = fArray[n6++];
                                DenseColumnDComplexMatrix2D.this.elements[n3 + 1] = fArray[n6++];
                                n3 += DenseColumnDComplexMatrix2D.this.rowStride;
                            }
                            n2 += DenseColumnDComplexMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = 0;
            int n7 = n;
            for (int i = 0; i < this.columns; ++i) {
                int n8 = n7;
                for (int j = 0; j < this.rows; ++j) {
                    this.elements[n8] = fArray[n6++];
                    this.elements[n8 + 1] = fArray[n6++];
                    n8 += this.rowStride;
                }
                n7 += this.columnStride;
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assignImaginary(DoubleMatrix2D doubleMatrix2D) {
        this.checkShape(doubleMatrix2D);
        final int n = doubleMatrix2D.columnStride();
        final int n2 = doubleMatrix2D.rowStride();
        final int n3 = (int)doubleMatrix2D.index(0, 0);
        final int n4 = (int)this.index(0, 0);
        final double[] dArray = ((DenseDoubleMatrix2D)doubleMatrix2D).elements();
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n5 = Math.min(n5, this.columns);
            Future[] futureArray = new Future[n5];
            int n6 = this.columns / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n5 - 1 ? this.columns : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n5 = n4 + n7 * DenseColumnDComplexMatrix2D.this.columnStride;
                        int n22 = n3 + n7 * n;
                        for (int i = n7; i < n8; ++i) {
                            int n32 = n5;
                            int n42 = n22;
                            for (int j = 0; j < DenseColumnDComplexMatrix2D.this.rows; ++j) {
                                DenseColumnDComplexMatrix2D.this.elements[n32 + 1] = dArray[n42];
                                n32 += DenseColumnDComplexMatrix2D.this.rowStride;
                                n42 += n2;
                            }
                            n5 += DenseColumnDComplexMatrix2D.this.columnStride;
                            n22 += n;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n4;
            int n10 = n3;
            for (int i = 0; i < this.columns; ++i) {
                int n11 = n9;
                int n12 = n10;
                for (int j = 0; j < this.rows; ++j) {
                    this.elements[n11 + 1] = dArray[n12];
                    n11 += this.rowStride;
                    n12 += n2;
                }
                n9 += this.columnStride;
                n10 += n;
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assignReal(DoubleMatrix2D doubleMatrix2D) {
        this.checkShape(doubleMatrix2D);
        final int n = doubleMatrix2D.columnStride();
        final int n2 = doubleMatrix2D.rowStride();
        final int n3 = (int)doubleMatrix2D.index(0, 0);
        final int n4 = (int)this.index(0, 0);
        final double[] dArray = ((DenseDoubleMatrix2D)doubleMatrix2D).elements();
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n5 = Math.min(n5, this.columns);
            Future[] futureArray = new Future[n5];
            int n6 = this.columns / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n5 - 1 ? this.columns : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n5 = n4 + n7 * DenseColumnDComplexMatrix2D.this.columnStride;
                        int n22 = n3 + n7 * n;
                        for (int i = n7; i < n8; ++i) {
                            int n32 = n5;
                            int n42 = n22;
                            for (int j = 0; j < DenseColumnDComplexMatrix2D.this.rows; ++j) {
                                DenseColumnDComplexMatrix2D.this.elements[n32] = dArray[n42];
                                n32 += DenseColumnDComplexMatrix2D.this.rowStride;
                                n42 += n2;
                            }
                            n5 += DenseColumnDComplexMatrix2D.this.columnStride;
                            n22 += n;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n4;
            int n10 = n3;
            for (int i = 0; i < this.columns; ++i) {
                int n11 = n9;
                int n12 = n10;
                for (int j = 0; j < this.rows; ++j) {
                    this.elements[n11] = dArray[n12];
                    n11 += this.rowStride;
                    n12 += n2;
                }
                n9 += this.columnStride;
                n10 += n;
            }
        }
        return this;
    }

    @Override
    public int cardinality() {
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        final int n3 = (int)this.index(0, 0);
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n4;
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n5 = this.columns / n2;
            for (n4 = 0; n4 < n2; ++n4) {
                final int n6 = n4 * n5;
                final int n7 = n4 == n2 - 1 ? this.columns : n6 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        int n2 = n3 + n6 * DenseColumnDComplexMatrix2D.this.columnStride;
                        for (int i = n6; i < n7; ++i) {
                            int n32 = n2;
                            for (int j = 0; j < DenseColumnDComplexMatrix2D.this.rows; ++j) {
                                if (DenseColumnDComplexMatrix2D.this.elements[n32] != 0.0 || DenseColumnDComplexMatrix2D.this.elements[n32 + 1] != 0.0) {
                                    ++n;
                                }
                                n32 += DenseColumnDComplexMatrix2D.this.rowStride;
                            }
                            n2 += DenseColumnDComplexMatrix2D.this.columnStride;
                        }
                        return n;
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n2; ++n4) {
                    integerArray[n4] = (Integer)futureArray[n4].get();
                }
                n = integerArray[0];
                for (n4 = 1; n4 < n2; ++n4) {
                    n += integerArray[n4].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            int n8 = n3;
            for (int i = 0; i < this.columns; ++i) {
                int n9 = n8;
                for (int j = 0; j < this.rows; ++j) {
                    if (this.elements[n9] != 0.0 || this.elements[n9 + 1] != 0.0) {
                        ++n;
                    }
                    n9 += this.rowStride;
                }
                n8 += this.columnStride;
            }
        }
        return n;
    }

    public void fft2() {
        DComplexMatrix2D dComplexMatrix2D = this.viewDice().copy();
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft2 == null) {
            this.fft2 = new DoubleFFT_2D(this.rows, this.columns);
        }
        this.fft2.complexForward((double[])dComplexMatrix2D.elements());
        this.assign(dComplexMatrix2D.viewDice().copy());
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void fftColumns() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.columns : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            ((DenseDComplexMatrix1D)DenseColumnDComplexMatrix2D.this.viewColumn(i)).fft();
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.columns; ++i) {
                ((DenseDComplexMatrix1D)this.viewColumn(i)).fft();
            }
        }
    }

    public void fftRows() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            ((DenseDComplexMatrix1D)DenseColumnDComplexMatrix2D.this.viewRow(i)).fft();
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                ((DenseDComplexMatrix1D)this.viewRow(i)).fft();
            }
        }
    }

    @Override
    public DComplexMatrix2D forEachNonZero(final IntIntDComplexFunction intIntDComplexFunction) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.columns : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = n + n4 * DenseColumnDComplexMatrix2D.this.columnStride;
                        double[] dArray = new double[2];
                        for (int i = n4; i < n5; ++i) {
                            int n2 = n3;
                            for (int j = 0; j < DenseColumnDComplexMatrix2D.this.rows; ++j) {
                                dArray[0] = DenseColumnDComplexMatrix2D.this.elements[n2];
                                dArray[1] = DenseColumnDComplexMatrix2D.this.elements[n2 + 1];
                                if (dArray[0] != 0.0 || dArray[1] != 0.0) {
                                    double[] dArray2 = intIntDComplexFunction.apply(j, i, dArray);
                                    DenseColumnDComplexMatrix2D.this.elements[n2] = dArray2[0];
                                    DenseColumnDComplexMatrix2D.this.elements[n2 + 1] = dArray2[1];
                                }
                                n2 += DenseColumnDComplexMatrix2D.this.rowStride;
                            }
                            n3 += DenseColumnDComplexMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n;
            double[] dArray = new double[2];
            for (int i = 0; i < this.columns; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.rows; ++j) {
                    dArray[0] = this.elements[n7];
                    dArray[1] = this.elements[n7 + 1];
                    if (dArray[0] != 0.0 || dArray[1] != 0.0) {
                        double[] dArray2 = intIntDComplexFunction.apply(j, i, dArray);
                        this.elements[n7] = dArray2[0];
                        this.elements[n7 + 1] = dArray2[1];
                    }
                    n7 += this.rowStride;
                }
                n6 += this.columnStride;
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D getConjugateTranspose() {
        DComplexMatrix2D dComplexMatrix2D = this.viewDice().copy();
        final double[] dArray = ((DenseColumnDComplexMatrix2D)dComplexMatrix2D).elements;
        final int n = (int)dComplexMatrix2D.index(0, 0);
        final int n2 = dComplexMatrix2D.columnStride();
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        int n4 = dComplexMatrix2D.columns();
        final int n5 = dComplexMatrix2D.rows();
        if (n3 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n3 = Math.min(n3, n4);
            Future[] futureArray = new Future[n3];
            int n6 = n4 / n3;
            for (int i = 0; i < n3; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n3 - 1 ? n4 : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = n + n7 * n2;
                        for (int i = n7; i < n8; ++i) {
                            for (int j = 0; j < n5; ++j) {
                                dArray[n3 + 1] = -dArray[n3 + 1];
                                n3 += 2;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n;
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n5; ++j) {
                    dArray[n9 + 1] = -dArray[n9 + 1];
                    n9 += 2;
                }
            }
        }
        return dComplexMatrix2D;
    }

    public double[] elements() {
        return this.elements;
    }

    @Override
    public DoubleMatrix2D getImaginaryPart() {
        DenseColumnDoubleMatrix2D denseColumnDoubleMatrix2D = new DenseColumnDoubleMatrix2D(this.rows, this.columns);
        final double[] dArray = denseColumnDoubleMatrix2D.elements();
        final int n = denseColumnDoubleMatrix2D.columnStride();
        final int n2 = denseColumnDoubleMatrix2D.rowStride();
        final int n3 = (int)denseColumnDoubleMatrix2D.index(0, 0);
        final int n4 = (int)this.index(0, 0);
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n5 = Math.min(n5, this.columns);
            Future[] futureArray = new Future[n5];
            int n6 = this.columns / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n5 - 1 ? this.columns : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n5 = n4 + n7 * DenseColumnDComplexMatrix2D.this.columnStride;
                        int n22 = n3 + n7 * n;
                        for (int i = n7; i < n8; ++i) {
                            int n32 = n5;
                            int n42 = n22;
                            for (int j = 0; j < DenseColumnDComplexMatrix2D.this.rows; ++j) {
                                dArray[n42] = DenseColumnDComplexMatrix2D.this.elements[n32 + 1];
                                n32 += DenseColumnDComplexMatrix2D.this.rowStride;
                                n42 += n2;
                            }
                            n5 += DenseColumnDComplexMatrix2D.this.columnStride;
                            n22 += n;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n4;
            int n10 = n3;
            for (int i = 0; i < this.columns; ++i) {
                int n11 = n9;
                int n12 = n10;
                for (int j = 0; j < this.rows; ++j) {
                    dArray[n12] = this.elements[n11 + 1];
                    n11 += this.rowStride;
                    n12 += n2;
                }
                n9 += this.columnStride;
                n10 += n;
            }
        }
        return denseColumnDoubleMatrix2D;
    }

    @Override
    public void getNonZeros(IntArrayList intArrayList, IntArrayList intArrayList2, ArrayList<double[]> arrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        arrayList.clear();
        int n = (int)this.index(0, 0);
        for (int i = 0; i < this.columns; ++i) {
            int n2 = n;
            for (int j = 0; j < this.rows; ++j) {
                double[] dArray = new double[]{this.elements[n2], this.elements[n2 + 1]};
                if (dArray[0] != 0.0 || dArray[1] != 0.0) {
                    intArrayList.add(j);
                    intArrayList2.add(i);
                    arrayList.add(dArray);
                }
                n2 += this.rowStride;
            }
            n += this.columnStride;
        }
    }

    @Override
    public double[] getQuick(int n, int n2) {
        int n3 = this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride;
        return new double[]{this.elements[n3], this.elements[n3 + 1]};
    }

    @Override
    public DoubleMatrix2D getRealPart() {
        DenseColumnDoubleMatrix2D denseColumnDoubleMatrix2D = new DenseColumnDoubleMatrix2D(this.rows, this.columns);
        final double[] dArray = denseColumnDoubleMatrix2D.elements();
        final int n = denseColumnDoubleMatrix2D.columnStride();
        final int n2 = denseColumnDoubleMatrix2D.rowStride();
        final int n3 = (int)denseColumnDoubleMatrix2D.index(0, 0);
        final int n4 = (int)this.index(0, 0);
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n5 = Math.min(n5, this.columns);
            Future[] futureArray = new Future[n5];
            int n6 = this.columns / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n5 - 1 ? this.columns : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n5 = n4 + n7 * DenseColumnDComplexMatrix2D.this.columnStride;
                        int n22 = n3 + n7 * n;
                        for (int i = n7; i < n8; ++i) {
                            int n32 = n5;
                            int n42 = n22;
                            for (int j = 0; j < DenseColumnDComplexMatrix2D.this.rows; ++j) {
                                dArray[n42] = DenseColumnDComplexMatrix2D.this.elements[n32];
                                n32 += DenseColumnDComplexMatrix2D.this.rowStride;
                                n42 += n2;
                            }
                            n5 += DenseColumnDComplexMatrix2D.this.columnStride;
                            n22 += n;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n4;
            int n10 = n3;
            for (int i = 0; i < this.columns; ++i) {
                int n11 = n9;
                int n12 = n10;
                for (int j = 0; j < this.rows; ++j) {
                    dArray[n12] = this.elements[n11];
                    n11 += this.rowStride;
                    n12 += n2;
                }
                n9 += this.columnStride;
                n10 += n;
            }
        }
        return denseColumnDoubleMatrix2D;
    }

    public void ifft2(boolean bl) {
        DComplexMatrix2D dComplexMatrix2D = this.viewDice().copy();
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft2 == null) {
            this.fft2 = new DoubleFFT_2D(this.rows, this.columns);
        }
        this.fft2.complexInverse((double[])dComplexMatrix2D.elements(), bl);
        this.assign(dComplexMatrix2D.viewDice().copy());
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void ifftColumns(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.columns : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            ((DenseDComplexMatrix1D)DenseColumnDComplexMatrix2D.this.viewColumn(i)).ifft(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.columns; ++i) {
                ((DenseDComplexMatrix1D)this.viewColumn(i)).ifft(bl);
            }
        }
    }

    public void ifftRows(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            ((DenseDComplexMatrix1D)DenseColumnDComplexMatrix2D.this.viewRow(i)).ifft(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                ((DenseDComplexMatrix1D)this.viewRow(i)).ifft(bl);
            }
        }
    }

    @Override
    public DComplexMatrix2D like(int n, int n2) {
        return new DenseColumnDComplexMatrix2D(n, n2);
    }

    @Override
    public DComplexMatrix1D like1D(int n) {
        return new DenseDComplexMatrix1D(n);
    }

    @Override
    public void setQuick(int n, int n2, double d, double d2) {
        int n3 = this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride;
        this.elements[n3] = d;
        this.elements[n3 + 1] = d2;
    }

    @Override
    public void setQuick(int n, int n2, double[] dArray) {
        int n3 = this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride;
        this.elements[n3] = dArray[0];
        this.elements[n3 + 1] = dArray[1];
    }

    @Override
    public double[][] toArray() {
        final double[][] dArray = new double[this.rows][2 * this.columns];
        int n = ConcurrencyUtils.getNumberOfThreads();
        final int n2 = (int)this.index(0, 0);
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n3 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n - 1 ? this.columns : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n2 + n4 * DenseColumnDComplexMatrix2D.this.columnStride;
                        for (int i = n4; i < n5; ++i) {
                            int n22 = n;
                            for (int j = 0; j < DenseColumnDComplexMatrix2D.this.rows; ++j) {
                                dArray[j][2 * i] = DenseColumnDComplexMatrix2D.this.elements[n22];
                                dArray[j][2 * i + 1] = DenseColumnDComplexMatrix2D.this.elements[n22 + 1];
                                n22 += DenseColumnDComplexMatrix2D.this.rowStride;
                            }
                            n += DenseColumnDComplexMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n2;
            for (int i = 0; i < this.columns; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.rows; ++j) {
                    dArray[j][2 * i] = this.elements[n7];
                    dArray[j][2 * i + 1] = this.elements[n7 + 1];
                    n7 += this.rowStride;
                }
                n6 += this.columnStride;
            }
        }
        return dArray;
    }

    @Override
    public DComplexMatrix1D vectorize() {
        DenseDComplexMatrix1D denseDComplexMatrix1D = new DenseDComplexMatrix1D((int)this.size());
        if (this.isNoView) {
            System.arraycopy(this.elements, 0, ((DComplexMatrix1D)denseDComplexMatrix1D).elements(), 0, this.elements.length);
        } else {
            final int n = (int)this.index(0, 0);
            final int n2 = (int)((AbstractMatrix1D)denseDComplexMatrix1D).index(0);
            final int n3 = denseDComplexMatrix1D.stride();
            final double[] dArray = (double[])((DComplexMatrix1D)denseDComplexMatrix1D).elements();
            int n4 = ConcurrencyUtils.getNumberOfThreads();
            if (n4 > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                n4 = Math.min(n4, this.columns);
                Future[] futureArray = new Future[n4];
                int n5 = this.columns / n4;
                for (int i = 0; i < n4; ++i) {
                    final int n6 = i * n5;
                    final int n7 = i == n4 - 1 ? this.columns : n6 + n5;
                    final int n8 = i * n5 * this.rows;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n4 = 0;
                            int n22 = n2 + n8 * n3;
                            for (int i = n6; i < n7; ++i) {
                                n4 = n + i * DenseColumnDComplexMatrix2D.this.columnStride;
                                for (int j = 0; j < DenseColumnDComplexMatrix2D.this.rows; ++j) {
                                    dArray[n22] = DenseColumnDComplexMatrix2D.this.elements[n4];
                                    dArray[n22 + 1] = DenseColumnDComplexMatrix2D.this.elements[n4 + 1];
                                    n4 += DenseColumnDComplexMatrix2D.this.rowStride;
                                    n22 += n3;
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n9 = 0;
                int n10 = n2;
                for (int i = 0; i < this.columns; ++i) {
                    n9 = n + i * this.columnStride;
                    for (int j = 0; j < this.rows; ++j) {
                        dArray[n10] = this.elements[n9];
                        dArray[n10 + 1] = this.elements[n9 + 1];
                        n9 += this.rowStride;
                        n10 += n3;
                    }
                }
            }
        }
        return denseDComplexMatrix1D;
    }

    @Override
    public DComplexMatrix2D zMult(DComplexMatrix2D dComplexMatrix2D, DComplexMatrix2D dComplexMatrix2D2, final double[] dArray, final double[] dArray2, final boolean bl, final boolean bl2) {
        int n;
        int n2 = this.rows;
        int n3 = this.columns;
        int n4 = dComplexMatrix2D.rows();
        int n5 = dComplexMatrix2D.columns();
        int n6 = bl ? n3 : n2;
        int n7 = n = bl2 ? n4 : n5;
        if (dComplexMatrix2D2 == null) {
            dComplexMatrix2D2 = new DenseColumnDComplexMatrix2D(n6, n);
        }
        if (bl) {
            return this.getConjugateTranspose().zMult(dComplexMatrix2D, dComplexMatrix2D2, dArray, dArray2, false, bl2);
        }
        if (bl2) {
            return this.zMult(dComplexMatrix2D.getConjugateTranspose(), dComplexMatrix2D2, dArray, dArray2, bl, false);
        }
        if (dComplexMatrix2D.rows() != n3) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + dComplexMatrix2D.toStringShort());
        }
        if (dComplexMatrix2D2.rows() != n2 || dComplexMatrix2D2.columns() != n5) {
            throw new IllegalArgumentException("Incompatibe result matrix: " + this.toStringShort() + ", " + dComplexMatrix2D.toStringShort() + ", " + dComplexMatrix2D2.toStringShort());
        }
        if (this == dComplexMatrix2D2 || dComplexMatrix2D == dComplexMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        long l = 2L * (long)n2 * (long)n3 * (long)n5;
        int n8 = (int)Math.min(l / 30000L, (long)ConcurrencyUtils.getNumberOfThreads());
        boolean bl3 = n5 >= n8;
        int n9 = bl3 ? n5 : n2;
        n8 = Math.min(n9, n8);
        if (n8 < 2) {
            return this.zMultSeq(dComplexMatrix2D, dComplexMatrix2D2, dArray, dArray2, bl, bl2);
        }
        int n10 = n9 / n8;
        Future[] futureArray = new Future[n8];
        for (int i = 0; i < n8; ++i) {
            DComplexMatrix2D dComplexMatrix2D3;
            DComplexMatrix2D dComplexMatrix2D4;
            DComplexMatrix2D dComplexMatrix2D5;
            int n11 = i * n10;
            if (i == n8 - 1) {
                n10 = n9 - n10 * i;
            }
            if (bl3) {
                dComplexMatrix2D5 = this;
                dComplexMatrix2D4 = dComplexMatrix2D.viewPart(0, n11, n3, n10);
                dComplexMatrix2D3 = dComplexMatrix2D2.viewPart(0, n11, n2, n10);
            } else {
                dComplexMatrix2D5 = this.viewPart(n11, 0, n10, n3);
                dComplexMatrix2D4 = dComplexMatrix2D;
                dComplexMatrix2D3 = dComplexMatrix2D2.viewPart(n11, 0, n10, n5);
            }
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    ((DenseColumnDComplexMatrix2D)dComplexMatrix2D5).zMultSeq(dComplexMatrix2D4, dComplexMatrix2D3, dArray, dArray2, bl, bl2);
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
        return dComplexMatrix2D2;
    }

    protected DComplexMatrix2D zMultSeq(DComplexMatrix2D dComplexMatrix2D, DComplexMatrix2D dComplexMatrix2D2, double[] dArray, double[] dArray2, boolean bl, boolean bl2) {
        if (bl) {
            return this.getConjugateTranspose().zMult(dComplexMatrix2D, dComplexMatrix2D2, dArray, dArray2, false, bl2);
        }
        if (bl2) {
            return this.zMult(dComplexMatrix2D.getConjugateTranspose(), dComplexMatrix2D2, dArray, dArray2, bl, false);
        }
        int n = this.rows;
        int n2 = this.columns;
        int n3 = dComplexMatrix2D.columns();
        if (dComplexMatrix2D2 == null) {
            dComplexMatrix2D2 = new DenseColumnDComplexMatrix2D(n, n3);
        }
        if (!(dComplexMatrix2D2 instanceof DenseColumnDComplexMatrix2D)) {
            return super.zMult(dComplexMatrix2D, dComplexMatrix2D2, dArray, dArray2, bl, bl2);
        }
        if (dComplexMatrix2D.rows() != n2) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + dComplexMatrix2D.toStringShort());
        }
        if (dComplexMatrix2D2.rows() != n || dComplexMatrix2D2.columns() != n3) {
            throw new IllegalArgumentException("Incompatibel result matrix: " + this.toStringShort() + ", " + dComplexMatrix2D.toStringShort() + ", " + dComplexMatrix2D2.toStringShort());
        }
        if (this == dComplexMatrix2D2 || dComplexMatrix2D == dComplexMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        DenseColumnDComplexMatrix2D denseColumnDComplexMatrix2D = (DenseColumnDComplexMatrix2D)dComplexMatrix2D;
        DenseColumnDComplexMatrix2D denseColumnDComplexMatrix2D2 = (DenseColumnDComplexMatrix2D)dComplexMatrix2D2;
        double[] dArray3 = this.elements;
        double[] dArray4 = denseColumnDComplexMatrix2D.elements;
        double[] dArray5 = denseColumnDComplexMatrix2D2.elements;
        if (dArray3 == null || dArray4 == null || dArray5 == null) {
            throw new InternalError();
        }
        int n4 = this.columnStride;
        int n5 = denseColumnDComplexMatrix2D.columnStride;
        int n6 = denseColumnDComplexMatrix2D2.columnStride;
        int n7 = this.rowStride;
        int n8 = denseColumnDComplexMatrix2D.rowStride;
        int n9 = denseColumnDComplexMatrix2D2.rowStride;
        int n10 = (30000 - n2) / (n2 + 1);
        if (n10 <= 0) {
            n10 = 1;
        }
        int n11 = n / n10;
        int n12 = 0;
        if (n % n10 != 0) {
            ++n11;
        }
        while (--n11 >= 0) {
            int n13 = (int)denseColumnDComplexMatrix2D.index(0, 0);
            int n14 = (int)this.index(n12, 0);
            int n15 = (int)denseColumnDComplexMatrix2D2.index(n12, 0);
            n12 += n10;
            if (n11 == 0) {
                n10 += n - n12;
            }
            int n16 = n3;
            while (--n16 >= 0) {
                int n17 = n14;
                int n18 = n15;
                int n19 = n10;
                while (--n19 >= 0) {
                    double d;
                    double d2;
                    double d3;
                    double d4;
                    int n20 = n17;
                    int n21 = n13;
                    double d5 = 0.0;
                    double d6 = 0.0;
                    n20 -= n4;
                    n21 -= n8;
                    int n22 = n2 % 4;
                    while (--n22 >= 0) {
                        d4 = dArray3[n20 += n4];
                        d3 = dArray3[n20 + 1];
                        d2 = dArray4[n21 += n8];
                        d = dArray4[n21 + 1];
                        d5 += d4 * d2 - d3 * d;
                        d6 += d3 * d2 + d4 * d;
                    }
                    n22 = n2 / 4;
                    while (--n22 >= 0) {
                        d4 = dArray3[n20 += n4];
                        d3 = dArray3[n20 + 1];
                        d2 = dArray4[n21 += n8];
                        d = dArray4[n21 + 1];
                        d5 += d4 * d2 - d3 * d;
                        d6 += d3 * d2 + d4 * d;
                        d4 = dArray3[n20 += n4];
                        d3 = dArray3[n20 + 1];
                        d2 = dArray4[n21 += n8];
                        d = dArray4[n21 + 1];
                        d5 += d4 * d2 - d3 * d;
                        d6 += d3 * d2 + d4 * d;
                        d4 = dArray3[n20 += n4];
                        d3 = dArray3[n20 + 1];
                        d2 = dArray4[n21 += n8];
                        d = dArray4[n21 + 1];
                        d5 += d4 * d2 - d3 * d;
                        d6 += d3 * d2 + d4 * d;
                        d4 = dArray3[n20 += n4];
                        d3 = dArray3[n20 + 1];
                        d2 = dArray4[n21 += n8];
                        d = dArray4[n21 + 1];
                        d5 += d4 * d2 - d3 * d;
                        d6 += d3 * d2 + d4 * d;
                    }
                    double d7 = dArray5[n18];
                    double d8 = dArray5[n18 + 1];
                    dArray5[n18] = dArray[0] * d5 - dArray[1] * d6 + dArray2[0] * d7 - dArray2[1] * d8;
                    dArray5[n18 + 1] = dArray[1] * d5 + dArray[0] * d6 + dArray2[1] * d7 + dArray2[0] * d8;
                    n17 += n7;
                    n18 += n9;
                }
                n13 += n5;
                n15 += n6;
            }
        }
        return dComplexMatrix2D2;
    }

    @Override
    public double[] zSum() {
        double[] dArray = new double[2];
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n3;
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n4 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                n3 = i * n4;
                final int n5 = i == n2 - 1 ? this.columns : n3 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        double[] dArray = new double[2];
                        int n4 = n + n3 * DenseColumnDComplexMatrix2D.this.columnStride;
                        for (int i = n3; i < n5; ++i) {
                            int n2 = n4;
                            for (int j = 0; j < DenseColumnDComplexMatrix2D.this.rows; ++j) {
                                dArray[0] = dArray[0] + DenseColumnDComplexMatrix2D.this.elements[n2];
                                dArray[1] = dArray[1] + DenseColumnDComplexMatrix2D.this.elements[n2 + 1];
                                n2 += DenseColumnDComplexMatrix2D.this.rowStride;
                            }
                            n4 += DenseColumnDComplexMatrix2D.this.columnStride;
                        }
                        return dArray;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    double[] dArray2 = (double[])futureArray[n3].get();
                    dArray[0] = dArray[0] + dArray2[0];
                    dArray[1] = dArray[1] + dArray2[1];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            int n6 = n;
            for (int i = 0; i < this.columns; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.rows; ++j) {
                    dArray[0] = dArray[0] + this.elements[n7];
                    dArray[1] = dArray[1] + this.elements[n7 + 1];
                    n7 += this.rowStride;
                }
                n6 += this.columnStride;
            }
        }
        return dArray;
    }

    @Override
    protected boolean haveSharedCellsRaw(DComplexMatrix2D dComplexMatrix2D) {
        if (dComplexMatrix2D instanceof SelectedDenseColumnDComplexMatrix2D) {
            SelectedDenseColumnDComplexMatrix2D selectedDenseColumnDComplexMatrix2D = (SelectedDenseColumnDComplexMatrix2D)dComplexMatrix2D;
            return this.elements == selectedDenseColumnDComplexMatrix2D.elements;
        }
        if (dComplexMatrix2D instanceof DenseColumnDComplexMatrix2D) {
            DenseColumnDComplexMatrix2D denseColumnDComplexMatrix2D = (DenseColumnDComplexMatrix2D)dComplexMatrix2D;
            return this.elements == denseColumnDComplexMatrix2D.elements;
        }
        return false;
    }

    @Override
    public long index(int n, int n2) {
        return this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride;
    }

    @Override
    protected DComplexMatrix1D like1D(int n, int n2, int n3) {
        return new DenseDComplexMatrix1D(n, this.elements, n2, n3, false);
    }

    @Override
    protected DComplexMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedDenseColumnDComplexMatrix2D(this.elements, nArray, nArray2, 0);
    }
}

