/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.quantile;

import cern.jet.random.tdouble.DoubleUniform;
import cern.jet.random.tdouble.engine.DRand;
import cern.jet.random.tdouble.engine.DoubleRandomEngine;
import hep.aida.tdouble.bin.DynamicDoubleBin1D;
import hep.aida.tdouble.bin.QuantileDoubleBin1D;
import java.text.DecimalFormat;
import java.util.Date;

public class TestQuantile1 {
    public static void main(String[] stringArray) {
        int n = 0;
        try {
            n = Integer.parseInt(stringArray[0]);
        }
        catch (Exception exception) {
            System.err.println("Unable to parse input line count argument");
            System.err.println(exception.getMessage());
            System.exit(1);
        }
        System.out.println("Got numExamples=" + n);
        long l = 0L;
        try {
            l = stringArray[1].equals("L") ? Long.MAX_VALUE : (stringArray[1].equals("I") ? Integer.MAX_VALUE : Long.parseLong(stringArray[1]));
        }
        catch (Exception exception) {
            System.err.println("Error parsing flag for N");
            System.err.println(exception.getMessage());
            System.exit(1);
        }
        System.out.println("Got N=" + l);
        DRand dRand = new DRand(new Date());
        QuantileDoubleBin1D quantileDoubleBin1D = new QuantileDoubleBin1D(false, l, 1.0E-4, 0.001, 200, (DoubleRandomEngine)dRand, false, false, 2);
        DynamicDoubleBin1D dynamicDoubleBin1D = new DynamicDoubleBin1D();
        DoubleUniform doubleUniform = new DoubleUniform(new DRand(7757));
        for (int i = 1; i <= n; ++i) {
            double d = doubleUniform.nextDouble();
            quantileDoubleBin1D.add(d);
            dynamicDoubleBin1D.add(d);
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        System.out.println();
        int n2 = 10;
        for (int i = 1; i < 100; i += n2) {
            double d = (double)i * 0.01;
            double d2 = quantileDoubleBin1D.quantile(d);
            System.out.println(decimalFormat.format(d) + "  " + d2 + ",  " + dynamicDoubleBin1D.quantile(d) + ",  " + (dynamicDoubleBin1D.quantile(d) - d2));
        }
    }
}

