% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FullConditionals.R
\name{G_moments}
\alias{G_moments}
\alias{G_expected}
\alias{G_variance}
\title{1st & 2nd Moments of the Dirichlet / Pitman-Yor Processes}
\usage{
G_expected(N,
           alpha,
           discount = 0)

G_variance(N,
           alpha,
           discount = 0)
}
\arguments{
\item{N}{The sample size.}

\item{alpha}{The concentration parameter. Must be specified and must be strictly greater than \code{-discount}.}

\item{discount}{The discount parameter for the Pitman-Yor process. Must lie in the interval [0, 1). Defaults to 0 (i.e. the Dirichlet process).}
}
\value{
The expected number of clusters under the specified prior conditions, or the variance of the number of clusters.
}
\description{
Calculates the \emph{a priori} expected number of clusters or the variance of the number of clusters under a Dirichlet process or Pitman-Yor process prior for a sample of size \code{N} at given values of the concentration parameter \code{alpha} and optionally also the Pitman-Yor \code{discount} parameter. Useful for soliciting sensible priors (or fixed values) for \code{alpha} or \code{discount} under the "\code{IMFA}" and "\code{IMIFA}" methods for \code{\link{mcmc_IMIFA}}.
}
\details{
All arguments are vectorised. Users can also consult \code{\link{G_priorDensity}} in order to solicit sensible priors.
}
\note{
Requires use of the \code{Rmpfr} and \code{gmp} libraries for non-zero \code{discount} values.
}
\examples{
G_expected(N=50, alpha=19.23356)
G_variance(N=50, alpha=19.23356)

# require("Rmpfr")
# G_expected(N=50, alpha=c(19.23356, 12.21619, 1), discount=c(0, 0.25, 0.7300045))
# G_variance(N=50, alpha=c(19.23356, 12.21619, 1), discount=c(0, 0.25, 0.7300045))
}
\seealso{
\code{\link{G_priorDensity}}, \code{\link[Rmpfr]{Rmpfr}}
}
\author{
Keefe Murphy - <\email{keefe.murphy@ucd.ie}>
}
\keyword{utility}
