% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLupdater.R
\name{translateGLstring}
\alias{translateGLstring}
\title{Translate a GL String across IPD-IMGT/HLA Database Release Versions}
\usage{
translateGLstring(GLstring, from, to, expand = FALSE, verbose = FALSE)
}
\arguments{
\item{GLstring}{A GL String of HLA allele names.}

\item{from}{A character string identifying the IPD-IMGT/HLA Database release version of 'GLstring'.}

\item{to}{A character string identifying the IPD-IMGT/HLA Database release version to translate 'GLstring' to. Values can range from version 1.05.0 to the loaded version of the alleleListHistory object.}

\item{expand}{A logical that indicates if the lowest-numbered truncated allele names that match truncated allele names in the GL String should be returned (expand = FALSE), or if a slash-delimited string of all matching full-length allele names should be returned (expand = TRUE). The default value is FALSE.}

\item{verbose}{A logical that indicates if messages regarding allele translations should be sent to the console (TRUE) or not (FALSE). The default value is FALSE.}
}
\value{
A GL String of allele names in the 'to' release version. If the GL String is determined to be invalid, FALSE is returned.
}
\description{
Translates a single Genotype List (GL) string across IPD-IMGT/HLA Database release versions. Truncated allele names can be expanded to the list of all allele names that contain the truncated name.
}
\examples{
translateGLstring(GLstring.ex$Gl.String[1],"3.01.0","2.15.0")
translateGLstring(GLstring.ex$Gl.String[1],"3.01.0","2.15.0",TRUE)
translateGLstring(GLstring.ex$Gl.String[1],"3.01.0","2.15.0",FALSE,TRUE)
translateGLstring(GLstring.ex$Gl.String[1],"3.01.0","2.15.0",TRUE,TRUE)

}
\references{
Mack et al. HLA 2023;102(2):206-212 https://doi.org/10.1111/tan.15126
}
