% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app_server.R
\name{GenEstServer}
\alias{GenEstServer}
\alias{reaction}
\alias{reactionMessageRun}
\alias{reactionMessageDone}
\alias{eventReaction}
\title{The GenEst server definition function}
\usage{
GenEstServer(input, output, session)

reaction(eventName)

reactionMessageRun(eventName)

reactionMessageDone(eventName)

eventReaction(eventName, rv, input, output, session)
}
\arguments{
\item{input}{\code{input} list for the GenEst GUI.}

\item{output}{\code{output} list for the GenEst GUI.}

\item{session}{Environment for the GenEst GUI.}

\item{eventName}{Character name of the event. One of "clear_all",
"file_SE", "file_SE_clear", "file_CP", "file_CP_clear", "file_SS",
"file_SS_clear", "file_DWP", "file_DWP_clear", "file_CO", 
"file_CO_clear", "class", "obsSE", "predsSE", "run_SE", "run_SE_clear",
"outSEclass", "outSEp", "outSEk", "ltp", "fta", "predsCP", "run_CP",
"run_CP_clear", "outCPclass", "outCPdist", "outCPl", "outCPs",
"run_M", "run_M_clear", "split_M", "split_M_clear", "transpose_split",
"useSSdata", "useSSinputs", "run_g", "run_g_clear", or "outgclass".}

\item{rv}{Reactive values list for the GenEst GUI.}
}
\value{
\code{reaction}: An object of type 
 "\code{\link[base]{expression}}" returned from
  \code{\link[base]{parse}} using the \code{text} argument. This is a 
  parsed but unevaluated expression, ready to be evaluated by
  \code{\link[base]{eval}}.

\code{reactionMessageRun}: Reaction running message expression, as
  a character string.

\code{reactionMessageDone}: Reaction done message expression, as
  a character string.
}
\description{
This suite of functions defines the server-side program for
  the GenEst user interface (UI). See the "GenEst Graphic User Interface"
  vignette for a more complete detailing of the codebase underlying
  the GenEst UI. \cr \cr \code{GenEstServer}: main server function
  expressed within the application.

\code{reaction}: creates a handler expression to be 
  used by \code{\link[shiny]{observeEvent}} within \code{GenEstServer}, 
  which includes the call to \code{eventReaction} (the function that 
  manages the reaction once the code is evaluated), any message generation 
  or handling, and the enclosing curly braces. Calls 
  \code{reactionMessageRun} and \code{reactionMessageDone} to create the 
  event-specific reaction expression message components.

\code{reactionMessageRun}: Creates the message for model
  running, or clears the existing notifications if desired.

\code{reactionMessageDone}: Creates the message for model
  done running.

\code{eventReaction}: Manages the running of the update
  functions for rv, output, and input, based on the \code{eventName}.
}
\details{
\code{GenEstServer} is used as the main server function, and is
  therefore included in the \code{server.R} script of the app. This 
  function is not used in a standard R function sense, in that it does
  not return a value and is not used on its own to have side effects.
  The code of the function has two parts: 
  \enumerate{
    \item preamble that defines all the necessary variables and options
    \item \code{\link[shiny]{observeEvent}} calls, one for each event in
      the application. Each call to \code{\link[shiny]{observeEvent}} 
      includes the \code{eventExpr} (event expression) as the first 
      argument and the \code{handlerExpr} (handler expression) as the 
      second argument, which is an evaluated (via \code{\link[base]{eval}})
      block of code returned from \code{reaction} for the specific 
      event, as well as any other control switch arguments needed (such as
      \code{ignoreNULL}). 
  }
}
