% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle_gp.R
\name{mle_gp}
\alias{mle_gp}
\title{mle_gp}
\usage{
mle_gp(
  y,
  x,
  sep = TRUE,
  mu = FALSE,
  g = FALSE,
  fixed_g = NULL,
  profile = TRUE,
  initialvals = NULL,
  penalty = FALSE,
  scad = FALSE,
  lambda = 0,
  ncores = 1
)
}
\arguments{
\item{y}{A numeric vector of the response variable.}

\item{x}{A numeric vector or matrix of the input variables.}

\item{sep}{Logical indicator for using a separable kernel function (\code{sep=TRUE}) or an isotropic kernel function (\code{sep=FALSE}).
Default is TRUE.}

\item{mu}{Logical indicator for assuming zero mean (\code{mu=FALSE}) or estimating the mean (\code{mu=TRUE}).
Default is FALSE (assumes the data is centered beforehand).}

\item{g}{Logical indicator for fixing the nugget value to a small constant (\code{g=FALSE}) or estimating the nugget (\code{g=TRUE}). Default is FALSE.}

\item{fixed_g}{Nugget value to fix when \code{g=FALSE}. Default is \code{fixed_g=NULL}. If NULL, the nugget is fixed to 1.490116e-08.}

\item{profile}{Logical indicator for optimizing the profile log-likelihood (\code{profile=TRUE}). When TRUE, the log-likelihood is a function of lengthscale and nugget only.
Solve the closed forms for scale and mu parameters. When FALSE, the full log-likelihood is optimized (lengthscale, scale, mean, and nugget are estimated together). Default is TRUE.}

\item{initialvals}{A numeric vector or matrix of initial values for optimization. The length should match the number of parameters to estimate.
Default is NULL. If NULL, 10 sets of initial values are randomly generated.}

\item{penalty}{Logical indicator for penalization. Default is \code{penalty=FALSE} (returns MLE). When \code{penalty=TRUE} and no lambda value is specified, a set of estimated values along with evaluated lambda values is returned.}

\item{scad}{Logical indicator for a lasso penalty (\code{scad=FALSE}) or SCAD penalty (\code{scad=TRUE}) when \code{penalty=TRUE}. Default is lasso penalty.}

\item{lambda}{Tuning parameter value. Default is 0 (MLE). The user may specify a custom lambda value.}

\item{ncores}{A number of cores for parallel computing with \code{optim}. Default is 1 (no parallelization). Make sure your system supports the specified number of cores.}
}
\value{
A list of y, x, and hyperparameters:
\itemize{
\item \code{y}: A copy of y.
\item \code{x}: A copy of x.
\item \code{theta}: A matrix of estimated lengthscale parameter.
\item \code{sigma2}: The estimated scale parameter.
\item \code{mu}: Returns 0 if \code{mu=FALSE} otherwise the estimated mu parameter.
\item \code{g}: Returns the \code{fixed_g} value if \code{g=FALSE} otherwise the estimated nugget value.
\item \code{penalty}: A copy of the penalty indicator.
\item \code{lambda}: A vector of evaluated lambda values if \code{penalty=TRUE} otherwise NULL.
}
}
\description{
The function computes maximum likelihood estimates for the lengthscale, scale, mu, and nugget (g) parameters using \code{optim},
with options to fix or assume zero for certain parameters.
}
\details{
The function uses numerical optimization for lengthscale and nugget parameters as
there's no closed-form solutions. In contrast, closed form solutions exist for the scale and
mu parameters. Users have options to choose whether to solve them analytically or include them in optimization process.
If mu is assumed to be zero (by setting \code{mu=FALSE}), the input data should be centered beforehand.
The nugget term (g) can also be optimized alongside the lengthscale parameter or fixed to a small constant.
When no initial values are provided (\code{initialvals=NULL}), the function generates 10 random sets
and selects the one that minimizes the negative log-likelihood.
Additionally, users can apply a penalty to the lengthscale parameter by specifying a tuning parameter, lambda.
For guidance on choosing lambda, refer to \code{gp_cv} function.
}
\examples{
### training data ###
n <- 8

### test function ###
f_x <- function(x) {
return(sin(2*pi*x) + x^2)
}

### generate x ###
x <- runif(n, 0, 1)

y <- f_x(x)

### Optimize only the lengthscale parameter and solve for scale. ###
### Assume zero mean and fix g to a small constant. ###
fit <- mle_gp(y, x)
\donttest{
### Include etimation of mu ###
fit <- mle_gp(y, x, mu=TRUE)

### Optimize g as well ###
fit <- mle_gp(y, x, mu=TRUE, g=TRUE)

### Jointly optimize the lengthscale and scale ###
fit <- mle_gp(y, x, profile=FALSE)

### Fix g to a user specified value ###
fit <- mle_gp(y, x, fixed_g=0.0001)
}

}
