% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rhodcca_test.R
\name{rhodcca.test}
\alias{rhodcca.test}
\title{Statistical test for detrended cross-correlation coefficient}
\usage{
rhodcca.test(N, k, nu, rep)
}
\arguments{
\item{N}{An integer value for the time series length.}

\item{k}{An integer value indicating the boundary of the division \eqn{(N/k)}.
The smallest value of \eqn{k} is \eqn{4}.}

\item{nu}{An integer value. See the DCCA package.}

\item{rep}{An integer value indicating the number of repetitions.}
}
\value{
An list containing "timescale","mean", "sd" and confidence interval: "CI_0.90", "CI_0.95", "CI_0.99".
}
\description{
This function performs the statistical test for RHODCCA cross-correlation coefficient based in White Gaussian Noise process.
}
\details{
This function include following measures: timescale and cross-correlation yx.
}
\examples{
rhodcca.test(N=100, k=10, nu=0, rep=10)

}
\references{
B. Podobnik, Z.-Q. Jiang, W.-X. Zhou, H. E. Stanley, Statistical tests for power-law cross-correlated processes, Phys. Rev.,E 84, 066118, 2011.
}
