% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{case01plot}
\alias{case01plot}
\title{Plot results for density-based or mark-recapture sampling}
\usage{
case01plot(
  res,
  obs,
  land1,
  land2,
  land3,
  agents,
  paras,
  ACTION,
  COST,
  view = NULL,
  times = 1
)
}
\arguments{
\item{res}{The resources array produced by the resource function within GMSE}

\item{obs}{The array of resource observations from the observation model, used to estimate abundance of resources}

\item{land1}{The first layer of the 3D landscape array, which indicates values of terrain for plotting (as of now, terrain values have no effect on the simulation and only exist for display purposes)}

\item{land2}{The full list showing all layers of the landscape in each time step of GMSE}

\item{land3}{The third layer of the 3D landscape array, which indicates agent ownership of the land}

\item{agents}{The array of agents produced in the main gmse() function}

\item{paras}{The vector of parameters that hold global and dynamic parameter values used by GMSE}

\item{ACTION}{A three dimensional array of agent (manager and stakeholder) actions}

\item{COST}{A three dimensional array of cost values for agent (manager and stakeholder) actions}

\item{view}{The distance that an agent can see on a landscape}

\item{times}{The number of times that resources are sampled per time step}
}
\value{
This function plots the dynamics of GMSE resource, observation, managemer, and user models in six separate sub-panels. (1) Upper left panel: Shows the locations of resources on the landscape (black dots); landscape terrain is also shown in brown, but at the moment, this is only cosmetic and does not reflect anything occurring in the model. (2) Upper right panel: Shows ownership of land by agents; land is divided proportional based on parameters set in gmse() and colours correspond with other subplots. If agent utilities and actions are restricted to land (`land_ownership` in the gmse() function), then this gives some idea of where actions are being performed and where resources are affecting the landscape. (3) Middle left panel: Shows the actual population abundance (black solid line) and the population abundance estimated by the manager (blue solid line; shading indicates 95 percent confidence intervals) over time. The dotted red line shows the resource carrying capacity (death-based) and the dotted blue line shows the target for resource abundance as set in the gmse() function; the orange line shows the total percent yield of the landscape (i.e., 100 percent means that resources have not decreased yield at all, 0 percent means that resources have completely destroyed all yield). (4) Middle right panel: Shows the raw landscape yield for each stakeholder (can be ignored if `land_ownership` is FALSE) over time; colours correspond to land ownership shown in the upper right panel. (5) Lower left panel: The cost of stakeholders performing actions over time, as set by the manager. (6) Lower right panel: The total number of actions performed by all stakeholders over time.
}
\description{
Produce six panels on a plot showing resource distribution, owned land, resource dynamics and estimates, stake-holder yield, and action costs and actions made. This plot is run internally within the gmse function, and should not be used to plot results stored after running the gmse function (for this, use plot_gmse_results).
}
\examples{
\dontrun{
case01plot(res = RESOURCE_REC, obs = OBSERVATION_REC, 
land1 = LANDSCAPE_r[,,1], land2  = LANDSCAPE_REC, land3  = LANDSCAPE_r[,,3], 
agents = AGENT_REC, paras = paras, ACTION = ACTION_REC, COST = COST_REC, 
view = agent_view, times = times_observe);
}
}
