% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg-plots.R
\name{ggally_facetdensity}
\alias{ggally_facetdensity}
\title{Faceted density plot}
\usage{
ggally_facetdensity(data, mapping, ...)
}
\arguments{
\item{data}{data set using}

\item{mapping}{aesthetics being used}

\item{...}{other arguments being sent to stat_density}
}
\description{
Make density plots by displaying subsets of the data in different panels.
}
\examples{
# Small function to display plots only if it's interactive
p_ <- GGally::print_if_interactive

data(tips, package = "reshape")
p_(ggally_facetdensity(tips, mapping = ggplot2::aes(x = total_bill, y = sex)))
p_(ggally_facetdensity(
  tips,
  mapping = ggplot2::aes_string(y = "total_bill", x = "sex", color = "sex")
))
}
\author{
Barret Schloerke
}
\keyword{hplot}
