% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/gemCanonicalDynamicMacroeconomic_TimeCircle_2_2.R
\name{gemCanonicalDynamicMacroeconomic_TimeCircle_2_2}
\alias{gemCanonicalDynamicMacroeconomic_TimeCircle_2_2}
\title{A Canonical Dynamic Macroeconomic General Equilibrium Model in Time-circle Form (see Torres, 2016)}
\usage{
gemCanonicalDynamicMacroeconomic_TimeCircle_2_2(
  alpha.firm = rep(1, 3),
  es.prod.lab.firm = 1,
  beta.prod.firm = 0.35,
  depreciation.rate = 0.06,
  eis = 1,
  rho.beta = 0.97,
  beta.prod.consumer = 0.4,
  es.prod.lab.consumer = 1,
  gr = 0,
  wage.payment = "post",
  ...
)
}
\arguments{
\item{alpha.firm}{a positive vector, indicating the efficiency parameters of the firm for each planning period.
The number of planning periods will be set to length(alpha.firm) .}

\item{es.prod.lab.firm}{the elasticity of substitution between product and labor in the production function of the firm.}

\item{beta.prod.firm}{the share parameter of the product in the production function.}

\item{depreciation.rate}{the physical depreciation rate of capital stock.}

\item{eis}{the elasticity of intertemporal substitution of the consumer.}

\item{rho.beta}{the subjective discount factor of the consumer.}

\item{beta.prod.consumer}{the share parameter of the product in the period utility function.}

\item{es.prod.lab.consumer}{the elasticity of substitution between product and labor in the CES-type period utility function of the consumer.}

\item{gr}{the growth rate of the labor supply.}

\item{wage.payment}{a character string specifying the wage payment method, must be one of "pre" or "post".}

\item{...}{arguments to be passed to the function sdm2.}
}
\value{
A general equilibrium (see \code{\link{sdm2}}).
}
\description{
A canonical dynamic macroeconomic general equilibrium model in time-circle form (see Torres, 2016, Table 2.1 and 2.2).
}
\examples{
\donttest{
#### Take the wage postpayment assumption.
ge <- gemCanonicalDynamicMacroeconomic_TimeCircle_2_2()
np <- 3
eis <- 1
rho.beta <- 0.97
gr <- 0
ge$p
growth_rate(ge$p[1:np])
1 / (1 + sserr(eis = eis, rho.beta = rho.beta, gr = gr)) - 1
ge$z
growth_rate(ge$z[1:np])
ge$D
ge$S

##  Take the wage postpayment assumption.
eis <- 0.8
rho.beta <- 0.97
gr <- 0.03
ge <- gemCanonicalDynamicMacroeconomic_TimeCircle_2_2(
  es.prod.lab.firm = 0.8,
  eis = eis, rho.beta = rho.beta, es.prod.lab.consumer = 0.8,
  gr = gr
)

ge$p
growth_rate(ge$p[1:np])
1 / (1 + sserr(eis = eis, rho.beta = rho.beta, gr = gr)) - 1
ge$z
growth_rate(ge$z[1:np])
ge$D
ge$S

#### an anticipated technology shock.
## Warning: Running the program below takes about 4 minutes.
# np <- 120
# alpha.firm <- rep(1, np)
# alpha.firm[40] <- 1.05
# ge <- gemCanonicalDynamicMacroeconomic_TimeCircle_2_2(alpha.firm = alpha.firm)

## The steady state product supply is 343.92.
## the (planning) time series of product supply
# plot(ge$z[1:np] / 343.92 - 1, type = "o", pch = 20)
## The steady state product consumption is 57.27.
## the (planning) time series of product consumption
# plot(ge$D[2:np, np + 1] / 57.27 - 1, type = "o", pch = 20)

#### Take the wage prepayment assumption.
ge <- gemCanonicalDynamicMacroeconomic_TimeCircle_2_2(wage.payment = "pre")
np <- 3
eis <- 1
rho.beta <- 0.97
gr <- 0
ge$p
growth_rate(ge$p[1:np])
1 / (1 + sserr(eis = eis, rho.beta = rho.beta, gr = gr)) - 1
ge$z
growth_rate(ge$z[1:np])
ge$D
ge$S

##  Take the wage prepayment assumption.
eis <- 0.8
rho.beta <- 0.97
gr <- 0.03

ge <- gemCanonicalDynamicMacroeconomic_TimeCircle_2_2(
  es.prod.lab.firm = 0.8,
  eis = eis, es.prod.lab.consumer = 0.8,
  rho.beta = rho.beta, gr = gr,
  wage.payment = "pre"
)

ge$p
growth_rate(ge$p[1:np])
1 / (1 + sserr(eis = eis, rho.beta = rho.beta, gr = gr)) - 1
ge$z
growth_rate(ge$z[1:np])
ge$D
ge$S
}
}
\references{
Torres, Jose L. (2016, ISBN: 9781622730452) Introduction to Dynamic Macroeconomic General Equilibrium Models (Second Edition). Vernon Press.
}
\seealso{
\code{\link{gemCanonicalDynamicMacroeconomic_Timeline_2_2}},\cr
\code{\link{gemCanonicalDynamicMacroeconomic_Sequential_3_2}},\cr
\code{\link{gemCanonicalDynamicMacroeconomic_Sequential_WagePostpayment_4_3}}.
}
