% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iterate.R
\name{iterate}
\alias{iterate}
\title{Iteration Function}
\usage{
iterate(x, f, times = 100, tol = NA, ...)
}
\arguments{
\item{x}{the initial state vector.
If x has a name attribute, the names will be used to label the output matrix.}

\item{f}{a user-supplied function that computes the values of the next time.}

\item{times}{the iteration times.}

\item{tol}{the tolerance for stopping calculation. If the canberra distance of the last two
state vectors is less than tol the calculation will stop.}

\item{...}{optional arguments passed to the f function.}
}
\value{
A matrix consisting of state vectors.
}
\description{
Iteration function
}
\examples{
\donttest{
x <- c(1, 2)
f <- function(x, a) prop.table(c(sum(x), a * prod(x)^(1 / 2)))
iterate(x, f, 100, a = 3)
iterate(x, f, 100, tol = 1e-5, a = 3)

x <- c(1, 2, 3)
f <- function(x) {
  n <- length(x)
  sigma <- seq(-1, 1, length.out = n)
  result <- rep(NA, n)
  for (k in 1:n) result[k] <- CES(sigma[k], 1, rep(1 / n, n), x, rep(1 / n, n))
  prop.table(result)
}
iterate(x, f, 100)
}

}
