#' @title phi_psi_bar_plot
#'
#' @description Function to plot PDB file dihedral angle distribution per amino acid using a bar plot. NOTE: some PDB files have breakages in their amino acid sequences; that is, some residues might be missing and it will be reflected in the plot via empty spaces
#'
#' @param pdb_df Requires a PDB data frame generated by PDB_prepare
#' @return  Bar plot
#' @ImportFrom ggplot2 aes
#' @ImportFrom ggplot2 ggplot
#' @ImportFrom ggplot2 geom_bar
#' @ImportFrom ggplot2 scale_x_continuous
#' @ImportFrom ggplot2 scale_y_continuous
#' @ImportFrom ggplot2 labs
#' @ImportFrom ggplot2 ggtitle
#' @ImportFrom plotly  ggplotly
#' @export
#' @examples
#' path_to_processed_PDB<- system.file("extdata", "pdb_df.tabular", package="Fiscore")
#' # basic usage of phi_psi_bar_plot
#' pdb_df<-read.table(path_to_processed_PDB)
#' phi_psi_bar_plot(pdb_df)
phi_psi_bar_plot<-function(pdb_df){


  #to avoid namespace conflucts
  df_resno_val<-pdb_df$"df_resno"
  phi_val<-pdb_df$"phi"
  psi_val<-pdb_df$"psi"


  #Plot will capture breakage regions with empty
  plot_bar<-ggplot2::ggplot(pdb_df) + ggplot2::geom_bar(ggplot2::aes(x=df_resno_val, y = phi_val), color="red", alpha=0.2, stat = "identity")+ggplot2::geom_bar(ggplot2::aes(x =df_resno_val, y = psi_val), color="blue", alpha=0.2, stat = "identity") +ggplot2::labs(x="Residue number",y="phi/psi")+ggplot2::scale_x_continuous(breaks=seq(0,nrow(pdb_df),25), expand = c(0,0))+ggplot2::scale_y_continuous(breaks=c(-180,-120,-60,0,60,120,180),limits = c(-180,180), expand = c(0,0))+ggplot2::ggtitle(label="Dihedral angle distribution, psi - blue and phi - red ")


  plotly::ggplotly(plot_bar)


}
