#' @title Fi_score_region
#'
#' @description Function calculates combined Fi-score for a selected region; NOTE: some PDB files have breakages in their amino acid sequences and those values cannot be assessed. Moreover, values can be calculated either inclusively or not; include is set to FALSE by default
#'
#' @param pdb_df Requires a PDB data frame generated by PDB_prepare
#' @param i start residue for a region
#' @param j  end residue for a region
#' @param include inclusive or not calculation, default FALSE
#' @return  Fi-score value
#' @export
#' @examples
#' path_to_processed_PDB<- system.file("extdata", "pdb_df.tabular", package="Fiscore")
#' # basic usage of Fiscore_secondary
#' pdb_df<-read.table(path_to_processed_PDB)
#' Fi_score_region(pdb_df,900,925)
Fi_score_region<-function(pdb_df, i,j, include=FALSE){


  if(include==FALSE){
  i_index<-which(i==pdb_df$"df_resno")        #match res_no with data frame order
  j_index<-which(j==pdb_df$"df_resno")

  return((sum(pdb_df[i_index:j_index,"Fi_score"])/(j-i)))
  }
  else if(include==TRUE){
    i_index<-which(i==pdb_df$"df_resno")        #match res_no with data frame order
    j_index<-which(j==pdb_df$"df_resno")

    return((sum(pdb_df[i_index:j_index,"Fi_score"])/(j-i+1)))
  }


}
