plot.MFA=function (x, axes = c(1, 2), choix = c("ind","var","group","axes","freq"), ellipse = NULL, ellipse.par = NULL, 
    lab.grpe = TRUE, lab.var = TRUE, lab.ind = TRUE, lab.par = FALSE, lab.col = TRUE,
    habillage = "ind", col.hab = NULL, invisible = c("none","ind", "ind.sup", "quanti","quanti.sup","quali","row", "row.sup","col", "col.sup"), partial = NULL, 
    lim.cos2.var = 0., chrono = FALSE, xlim = NULL, ylim = NULL, 
    title = NULL, palette = NULL, autoLab = c("auto","yes","no"),new.plot = FALSE, select = NULL,
	unselect = 0.7,shadowtext=FALSE,...) 
{
    res.mfa <- x
    if (!inherits(res.mfa, "MFA")) stop("non convenient data")
    if (is.numeric(unselect)) if ((unselect>1)|(unselect<0)) stop("unselect should be betwwen 0 and 1")
    autoLab <- match.arg(autoLab,c("auto","yes","no"))
	if (autoLab=="yes") autoLab=TRUE
	if (autoLab=="no") autoLab=FALSE
    choix <- match.arg(choix,c("ind","var","group","axes","freq"))
	invisible <- match.arg(invisible,c("none","ind", "ind.sup", "quanti","quanti.sup","quali","row", "row.sup","col", "col.sup"),several.ok=TRUE)
    if ("none"%in%invisible) invisible = NULL
    lab.x <- paste("Dim ",axes[1]," (",format(res.mfa$eig[axes[1],2],nsmall=2,digits=2),"%)",sep="")
    lab.y <- paste("Dim ",axes[2]," (",format(res.mfa$eig[axes[2],2],nsmall=2,digits=2),"%)",sep="")
    group <- res.mfa$call$group
    nbre.grpe <- length(group)
    type <- res.mfa$call$type
    num.group.sup = NULL
    if (!is.null(res.mfa$group$coord.sup)) {
        num.group.sup <- res.mfa$call$num.group.sup
        nbre.grpe.sup <- length(num.group.sup)
        type.sup <- type[num.group.sup]
        type.act <- type[-num.group.sup]
        nbre.grpe <- nbre.grpe - length(num.group.sup)
    }
    if (choix == "axes") {
        if ((new.plot)&!nzchar(Sys.getenv("RSTUDIO_USER_IDENTITY"))) dev.new()
        if (is.null(palette)) palette(c("black", "red", "green3", "blue", "cyan", "magenta","darkgray", "darkgoldenrod", "darkgreen", "violet","turquoise", "orange", "lightpink", "lavender", "yellow","lightgreen", "lightgrey", "lightblue", "darkkhaki","darkmagenta", "darkolivegreen", "lightcyan", "darkorange","darkorchid", "darkred", "darksalmon", "darkseagreen","darkslateblue", "darkslategray", "darkslategrey","darkturquoise", "darkviolet", "lightgray", "lightsalmon","lightyellow", "maroon"))
        if (is.null(title)) title <- "Partial axes"
        plot(0, 0, xlab = lab.x, ylab = lab.y, xlim = c(-1.1, 1.1), ylim = c(-1.1, 1.1), col = "white", asp = 1, main = title,...)
        x.cercle <- seq(-1, 1, by = 0.01)
        y.cercle <- sqrt(1 - x.cercle^2)
        lines(x.cercle, y = y.cercle,...)
        lines(x.cercle, y = -y.cercle,...)
        abline(v = 0, lty = 2,...)
        abline(h = 0, lty = 2,...)
        coord.axes <- res.mfa$partial.axes$coord[, axes, drop = FALSE]
		if (!is.null(select)) {
		  if (mode(select)=="numeric") selection <- select
		  else {
		    if (sum(rownames(res.mfa$partial.axes$coord)%in%select)!=0) selection <- which(rownames(res.mfa$partial.axes$coord)%in%select)
			else {
 		    if (grepl("contrib",select)) selection <- (rev(order(res.mfa$partial.axes$contrib[,axes[1],drop=FALSE]*res.mfa$eig[axes[1],1]+res.mfa$partial.axes$contrib[,axes[2],drop=FALSE]*res.mfa$eig[axes[2],1])))[1:min(nrow(res.mfa$partial.axes$coord),sum(as.integer(unlist(strsplit(select,"contrib"))),na.rm=T))]
# 		    if (grepl("contrib",select)) selection <- (rev(order(apply(res.mfa$partial.axes$contrib[,axes],1,sum))))[1:min(nrow(res.mfa$partial.axes$coord),sum(as.integer(unlist(strsplit(select,"contrib"))),na.rm=T))]
 		    if (grepl("coord",select)) selection <- (rev(order(apply(res.mfa$partial.axes$coord[,axes]^2,1,sum))))[1:min(nrow(res.mfa$partial.axes$coord),sum(as.integer(unlist(strsplit(select,"coord"))),na.rm=T))]
			if (is.integer(select)) selection <- select
			}  
		  }
		}
        if (habillage == "group") {
            if (is.null(col.hab) | length(col.hab) < length(group)) {
			  if (is.null(res.mfa$call$num.group.sup)) col.hab <- 2:(length(group) + 1)
              else {
			    col.hab[which(!(1:length(group))%in%(res.mfa$call$num.group.sup))] <- 2:(1+length(group)-length(res.mfa$call$num.group.sup))
			    col.hab[res.mfa$call$num.group.sup] <- length(group)-length(res.mfa$call$num.group.sup)+1+(1:length(res.mfa$call$num.group.sup))
			  }
			}
            i = 1
            couleur.axes <- col.hab[i]
            auxil = strsplit(rownames(res.mfa$partial.axes$coord)[1], ".", fixed = TRUE)[[1]]
            auxil2 = auxil[length(auxil)]
            for (j in 2:nrow(res.mfa$partial.axes$coord)) {
                auxil = strsplit(rownames(res.mfa$partial.axes$coord)[j], ".", fixed = TRUE)[[1]]
                if (auxil2 != auxil[length(auxil)]) {
                  i = i + 1
                  auxil2 = auxil[length(auxil)]
                }
                couleur.axes <- c(couleur.axes, col.hab[i])
            }
        } else {
            couleur.axes <- NULL
            for (i in 1:length(group)) couleur.axes <- c(couleur.axes, rep("black", ncol(res.mfa$partial.axes$coord)))
        }
		posi <- coll <- NULL
		if (!is.null(select)){
 		  coord.axes <- coord.axes[selection,,drop=FALSE]
		  couleur.axes <- couleur.axes[selection]
		}
        for (v in 1:nrow(coord.axes)) {
          arrows(0, 0, coord.axes[v, 1], coord.axes[v, 2], length = 0.1, angle = 15, code = 2, col = couleur.axes[v], ...)
          if (abs(coord.axes[v,1])>abs(coord.axes[v,2])){
             if (coord.axes[v,1]>=0) posi<-c(posi,4)
             else posi<-c(posi,2)
          } else {
            if (coord.axes[v, 2] >= 0) posi <- c(posi,3)
            else posi <- c(posi,1)
          }
		  labe <- rownames(coord.axes)
        }
        if (autoLab=="auto") autoLab = (length(labe)<50)
		if (autoLab==FALSE) text(coord.axes[, 1], y = coord.axes[, 2], labels = labe, pos = posi, col = couleur.axes,...)
        if (autoLab==TRUE) autoLab(coord.axes[, 1], y = coord.axes[, 2], labels = labe, col=couleur.axes, shadotext=shadowtext,...)
        if (habillage == "group") legend("topleft", legend = rownames(res.mfa$group$Lg)[-length(rownames(res.mfa$group$Lg))], text.col = unique(couleur.axes), ...)
    }
	
    if (choix == "group") {
        coord.actif <- res.mfa$group$coord[, axes, drop = FALSE]
        if (!is.null(res.mfa$group$coord.sup))  coord.illu <- res.mfa$group$coord.sup[, axes, drop = FALSE]
		if (length(col.hab)==1) col.hab=rep(col.hab,length(group))
        if (is.null(col.hab)) {
            col.hab = rep("darkred", nrow(coord.actif))
            if (!is.null(res.mfa$group$coord.sup))  col.hab = c(col.hab, rep("darkolivegreen", nrow(coord.illu)))
        }
        if (habillage == "group") col.hab <- (2:(length(group) + 1))

	  if ((new.plot)&!nzchar(Sys.getenv("RSTUDIO_USER_IDENTITY"))) dev.new()
      if (is.null(palette)) palette(c("black", "red", "green3", "blue", "cyan", "magenta","darkgray", "darkgoldenrod", "darkgreen", "violet","turquoise", "orange", "lightpink", "lavender", "yellow","lightgreen", "lightgrey", "lightblue", "darkkhaki","darkmagenta", "darkolivegreen", "lightcyan", "darkorange","darkorchid", "darkred", "darksalmon", "darkseagreen","darkslateblue", "darkslategray", "darkslategrey","darkturquoise", "darkviolet", "lightgray", "lightsalmon","lightyellow", "maroon"))
	  coo <- labe <- coll <- ipch <- fonte <- NULL
	  if (is.null(xlim)) xlim <- c(0,1)
	  if (is.null(ylim)) ylim <- c(0,1)
      if (is.null(title))  title <- "Groups representation"
      plot(0, 0, main = title, xlab = lab.x, ylab = lab.y, xlim = xlim, ylim = ylim, asp=1, col="white", ...)
      abline(v=0,lty=2, ...)
      abline(h=0,lty=2, ...)
 	    coo <- rbind(coo,coord.actif)
	    if (lab.grpe){ labe <- c(labe,rownames(coord.actif))
	    } else  labe <- c(labe,rep("",nrow(coord.actif)))
		coll <- c(coll,col.hab[1:nrow(coord.actif)])
		ipch <- c(ipch,rep(17,nrow(coord.actif)))
		fonte <- c(fonte,rep(1,nrow(coord.actif)))
	  
      if (!is.null(res.mfa$group$coord.sup)) {
 	    coo <- rbind(coo,coord.illu)
	    if (lab.grpe){ labe <- c(labe,rownames(coord.illu))
	    } else  labe <- c(labe,rep("",nrow(coord.illu)))
	    coll <- c(coll,col.hab[(nrow(coord.actif) + 1):(nrow(coord.actif) + nrow(coord.illu))])
	    ipch <- c(ipch,rep(2,nrow(coord.illu)))
	    fonte <- c(fonte,rep(3,nrow(coord.illu)))
      }
	  if (shadowtext) points(coo[, 1], y = coo[, 2], pch = ipch, col = coll, ...)
	  if (autoLab=="auto") autoLab = (length(labe)<50)
      if (autoLab ==TRUE) autoLab(coo[, 1], y = coo[, 2], labels = labe, col = coll,  font=fonte,shadotext=shadowtext,...)
      if (autoLab ==FALSE) text(coo[, 1], y = coo[, 2], labels = labe, col = coll,  font=fonte,pos=3,...)
	  if (!shadowtext) points(coo[, 1], y = coo[, 2], pch = ipch, col = coll, ...)
	}
    if (choix == "var") {
        if ((new.plot)&!nzchar(Sys.getenv("RSTUDIO_USER_IDENTITY"))) dev.new()
        if (is.null(palette)) palette(c("black", "red", "green3", "blue", "cyan", "magenta","darkgray", "darkgoldenrod", "darkgreen", "violet","turquoise", "orange", "lightpink", "lavender", "yellow","lightgreen", "lightgrey", "lightblue", "darkkhaki","darkmagenta", "darkolivegreen", "lightcyan", "darkorange","darkorchid", "darkred", "darksalmon", "darkseagreen","darkslateblue", "darkslategray", "darkslategrey","darkturquoise", "darkviolet", "lightgray", "lightsalmon","lightyellow", "maroon"))
        test.invisible <- vector(length = 2)
        if (!is.null(invisible)) {
            test.invisible[1] <- match("quanti", invisible)
            test.invisible[2] <- match("quanti.sup", invisible)
        }
        else test.invisible <- rep(NA, 2)
        col <- NULL
        if (habillage == "group") {
            if (is.null(col.hab) | length(col.hab) < length(group[type == "c"])){
			  if (!is.null(res.mfa$call$num.group.sup)){
			    col.hab[which(!(1:length(group))%in%(res.mfa$call$num.group.sup))] <- 2:(1+length(group)-length(res.mfa$call$num.group.sup))
			    col.hab[res.mfa$call$num.group.sup] <- length(group)-length(res.mfa$call$num.group.sup)+1+(1:length(res.mfa$call$num.group.sup))
			    col <- c(1+rep(which(res.mfa$call$nature.group[-res.mfa$call$num.group.sup]=="quanti"),times=group[which(res.mfa$call$nature.group=="quanti")]),length(group)-length(res.mfa$call$num.group.sup)+1+rep(which((res.mfa$call$nature.group[res.mfa$call$num.group.sup])=="quanti.sup"),times=group[which(res.mfa$call$nature.group=="quanti.sup")]))
			  } else {
			    col.hab <- 2:(length(group)+1)
			    col <- 1+rep(which(type=="c"),times=group[type=="c"])
			  }
			}
						
        } else {
            if (is.null(col.hab) | length(col.hab) < sum(group[type == "c"])) col <- rep(1, sum(group[type == "c"]))
            else col <- col.hab
        }
        if (is.null(title))  title <- "Correlation circle"
        plot(0, 0, main = title, xlab = lab.x, ylab = lab.y, 
            xlim = c(-1.1, 1.1), ylim = c(-1.1, 1.1), col = "white", 
            asp = 1, ...)
        x.cercle <- seq(-1, 1, by = 0.01)
        y.cercle <- sqrt(1 - x.cercle^2)
        lines(x.cercle, y = y.cercle,...)
        lines(x.cercle, y = -y.cercle,...)
        abline(v = 0, lty = 2, ...)
        abline(h = 0, lty = 2, ...)
		if ((!is.null(select))&(!is.null(res.mfa["quanti.var"]$quanti.var))) {
		  if (mode(select)=="numeric") selection <- select
		  else {
		    if (sum(rownames(res.mfa$quanti.var$coord)%in%select)+sum(rownames(res.mfa$quanti.var.sup$coord)%in%select)!=0) selection <- which(rownames(res.mfa$quanti.var$coord)%in%select)
			else {
 		      if (grepl("contrib",select)) selection <- (rev(order(res.mfa$quanti.var$contrib[,axes[1],drop=FALSE]*res.mfa$eig[axes[1],1]+res.mfa$quanti.var$contrib[,axes[2],drop=FALSE]*res.mfa$eig[axes[2],1])))[1:min(nrow(res.mfa$quanti.var$coord),sum(as.integer(unlist(strsplit(select,"contrib"))),na.rm=T))]
# 		      if (grepl("contrib",select)) selection <- (rev(order(apply(res.mfa$quanti.var$contrib[,axes],1,sum))))[1:min(nrow(res.mfa$quanti.var$coord),sum(as.integer(unlist(strsplit(select,"contrib"))),na.rm=T))]
 		      if (grepl("coord",select)) selection <- (rev(order(apply(res.mfa$quanti.var$coord[,axes]^2,1,sum))))[1:min(nrow(res.mfa$quanti.var$coord),sum(as.integer(unlist(strsplit(select,"coord"))),na.rm=T))]
 		      if (grepl("cos2",select)) {
			    if (sum(as.numeric(unlist(strsplit(select,"cos2"))),na.rm=T)>=1) selection <- (rev(order(apply(res.mfa$quanti.var$cos2[,axes],1,sum))))[1:min(nrow(res.mfa$quanti.var$coord),sum(as.numeric(unlist(strsplit(select,"cos2"))),na.rm=T))]
				else selection <- which(apply(res.mfa$quanti.var$cos2[,axes],1,sum)>sum(as.numeric(unlist(strsplit(select,"cos2"))),na.rm=T))
			  }
			  if (is.integer(select)) selection <- select
			}  
		  }
		}
		if ((!is.null(select))&(!is.null(res.mfa$quanti.var.sup))) {
		  if (mode(select)=="numeric") selectionS <- select
		  else {
		    if (sum(rownames(res.mfa$quanti.var$coord)%in%select)+sum(rownames(res.mfa$quanti.var.sup$coord)%in%select)!=0) selectionS <- which(rownames(res.mfa$quanti.var.sup$coord)%in%select)
			else {
 		      if (grepl("contrib",select)) selectionS <- NULL
 		      if (grepl("coord",select)) selectionS <- (rev(order(apply(res.mfa$quanti.var.sup$coord[,axes]^2,1,sum))))[1:min(nrow(res.mfa$quanti.var.sup$coord),sum(as.integer(unlist(strsplit(select,"coord"))),na.rm=T))]
 		      if (grepl("cos2",select)) {
			    if (sum(as.numeric(unlist(strsplit(select,"cos2"))),na.rm=T)>=1) selectionS <- (rev(order(apply(res.mfa$quanti.var.sup$cos2[,axes],1,sum))))[1:min(nrow(res.mfa$quanti.var.sup$coord),sum(as.numeric(unlist(strsplit(select,"cos2"))),na.rm=T))]
				else selectionS <- which(apply(res.mfa$quanti.var.sup$cos2[,axes],1,sum)>sum(as.numeric(unlist(strsplit(select,"cos2"))),na.rm=T))
			  }
			  if (is.integer(select)) selectionS <- select
			}  
		  }
		}
		
		labe <- labe2 <- coll <- coll2 <- NULL
		if (!is.null(res.mfa["quanti.var"]$quanti.var)){
		  coll <- col[1:nrow(res.mfa["quanti.var"]$quanti.var$coord)]
		  if (lab.var) labe <- rownames(res.mfa["quanti.var"]$quanti.var$coord)
		   else  labe <- rep("",nrow(res.mfa["quanti.var"]$quanti.var$coord))
		}
		if (!is.null(res.mfa$quanti.var.sup)){
		  if (lab.var) labe2 <- rownames(res.mfa$quanti.var.sup$coord)
		  else  labe2 <- rep("",nrow(res.mfa$quanti.var.sup$coord))
		  coll2 <- col[(length(coll)+1):length(col)]
		}

	    if (!is.null(select)){
   		    if (!is.null(res.mfa["quanti.var"]$quanti.var)){			
		      if (is.numeric(unselect)) coll[!((1:length(coll))%in%selection)] = rgb(t(col2rgb(coll[!((1:length(coll))%in%selection)])),alpha=255*(1-unselect),maxColorValue=255) 
	          else coll[!((1:length(coll))%in%selection)] = unselect
			  labe[!((1:length(coll))%in%selection)] <- ""
	        }
 		    if (!is.null(res.mfa$quanti.var.sup)){
		      if (is.numeric(unselect)) coll2[!((1:length(coll2))%in%selectionS)] = rgb(t(col2rgb(coll2[!((1:length(coll2))%in%selectionS)])),alpha=255*(1-unselect),maxColorValue=255) 
	          else coll2[!((1:length(coll2))%in%selectionS)] = unselect
			  labe2[!((1:length(coll2))%in%selectionS)] <- ""
		    }
		}
        col <- c(coll,coll2)
		labe <- c(labe,labe2)
		
		if (habillage == "group" & is.na(test.invisible[1]) & is.na(test.invisible[2])) 
            legend("topleft", legend = rownames(res.mfa$group$Lg[-nrow(res.mfa$group$Lg), ])[type == "c"], text.col = col.hab[type == "c"], cex = 0.8*par("cex"))
        if (habillage == "group" & is.na(test.invisible[1]) & !is.na(test.invisible[2])){
            if ("quanti.sup"%in%res.mfa$call$nature.var) legend("topleft", legend = rownames(res.mfa$group$Lg[-c(num.group.sup, nrow(res.mfa$group$Lg)), ])[type.act == "c"], 
                text.col = col.hab[which(!((1:length(group))%in%res.mfa$call$num.group.sup))[type.act == "c"]], cex = 0.8*par("cex"))
            else legend("topleft", legend = rownames(res.mfa$group$Lg[-nrow(res.mfa$group$Lg), ])[type == "c"], 
                text.col = col.hab[type == "c"], cex = 0.8*par("cex"))
        }
		if (habillage == "group" & !is.na(test.invisible[1]) & is.na(test.invisible[2])){
            if ("quanti"%in%res.mfa$call$nature.var) legend("topleft", legend = rownames(res.mfa$group$Lg[num.group.sup, ])[type.sup == "c"], text.col = col.hab[res.mfa$call$num.group.sup[type.sup == "c"]], cex = 0.8*par("cex"))
			else legend("topleft", legend = rownames(res.mfa$group$Lg[num.group.sup, ])[type.sup == "c"], text.col = col.hab[res.mfa$call$num.group.sup[type.sup == "c"]], cex = 0.8*par("cex"))
		}
        nrow.coord.var <- 0
        coo <- posi <- NULL
		
        if ((!is.null(res.mfa["quanti.var"]$quanti.var))&(is.na(test.invisible[1]))){
        if (length(apply(res.mfa["quanti.var"]$quanti.var$cos2[, axes,drop=FALSE],1,sum, na.rm = TRUE) >= lim.cos2.var)>0){
		  coord.var <- res.mfa$quanti.var$cor[which(apply(res.mfa$quanti.var$cos2[, axes,drop=FALSE],1,sum, na.rm = TRUE) >= lim.cos2.var),axes,drop=FALSE]
          coo <- coord.var
          nrow.coord.var <- nrow.coord.var + nrow(coord.var)
		  for (v in 1:nrow(coord.var)) {
                arrows(0, 0, coord.var[v, 1], coord.var[v, 2], length = 0.1, angle = 15, code = 2, col = col[v])
                if (lab.var) {
                if (abs(coord.var[v,1])>abs(coord.var[v,2])){
                 if (coord.var[v,1]>=0) posi<-c(posi,4)
                 else posi<-c(posi,2)
                }
                else {
                 if (coord.var[v,2]>=0) posi<-c(posi,3)
                 else posi<-c(posi,1)
                }
                }
          }
        }}
        
       if ((!is.null(res.mfa$quanti.var.sup$coord))& (is.na(test.invisible[2]))){
        if (!is.null(res.mfa$quanti.var.sup$coord[ which(apply(res.mfa$quanti.var.sup$cos2[, axes,drop=FALSE],1,sum, na.rm = TRUE) >= lim.cos2.var),])) {
		  coord.quanti <- res.mfa$quanti.var.sup$cor[ which(apply(res.mfa$quanti.var.sup$cos2[, axes,drop=FALSE],1,sum, na.rm = TRUE) >= lim.cos2.var),axes,drop=FALSE]
          coo <- rbind(coo,coord.quanti)
            for (q in 1:nrow(coord.quanti)) {
                arrows(0, 0, coord.quanti[q, 1], coord.quanti[q, 2], length = 0.1, angle = 15, code = 2, lty = 2, col=col[nrow.coord.var+q],...)
                if (lab.var) {
                if (abs(coord.quanti[q,1])>abs(coord.quanti[q,2])){
                 if (coord.quanti[q,1]>=0) posi<-c(posi,4)
                 else posi<-c(posi,2)
                }
                else {
                 if (coord.quanti[q,2]>=0) posi<-c(posi,3)
                 else posi<-c(posi,1)
                }
                }
            }
		}
	   }	
	    if (autoLab=="auto") autoLab = (length(labe)<50)
        if (autoLab==FALSE) text(coo[, 1], y = coo[, 2], labels = labe, pos = posi, col = col,...)
        if (autoLab==TRUE) autoLab(coo[, 1], y = coo[, 2], labels = labe, col=col, shadotext=shadowtext,...)
        par(mar = c(5, 4, 4, 2) + 0.1)
    }
	if (choix=="freq"){
      if ((new.plot)&!nzchar(Sys.getenv("RSTUDIO_USER_IDENTITY"))) dev.new()
      if (is.null(palette)) palette(c("black", "red", "green3", "blue", "cyan", "magenta","darkgray", "darkgoldenrod", "darkgreen", "violet","turquoise", "orange", "lightpink", "lavender", "yellow","lightgreen", "lightgrey", "lightblue", "darkkhaki","darkmagenta", "darkolivegreen", "lightcyan", "darkorange","darkorchid", "darkred", "darksalmon", "darkseagreen","darkslateblue", "darkslategray", "darkslategrey","darkturquoise", "darkviolet", "lightgray", "lightsalmon","lightyellow", "maroon"))
      col.row = "black"
	  col.row.sup = "grey60"
      coord.col <- res.mfa$freq$coord[, axes, drop = FALSE]
      coord.row <- res.mfa$ind$coord[, axes]
      coord.row.sup <- coord.col.sup <- NULL
      if (!is.null(res.mfa$ind.sup)) coord.row.sup <- res.mfa$ind.sup$coord[, axes, drop = FALSE]
      if (!is.null(res.mfa$freq.sup)) coord.col.sup <- res.mfa$freq.sup$coord[, axes, drop = FALSE]

      test.invisible <- vector(length = 4)
      if (!is.null(invisible)) {
          test.invisible[1] <- match("row", invisible)
		  if (is.na(test.invisible[1])) test.invisible[1] <- match("ind", invisible)
          test.invisible[2] <- match("col", invisible)
		  if (is.na(test.invisible[2])) test.invisible[2] <- match("var", invisible)
          test.invisible[3] <- match("row.sup", invisible)
		  if (is.na(test.invisible[3])) test.invisible[3] <- match("ind.sup", invisible)
          test.invisible[4] <- match("col.sup", invisible)
		  if (is.na(test.invisible[4])) test.invisible[4] <- match("var.sup", invisible)
      }
      else  test.invisible <- rep(NA, 4)
      if (is.null(xlim)) {
        xmin <- xmax <- 0
        if(is.na(test.invisible[1])) xmin <- min(xmin, coord.row[,1])
        if(is.na(test.invisible[1])) xmax <- max(xmax, coord.row[,1])
        if(is.na(test.invisible[3])) xmin <- min(xmin, coord.row.sup[, 1])
        if(is.na(test.invisible[3])) xmax <- max(xmax, coord.row.sup[, 1])
        if(is.na(test.invisible[2])) xmin <- min(xmin, coord.col[,1])
        if(is.na(test.invisible[2])) xmax <- max(xmax, coord.col[,1])
        if(is.na(test.invisible[4])) xmin <- min(xmin, coord.col.sup[, 1])
        if(is.na(test.invisible[4])) xmax <- max(xmax, coord.col.sup[, 1])
          xlim <- c(xmin, xmax) * 1.2
      }
      else {
        xmin = xlim[1]
        xmax = xlim[2]
      }
      if (is.null(ylim)) {
        ymin <- ymax <- 0
        if(is.na(test.invisible[1])) ymin <- min(ymin, coord.row[,2])
        if(is.na(test.invisible[1])) ymax <- max(ymax, coord.row[,2])
        if(is.na(test.invisible[3])) ymin <- min(ymin, coord.row.sup[,2])
        if(is.na(test.invisible[3])) ymax <- max(ymax, coord.row.sup[,2])
        if(is.na(test.invisible[2])) ymin <- min(ymin, coord.col[,2])
        if(is.na(test.invisible[2])) ymax <- max(ymax, coord.col[,2])
        if(is.na(test.invisible[4])) ymin <- min(ymin, coord.col.sup[,2])
        if(is.na(test.invisible[4])) ymax <- max(ymax, coord.col.sup[,2])
        ylim <- c(ymin, ymax) * 1.2
      }
      else {
        ymin = ylim[1]
        ymax = ylim[2]
      }

      col <- NULL
      if (habillage == "group") {
          if (is.null(col.hab) | length(col.hab) < length(group[type == "f"])) col.hab <- 2:(length(group[type == "f"]) + 1)
          for (i in 1:length(group[type == "f"])) col <- c(col, rep(col.hab[i], group[type == "f"][i]))
      } else {
          if (is.null(col.hab) | length(col.hab) < sum(group[type == "f"])) col <- rep(1, sum(group[type == "f"]))
          else col <- col.hab
      }

      if (is.null(title)) titre <- "Factor map for the contingency table(s)"
      else titre <- title
      plot(0, 0, main = titre, xlab = lab.x, ylab = lab.y, xlim = xlim, ylim = ylim, col = "white", asp=1, ...)
      abline(h=0,lty=2,...)
      abline(v=0,lty=2,...)

      selection <- selectionC <- selectionS <- selectionCS <- NULL
	  if (!is.null(select)) {
		if (mode(select)=="numeric") selection <- select
		else {
		  if (sum(rownames(res.mfa$quanti.sup$coord)%in%select)+sum(rownames(res.mfa$freq$coord)%in%select)+sum(rownames(res.mfa$ind$coord)%in%select)+sum(rownames(res.mfa$ind.sup$coord)%in%select)!=0) selection <- which(rownames(res.mfa$ind$coord)%in%select)
		  else {
 		    if (grepl("contrib",select)) selection <- (rev(order(res.mfa$ind$contrib[,axes[1],drop=FALSE]*res.mfa$eig[axes[1],1]+res.mfa$ind$contrib[,axes[2],drop=FALSE]*res.mfa$eig[axes[2],1])))[1:min(nrow(res.mfa$ind$coord),sum(as.integer(unlist(strsplit(select,"contrib"))),na.rm=T))]
print(select)
# 		    if (grepl("contrib",select)) selection <- (rev(order(apply(res.mfa$ind$contrib[,axes],1,sum))))[1:min(nrow(res.mfa$ind$coord),sum(as.integer(unlist(strsplit(select,"contrib"))),na.rm=T))]
 		    if (grepl("inertia",select)) selection <- (rev(order(apply(res.mfa$ind$within.inertia[,axes],1,sum))))[1:min(nrow(res.mfa$ind$coord),sum(as.integer(unlist(strsplit(select,"inertia"))),na.rm=T))]
 		    if (grepl("coord",select)) selection <- (rev(order(apply(res.mfa$ind$coord[,axes]^2,1,sum))))[1:min(nrow(res.mfa$ind$coord),sum(as.integer(unlist(strsplit(select,"coord"))),na.rm=T))]
 		    if (grepl("cos2",select)) {
			  if (sum(as.numeric(unlist(strsplit(select,"cos2"))),na.rm=T)>=1) selection <- (rev(order(apply(res.mfa$ind$cos2[,axes],1,sum))))[1:min(nrow(res.mfa$ind$coord),sum(as.numeric(unlist(strsplit(select,"cos2"))),na.rm=T))]
			  else selection <- which(apply(res.mfa$ind$cos2[,axes],1,sum)>sum(as.numeric(unlist(strsplit(select,"cos2"))),na.rm=T))
			}
			if (is.integer(select)) selection <- select
		  }  
		}
	  }
	  if ((!is.null(select))&(!is.null(res.mfa$ind.sup$coord))) {
		if (mode(select)=="numeric") selectionS <- select
		else {
		  if (sum(rownames(res.mfa$quanti.sup$coord)%in%select)+sum(rownames(res.mfa$freq$coord)%in%select)+sum(rownames(res.mfa$ind$coord)%in%select)+sum(rownames(res.mfa$ind.sup$coord)%in%select)!=0) selectionS <- which(rownames(res.mfa$ind.sup$coord)%in%select)
		  else {
 		    if (grepl("contrib",select)) selectionS <- NULL
 		    if (grepl("inertia",select)) selectionS <- (rev(order(apply(res.mfa$ind.sup$within.inertia[,axes]^2,1,sum))))[1:min(nrow(res.mfa$ind.sup$coord),sum(as.integer(unlist(strsplit(select,"inertia"))),na.rm=T))]
 		    if (grepl("coord",select)) selectionS <- (rev(order(apply(res.mfa$ind.sup$coord[,axes]^2,1,sum))))[1:min(nrow(res.mfa$ind.sup$coord),sum(as.integer(unlist(strsplit(select,"coord"))),na.rm=T))]
 		    if (grepl("cos2",select)) {
			  if (sum(as.numeric(unlist(strsplit(select,"cos2"))),na.rm=T)>=1) selectionS <- (rev(order(apply(res.mfa$ind.sup$cos2[,axes],1,sum))))[1:min(nrow(res.mfa$ind.sup$coord),sum(as.numeric(unlist(strsplit(select,"cos2"))),na.rm=T))]
			  else selectionS <- which(apply(res.mfa$ind.sup$cos2[,axes],1,sum)>sum(as.numeric(unlist(strsplit(select,"cos2"))),na.rm=T))
			}
			if (is.integer(select)) selectionS <- select
		  }  
		}
	  }
	  if ((!is.null(select))&(!is.null(res.mfa$freq$coord))) {
		 if (mode(select)=="numeric") selectionC <- select
		 else {
		  if (sum(rownames(res.mfa$quanti.sup$coord)%in%select)+sum(rownames(res.mfa$freq$coord)%in%select)+sum(rownames(res.mfa$ind$coord)%in%select)+sum(rownames(res.mfa$ind.sup$coord)%in%select)!=0) selectionC <- which(rownames(res.mfa$freq$coord)%in%select)
		  else {
 		    if (grepl("contrib",select)) selectionC <- (rev(order(res.mfa$freq$contrib[,axes[1],drop=FALSE]*res.mfa$eig[axes[1],1]+res.mfa$freq$contrib[,axes[2],drop=FALSE]*res.mfa$eig[axes[2],1])))[1:min(nrow(res.mfa$freq$coord),sum(as.integer(unlist(strsplit(select,"contrib"))),na.rm=T))]
# 		    if (grepl("contrib",select)) selectionC <- (rev(order(apply(res.mfa$freq$contrib[,axes],1,sum))))[1:min(nrow(res.mfa$freq$coord),sum(as.integer(unlist(strsplit(select,"contrib"))),na.rm=T))]
 		    if (grepl("coord",select)) selectionC <- (rev(order(apply(res.mfa$freq$coord[,axes]^2,1,sum))))[1:min(nrow(res.mfa$freq$coord),sum(as.integer(unlist(strsplit(select,"coord"))),na.rm=T))]
 		    if (grepl("cos2",select)) {
			  if (sum(as.numeric(unlist(strsplit(select,"cos2"))),na.rm=T)>=1) selectionC <- (rev(order(apply(res.mfa$freq$cos2[,axes],1,sum))))[1:min(nrow(res.mfa$freq$coord),sum(as.numeric(unlist(strsplit(select,"cos2"))),na.rm=T))]
			  else selectionC <- which(apply(res.mfa$freq$cos2[,axes],1,sum)>sum(as.numeric(unlist(strsplit(select,"cos2"))),na.rm=T))
			}
			if (is.integer(select)) selectionC <- select
		  }  
		 }
	  }
	  if ((!is.null(select))&(!is.null(res.mfa$quanti.sup$coord))) {
		if (mode(select)=="numeric") selectionCS <- select
		else {
		  if (sum(rownames(res.mfa$quanti.sup$coord)%in%select)+sum(rownames(res.mfa$freq$coord)%in%select)+sum(rownames(res.mfa$ind$coord)%in%select)+sum(rownames(res.mfa$ind.sup$coord)%in%select)!=0) selectionCS <- which(rownames(res.mfa$quanti.sup$coord)%in%select)
		  else {
 		    if (grepl("contrib",select)) selectionCS <- NULL
 		    if (grepl("coord",select)) selectionCS <- (rev(order(apply(res.mfa$quanti.sup$coord[,axes]^2,1,sum))))[1:min(nrow(res.mfa$quanti.sup$coord),sum(as.integer(unlist(strsplit(select,"coord"))),na.rm=T))]
 		    if (grepl("cos2",select)) {
			  if (sum(as.numeric(unlist(strsplit(select,"cos2"))),na.rm=T)>=1) selectionCS <- (rev(order(apply(res.mfa$quanti.sup$cos2[,axes],1,sum))))[1:min(nrow(res.mfa$quanti.sup$coord),sum(as.numeric(unlist(strsplit(select,"cos2"))),na.rm=T))]
			  else selectionCS <- which(apply(res.mfa$quanti.sup$cos2[,axes],1,sum)>sum(as.numeric(unlist(strsplit(select,"cos2"))),na.rm=T))
			}
			if (is.integer(select)) selectionCS <- select
		  }  
		}
	  }

		
	  coo <- labe <- coll <- ipch <- fonte <- NULL
      if (is.na(test.invisible[1])) {
		coo <- rbind(coo,coord.row)
		if (lab.ind){ labe <- rownames(coord.row)
		} else  labe <- rep("",nrow(coord.row))
		coll <- rep(col.row,nrow(coord.row))
		ipch <- c(ipch,rep(20,nrow(coord.row)))
		fonte <- c(fonte,rep(1,nrow(coord.row)))
	    if (!is.null(selection)){
	      if (is.numeric(unselect)) coll[!((1:length(coll))%in%selection)] = rgb(t(col2rgb(coll[!((1:length(coll))%in%selection)])),alpha=255*(1-unselect),maxColorValue=255)
	      else coll[!((1:length(coll))%in%selection)] = unselect
		  labe[!((1:length(coll))%in%selection)] <- ""
	    }
      }
      if (is.na(test.invisible[2])) {
		coo <- rbind(coo,coord.col)
		if (lab.ind){ labe2 <- rownames(coord.col)
		} else  labe2 <- rep("",nrow(coord.col))
		coll2 <- col[1:nrow(coord.col)]
		ipch <- c(ipch,rep(17,nrow(coord.col)))
		fonte <- c(fonte,rep(1,nrow(coord.col)))
	    if (!is.null(selectionC)){
	      if (is.numeric(unselect)) coll2[!((1:length(coll2))%in%selectionC)] = rgb(t(col2rgb(coll2[!((1:length(coll2))%in%selectionC)])),alpha=255*(1-unselect),maxColorValue=255)
	      else coll2[!((1:length(coll2))%in%selectionC)] = unselect
		  labe2[!((1:length(coll2))%in%selectionC)] <- ""
	    }
		coll <- c(coll,coll2)
		labe <- c(labe,labe2)
      }
      if (!is.null(res.mfa$quanti.sup) & is.na(test.invisible[4])) {
		coo <- rbind(coo,coord.col.sup)
		if (lab.ind){ labe2 <- rownames(coord.col.sup)
		} else  labe2 <- rep("",nrow(coord.col.sup))
		coll2 <- col[1:nrow(coord.col.sup)]
		ipch <- c(ipch,rep(17,nrow(coord.col.sup)))
		fonte <- c(fonte,rep(1,nrow(coord.col.sup)))
	    if (!is.null(selectionCS)){
	      if (is.numeric(unselect)) coll2[!((1:length(coll2))%in%selectionCS)] = rgb(t(col2rgb(coll2[!((1:length(coll2))%in%selectionCS)])),alpha=255*(1-unselect),maxColorValue=255)
	      else coll2[!((1:length(coll2))%in%selectionCS)] = unselect
		  labe2[!((1:length(coll2))%in%selectionCS)] <- ""
	    }
      }
      if (!is.null(res.mfa$ind.sup) & is.na(test.invisible[3])) {
		coo <- rbind(coo,coord.row.sup)
		if (lab.ind){ labe2 <- rownames(coord.row.sup)
		} else  labe2 <- rep("",nrow(coord.row.sup))
		coll2 <- rep(col.row.sup,nrow(coord.row.sup))
		ipch <- c(ipch,rep(17,nrow(coord.row.sup)))
		fonte <- c(fonte,rep(1,nrow(coord.row.sup)))
	    if (!is.null(selectionS)){
	      if (is.numeric(unselect)) coll2[!((1:length(coll2))%in%selectionS)] = rgb(t(col2rgb(coll2[!((1:length(coll2))%in%selectionS)])),alpha=255*(1-unselect),maxColorValue=255)
	      else coll2[!((1:length(coll2))%in%selectionS)] = unselect
		  labe2[!((1:length(coll2))%in%selectionS)] <- ""
	    }
		if (length(select)==1){
		  if (grepl("contrib",select)){
		  if (is.numeric(unselect)) coll2[1:length(coll2)] = rgb(t(col2rgb(coll2[1:length(coll2)])),alpha=255*(1-unselect),maxColorValue=255) 
		  else coll2[1:length(coll2)] = unselect
		  labe2[1:length(coll2)] <- ""
    	}}
      }
	  if (shadowtext) points(coo[, 1], y = coo[, 2], pch = ipch, col = coll, ...)
      if (any(labe!="")){
	    if (autoLab=="auto") autoLab = (length(which(labe!=""))<50)
        if (autoLab ==TRUE) autoLab(coo[labe!="", 1], y = coo[labe!="", 2], labels = labe[labe!=""], col = coll[labe!=""],  font=fonte[labe!=""],shadotext=shadowtext,...)
        if (autoLab ==FALSE) text(coo[labe!="", 1], y = coo[labe!="", 2], labels = labe[labe!=""], col = coll[labe!=""],  font=fonte[labe!=""],pos=3,...)
	  }
	  if (!shadowtext) points(coo[, 1], y = coo[, 2], pch = ipch, col = coll, ...)
      if (habillage == "group") legend("topleft", legend = rownames(res.mfa$group$Lg[-nrow(res.mfa$group$Lg), ])[type == "f"], text.col = col.hab, cex = 0.8*par("cex"))
	}

    if (choix == "ind") {
        test.invisible <- vector(length = 3)
        if (!is.null(invisible)) {
            test.invisible[1] <- match("ind", invisible)
            test.invisible[2] <- match("ind.sup", invisible)
            test.invisible[3] <- match("quali", invisible)
        }
        else test.invisible <- rep(NA, 3)
        nb.ind.actif <- nrow(res.mfa$ind$coord)
        nb.ind.illu <- 0
        if (!is.null(res.mfa$ind.sup)) nb.ind.illu <- nrow(res.mfa$ind.sup$coord)
        nb.ind <- nb.ind.actif + nb.ind.illu
        coord.ind <- res.mfa$ind$coord[, axes, drop = FALSE]
        coord.ind.partiel <- res.mfa$ind$coord.partiel[, axes, drop = FALSE]
        coord.ind.sup <- NULL
        if (!is.null(res.mfa$ind.sup)) {
            coord.ind.sup <- res.mfa$ind.sup$coord[, axes, drop = FALSE]
            coord.ind.partiel.sup <- res.mfa$ind.sup$coord.partiel[, axes, drop = FALSE]
        }
        coord.quali <- coord.quali.sup <- coord.quali.partiel <- coord.quali.sup.partiel <- NULL
        nrow.coord.quali <- 0
        if (!is.null(res.mfa["quali.var"]$quali.var)) {
            coord.quali <- res.mfa$quali.var$coord[, axes, drop = FALSE]
            coord.quali.partiel <- res.mfa$quali.var$coord.partiel[, axes, drop = FALSE]
            nrow.coord.quali <- nrow(coord.quali)
        }
        if (!is.null(res.mfa["quali.var.sup"])) {
            coord.quali.sup <- res.mfa$quali.var.sup$coord[, axes, drop = FALSE]
            coord.quali.partiel.sup <- res.mfa$quali.var.sup$coord.partiel[, axes, drop = FALSE]
        }
        group.ind.actif <- group.ind.sup <- group.quali <- group.quali.sup <- NULL
        if (!is.null(partial)) {
            if (length(partial) == 1) {
                if (partial == "all") {
                  group.ind.actif <- 1:nrow(coord.ind)
                  if (!is.null(res.mfa$ind.sup)) 
                    group.ind.sup <- 1:nrow(coord.ind.sup)
                  if (!is.null(res.mfa["quali.var"]$quali.var)) 
                    group.quali <- 1:nrow(coord.quali)
                  if (!is.null(res.mfa["quali.var.sup"]$quali.var.sup)) 
                    group.quali.sup <- 1:nrow(coord.quali.sup)
                }
                else {
                  for (i in 1:length(partial)) {
                    if (partial[i] %in% rownames(coord.ind)) 
                      group.ind.actif <- c(group.ind.actif, match(partial[i], 
                        rownames(coord.ind)))
                    if (partial[i] %in% rownames(coord.ind.sup)) 
                      group.ind.sup <- c(group.ind.sup, match(partial[i], 
                        rownames(coord.ind.sup)))
                    if (partial[i] %in% rownames(coord.quali)) 
                      group.quali <- c(group.quali, match(partial[i], 
                        rownames(coord.quali)))
                    if (partial[i] %in% rownames(coord.quali.sup)) 
                      group.quali.sup <- c(group.quali.sup, match(partial[i], 
                        rownames(coord.quali.sup)))
                  }
                }
            }
            else {
                for (i in 1:length(partial)) {
                  if (partial[i] %in% rownames(coord.ind)) 
                    group.ind.actif <- c(group.ind.actif, match(partial[i], 
                      rownames(coord.ind)))
                  if (partial[i] %in% rownames(coord.ind.sup)) 
                    group.ind.sup <- c(group.ind.sup, match(partial[i], 
                      rownames(coord.ind.sup)))
                  if (partial[i] %in% rownames(coord.quali)) 
                    group.quali <- c(group.quali, match(partial[i], 
                      rownames(coord.quali)))
                  if (partial[i] %in% rownames(coord.quali.sup)) 
                    group.quali.sup <- c(group.quali.sup, match(partial[i], 
                      rownames(coord.quali.sup)))
                }
            }
        }
        if (!is.null(ellipse)) {
            coord.ellipse <- ellipse$res
            npoint.ellipse <- ellipse$call
        }
        else coord.ellipse <- NULL
        if (!is.null(ellipse.par)) {
            coord.ellipse.par <- ellipse.par$res
            npoint.ellipse.par <- ellipse.par$call
        }
        else coord.ellipse.par <- NULL
        if (is.null(xlim)) {
            xmin <- xmax <- 0
            if (is.na(test.invisible[1]))  xmin <- min(xmin, coord.ind[, 1])
            if (is.na(test.invisible[1]))  xmax <- max(xmax, coord.ind[, 1])
            if (!is.null(res.mfa$ind.sup) & is.na(test.invisible[2])) xmin <- min(xmin, coord.ind.sup[, 1])
            if (!is.null(res.mfa$ind.sup) & is.na(test.invisible[2])) xmax <- max(xmax, coord.ind.sup[, 1])
            if (is.na(test.invisible[1])) xmin <- min(xmin, coord.ind.partiel[unlist(lapply(group.ind.actif, 
                  function(k) seq(nbre.grpe * (k - 1) + 1, length = nbre.grpe))), 1])
            if (is.na(test.invisible[1])) xmax <- max(xmax, coord.ind.partiel[unlist(lapply(group.ind.actif, 
                  function(k) seq(nbre.grpe * (k - 1) + 1, length = nbre.grpe))), 1])
            if (!is.null(res.mfa$ind.sup) & is.na(test.invisible[2])) xmin <- min(xmin, coord.ind.partiel.sup[unlist(lapply(group.ind.sup, 
                  function(k) seq(nbre.grpe * (k - 1) + 1, length = nbre.grpe))), 1])
            if (!is.null(res.mfa$ind.sup) & is.na(test.invisible[2])) 
                xmax <- max(xmax, coord.ind.partiel.sup[unlist(lapply(group.ind.sup, function(k) seq(nbre.grpe * (k - 1) + 1, length = nbre.grpe))), 
                  1])
            if (!is.null(res.mfa["quali.var"]$quali.var) & is.na(test.invisible[3])) 
                xmin <- min(xmin, coord.quali[, 1])
            if (!is.null(res.mfa["quali.var"]$quali.var) & is.na(test.invisible[3])) 
                xmax <- max(xmax, coord.quali[, 1])
            if (!is.null(res.mfa["quali.var"]$quali.var) & is.na(test.invisible[3])) 
                xmin <- min(xmin, coord.quali.partiel[unlist(lapply(group.quali, 
                  function(k) seq(nbre.grpe * (k - 1) + 1, length = nbre.grpe))), 
                  1])
            if (!is.null(res.mfa["quali.var"]$quali.var) & is.na(test.invisible[3])) 
                xmax <- max(xmax, coord.quali.partiel[unlist(lapply(group.quali, 
                  function(k) seq(nbre.grpe * (k - 1) + 1, length = nbre.grpe))), 
                  1])
            if (!is.null(res.mfa$quali.var.sup) & is.na(test.invisible[3])) 
                xmin <- min(xmin, coord.quali[, 1], coord.quali.sup[, 
                  1])
            if (!is.null(res.mfa$quali.var.sup) & is.na(test.invisible[3])) 
                xmax <- max(xmax, coord.quali[, 1], coord.quali.sup[, 
                  1])
            if (!is.null(res.mfa$quali.var.sup) & is.na(test.invisible[3])) 
                xmin <- min(xmin, coord.quali.partiel.sup[unlist(lapply(group.quali.sup, 
                  function(k) seq(nbre.grpe * (k - 1) + 1, length = nbre.grpe))), 
                  1])
            if (!is.null(res.mfa$quali.var.sup) & is.na(test.invisible[3])) 
                xmax <- max(xmax, coord.quali.partiel.sup[unlist(lapply(group.quali.sup, 
                  function(k) seq(nbre.grpe * (k - 1) + 1, length = nbre.grpe))), 
                  1])
            xlim <- c(xmin, xmax) * 1.1
        }
        else {
            xmin = xlim[1]
            xmax = xlim[2]
        }
        if (is.null(ylim)) {
            ymin <- ymax <- 0
            if (is.na(test.invisible[1])) 
                ymin <- min(ymin, coord.ind[, 2])
            if (is.na(test.invisible[1])) 
                ymax <- max(ymax, coord.ind[, 2])
            if (!is.null(res.mfa$ind.sup) & is.na(test.invisible[2])) 
                ymin <- min(ymin, coord.ind.sup[, 2])
            if (!is.null(res.mfa$ind.sup) & is.na(test.invisible[2])) 
                ymax <- max(ymax, coord.ind.sup[, 2])
            if (is.na(test.invisible[1])) 
                ymin <- min(ymin, coord.ind.partiel[unlist(lapply(group.ind.actif, 
                  function(k) seq(nbre.grpe * (k - 1) + 1, length = nbre.grpe))), 
                  2])
            if (is.na(test.invisible[1])) 
                ymax <- max(ymax, coord.ind.partiel[unlist(lapply(group.ind.actif, 
                  function(k) seq(nbre.grpe * (k - 1) + 1, length = nbre.grpe))), 
                  2])
            if (!is.null(res.mfa$ind.sup) & is.na(test.invisible[2])) 
                ymin <- min(ymin, coord.ind.partiel.sup[unlist(lapply(group.ind.sup, 
                  function(k) seq(nbre.grpe * (k - 1) + 1, length = nbre.grpe))), 
                  2])
            if (!is.null(res.mfa$ind.sup) & is.na(test.invisible[2])) 
                ymax <- max(ymax, coord.ind.partiel.sup[unlist(lapply(group.ind.sup, 
                  function(k) seq(nbre.grpe * (k - 1) + 1, length = nbre.grpe))), 
                  2])
            if (!is.null(res.mfa["quali.var"]$quali.var) & is.na(test.invisible[3])) 
                ymin <- min(ymin, coord.quali[, 2])
            if (!is.null(res.mfa["quali.var"]$quali.var) & is.na(test.invisible[3])) 
                ymax <- max(ymax, coord.quali[, 2])
            if (!is.null(res.mfa["quali.var"]$quali.var) & is.na(test.invisible[3])) 
                ymin <- min(ymin, coord.quali.partiel[unlist(lapply(group.quali, 
                  function(k) seq(nbre.grpe * (k - 1) + 1, length = nbre.grpe))), 
                  2])
            if (!is.null(res.mfa["quali.var"]$quali.var) & is.na(test.invisible[3])) 
                ymax <- max(ymax, coord.quali.partiel[unlist(lapply(group.quali, 
                  function(k) seq(nbre.grpe * (k - 1) + 1, length = nbre.grpe))), 
                  2])
            if (!is.null(res.mfa$quali.var.sup) & is.na(test.invisible[3])) 
                ymin <- min(ymin, coord.quali[, 1], coord.quali.sup[, 
                  2])
            if (!is.null(res.mfa$quali.var.sup) & is.na(test.invisible[3])) 
                ymax <- max(ymax, coord.quali[, 1], coord.quali.sup[, 
                  2])
            if (!is.null(res.mfa$quali.var.sup) & is.na(test.invisible[3])) 
                ymin <- min(ymin, coord.quali.partiel.sup[unlist(lapply(group.quali.sup, 
                  function(k) seq(nbre.grpe * (k - 1) + 1, length = nbre.grpe))), 
                  2])
            if (!is.null(res.mfa$quali.var.sup) & is.na(test.invisible[3])) 
                ymax <- max(ymax, coord.quali.partiel.sup[unlist(lapply(group.quali.sup, 
                  function(k) seq(nbre.grpe * (k - 1) + 1, length = nbre.grpe))), 
                  2])
            ylim <- c(ymin, ymax) * 1.1
        }
        else {
            ymin = ylim[1]
            ymax = ylim[2]
        }

        selection <- NULL
		if (!is.null(select)) {
		  if (mode(select)=="numeric") selection <- select
		  else {
		    if (sum(rownames(res.mfa$ind$coord)%in%select)!=0) selection <- which(rownames(res.mfa$ind$coord)%in%select)
			else {
 		    if (grepl("contrib",select)) selection <- (rev(order(res.mfa$ind$contrib[,axes[1],drop=FALSE]*res.mfa$eig[axes[1],1]+res.mfa$ind$contrib[,axes[2],drop=FALSE]*res.mfa$eig[axes[2],1])))[1:min(nrow(res.mfa$ind$coord),sum(as.integer(unlist(strsplit(select,"contrib"))),na.rm=T))]
# 		    if (grepl("contrib",select)) selection <- (rev(order(apply(res.mfa$ind$contrib[,axes],1,sum))))[1:min(nrow(res.mfa$ind$coord),sum(as.integer(unlist(strsplit(select,"contrib"))),na.rm=T))]
 		    if (grepl("dist",select)) selection <- (rev(order(res.mfa$ind$dist)))[1:min(nrow(res.mfa$ind$coord),sum(as.integer(unlist(strsplit(select,"dist"))),na.rm=T))]
 		    if (grepl("coord",select)) selection <- (rev(order(apply(res.mfa$ind$coord[,axes]^2,1,sum))))[1:min(nrow(res.mfa$ind$coord),sum(as.integer(unlist(strsplit(select,"coord"))),na.rm=T))]
 		    if (grepl("cos2",select)) {
		      if (sum(as.numeric(unlist(strsplit(select,"cos2"))),na.rm=T)>=1) selection <- (rev(order(apply(res.mfa$ind$cos2[,axes],1,sum))))[1:min(nrow(res.mfa$ind$coord),sum(as.numeric(unlist(strsplit(select,"cos2"))),na.rm=T))]
		      else selection <- which(apply(res.mfa$ind$cos2[,axes],1,sum)>sum(as.numeric(unlist(strsplit(select,"cos2"))),na.rm=T))
		    }
			if (is.integer(select)) selection <- select
			}  
		  }
		}

        if (habillage == "group") {
            if (is.null(col.hab) | length(col.hab) != (nbre.grpe)) 
                col.hab <- 2:(nbre.grpe + 1)
            col.ind <- c(rep(1, nb.ind.actif), rep(col.hab, nb.ind.actif))
            if (!is.null(res.mfa$ind.sup)) 
                col.ind.sup <- c(rep(1, nb.ind - nb.ind.actif), 
                  rep(col.hab, nb.ind - nb.ind.actif))
            if (length(group[type == "n"]) != 0) 
                col.quali <- c(rep(1, sum(res.mfa$call$group.mod[type == 
                  "n"])), rep(col.hab, sum(res.mfa$call$group.mod[type == 
                  "n"])))
            if (!is.null(res.mfa$quali.var.sup)) 
                col.quali.sup <- c(rep(1, sum(res.mfa$call$group.mod[num.group.sup][type.sup == 
                  "n"])), rep(col.hab, sum(res.mfa$call$group.mod[num.group.sup][type.sup == 
                  "n"])))
            if (!is.null(ellipse)) 
                col.ellipse <- rep(1, nb.ind.actif)
            if (!is.null(ellipse.par)) 
                col.ellipse.par <- rep(col.hab, nb.ind.actif)
        }
        if (habillage == "ind") {
            if (is.null(col.hab) | length(col.hab) != nb.ind) {
                col.hab <- 1:nb.ind
            }
            col.ind <- c(col.hab[1:nb.ind.actif], rep(col.hab[1:nb.ind.actif], 
                each = nbre.grpe))
            if (!is.null(res.mfa$ind.sup)) 
                col.ind.sup <- c(col.hab[(nb.ind.actif + 1):nb.ind], 
                  rep(col.hab[(nb.ind.actif + 1):nb.ind], each = nbre.grpe))
            if (length(group[type == "n"]) != 0) 
                col.quali <- col.quali.sup <- rep("black", (1 + 
                  nbre.grpe) * sum(res.mfa$call$group.mod[type == 
                  "n"]))
            if (!is.null(ellipse)) 
                col.ellipse <- col.hab[1:nb.ind.actif]
            if (!is.null(ellipse.par)) 
                col.ellipse.par <- rep(col.hab[1:nb.ind.actif], 
                  each = nbre.grpe)
        }
        if ((habillage != "none") & (habillage != "ind") & (habillage != "group")) {
			group.act <- (1:length(group))
            if (!is.null(num.group.sup))  group.act <- group.act[-num.group.sup]
            nbre.modalite <- NULL
            liste.quali <- NULL
            for (i in group.act) {
                if (type[i] == "n") {
                  for (k in 1:ncol(res.mfa$separate.analyses[[i]]$call$X)) nbre.modalite <- c(nbre.modalite, 
                    nlevels(res.mfa$separate.analyses[[i]]$call$X[, 
                      k]))
                  if (i == 1) 
                    liste.quali <- c(liste.quali, colnames(res.mfa$call$X[1:group[1]]))
                  else liste.quali <- c(liste.quali, colnames(res.mfa$call$X[(sum(group[1:(i - 
                    1)]) + 1):sum(group[1:i])]))
                }
            }
            if (!is.null(num.group.sup)) {
                for (i in num.group.sup) {
                  if (type[i] == "n") {
                    if (i == 1) 
                      liste.quali <- c(liste.quali, colnames(res.mfa$call$X[1:group[1]]))
                    else liste.quali <- c(liste.quali, colnames(res.mfa$call$X[(sum(group[1:(i - 
                      1)]) + 1):sum(group[1:i])]))
                    for (k in 1:ncol(res.mfa$separate.analyses[[i]]$call$X)) nbre.modalite <- c(nbre.modalite, 
                      nlevels(res.mfa$separate.analyses[[i]]$call$X[, 
                        k]))
                  }
                }
            }
            if (is.double(habillage)) nom.quali <- colnames(res.mfa$call$X)[habillage]
            else nom.quali = habillage
            if (!(nom.quali %in% liste.quali)) stop("The variable ", habillage, " is not qualitative")
            modalite <- levels(as.factor(res.mfa$call$X[, nom.quali]))
            col.ind <- as.numeric(as.factor(res.mfa$call$X[, nom.quali]))
            if (is.null(col.hab) | length(col.hab) != length(modalite))  col.hab <- 2:(1 + length(modalite))
            col.ind <- col.hab[col.ind]
            if (!is.null(res.mfa$call$ind.sup)) {
                col.ind.sup <- col.ind[res.mfa$call$ind.sup]
                col.ind <- col.ind[-res.mfa$call$ind.sup]
                col.ind.sup <- c(col.ind.sup, rep(col.ind.sup, each = nbre.grpe))
            }
            col.ind <- c(col.ind, rep(col.ind, each = nbre.grpe))
            col.ellipse <- col.ind[1:nb.ind.actif]
            col.ellipse.par <- col.ind[-c(1:nb.ind.actif)]
            indice.inf <- sum(nbre.modalite[0:(match(nom.quali, liste.quali) - 1)]) + 1
            indice.sup <- indice.inf + length(modalite) - 1
            col.quali <- rep("black", sum(res.mfa$call$group.mod[type == "n"]))
            if (length(group[type == "n"]) != 0) {
                for (i in 1:length(liste.quali)) {
                  if (liste.quali[i] == nom.quali) col.quali[indice.inf:indice.sup] <- col.hab
                }
            }
            col.quali <- c(col.quali, rep(col.quali, each = nbre.grpe))
            col.quali.sup <- col.quali
        }
        if (habillage == "none") 
            col.ind <- col.ind.sup <- col.quali.sup <- col.quali <- col.ellipse <- col.ellipse.par <- rep("black", 
                nb.ind * (nbre.grpe + 1))
        if ((new.plot)&!nzchar(Sys.getenv("RSTUDIO_USER_IDENTITY")))  dev.new(width = min(14, max(8, 8 * (xmax - xmin)/(ymax - ymin))), height = 8)
        if (is.null(palette)) palette(c("black", "red", "green3", "blue", "cyan", "magenta","darkgray", "darkgoldenrod", "darkgreen", "violet","turquoise", "orange", "lightpink", "lavender", "yellow","lightgreen", "lightgrey", "lightblue", "darkkhaki","darkmagenta", "darkolivegreen", "lightcyan", "darkorange","darkorchid", "darkred", "darksalmon", "darkseagreen","darkslateblue", "darkslategray", "darkslategrey","darkturquoise", "darkviolet", "lightgray", "lightsalmon","lightyellow", "maroon"))
        if (is.null(title))  title <- "Individual factor map"
        plot(0, 0, main = title, xlab = lab.x, ylab = lab.y, xlim = xlim, ylim = ylim, col = "white", asp = 1, ...)
        abline(v = 0, lty = 2, ...)
        abline(h = 0, lty = 2, ...)
    	coo <- labe <- coll <- ipch <- fonte <- NULL
        if (is.na(test.invisible[1])) {
		    coo <- rbind(coo,coord.ind)
		    if (lab.ind){ labe <- c(labe,rownames(coord.ind))
		    } else  labe <- c(labe,rep("",nrow(coord.ind)))
		    coll <- c(coll,col.ind[1:nb.ind.actif])
		    ipch <- c(ipch,rep(20,nrow(coord.ind)))
		    fonte <- c(fonte,rep(1,nrow(coord.ind)))
		    if (!is.null(selection)){
			  if (is.numeric(unselect)) coll[!((1:length(coll))%in%selection)] = rgb(t(col2rgb(coll[!((1:length(coll))%in%selection)])),alpha=255*(1-unselect),maxColorValue=255)
			  else coll[!((1:length(coll))%in%selection)] = unselect
			  labe[!((1:length(coll))%in%selection)] <- ""
			}
            for (i in group.ind.actif) {
			  if (col2rgb(coll[i],alpha=TRUE)[4]== 255){
                for (j in 1:nbre.grpe) {
                  points(coord.ind.partiel[(i - 1) * nbre.grpe + j, ], cex = 0.8 * par("cex"), col = col.ind[nb.ind.actif + (i - 1) * nbre.grpe + j], pch = 20)
                  if (lab.par) text(coord.ind.partiel[(i - 1) * nbre.grpe + j, 1], y = coord.ind.partiel[(i - 1) * 
                      nbre.grpe + j, 2], labels = rownames(coord.ind.partiel)[(i - 
                      1) * nbre.grpe + j], pos = 3, col = col.ind[nb.ind.actif + 
                      (i - 1) * nbre.grpe + j],...)
                  if (chrono) {
                    if (j > 1) 
                      lines(c(coord.ind.partiel[(i - 1) * nbre.grpe + 
                        (j - 1), 1], coord.ind.partiel[(i - 1) * 
                        nbre.grpe + j, 1]), c(coord.ind.partiel[(i - 
                        1) * nbre.grpe + (j - 1), 2], coord.ind.partiel[(i - 
                        1) * nbre.grpe + j, 2]), col = col.ind[i],...)
                  }
                  else lines(c(coord.ind[i, 1], coord.ind.partiel[(i - 
                    1) * nbre.grpe + j, 1]), c(coord.ind[i, 2], 
                    coord.ind.partiel[(i - 1) * nbre.grpe + j, 
                      2]), col = col.ind[nb.ind.actif + (i - 
                    1) * nbre.grpe + j], lty = j,...)
                }
			  }
            }
        }
        if (!is.null(res.mfa$ind.sup) & is.na(test.invisible[2])) {
		    coo <- rbind(coo,coord.ind.sup)
		    if (lab.ind){ labe <- c(labe,rownames(coord.ind.sup))
		    } else  labe <- c(labe,rep("",nrow(coord.ind.sup)))
		    coll <- c(coll,col.ind.sup[1:(nb.ind - nb.ind.actif)])
		    ipch <- c(ipch,rep(21,nrow(coord.ind.sup)))
		    fonte <- c(fonte,rep(3,nrow(coord.ind.sup)))
            for (i in group.ind.sup) {
                for (j in 1:nbre.grpe) {
                  points(coord.ind.partiel.sup[(i - 1) * nbre.grpe + 
                    j, ], cex = 0.8 * par("cex"), col = col.ind.sup[nb.ind - 
                    nb.ind.actif + (i - 1) * nbre.grpe + j], 
                    pch = 21)
                  if (lab.par) 
                    text(coord.ind.partiel.sup[(i - 1) * nbre.grpe + 
                      j, 1], y = coord.ind.partiel.sup[nb.ind + 
                      (i - 1) * nbre.grpe + j, 2], labels = rownames(coord.ind.partiel.sup)[(i - 
                      1) * nbre.grpe + j], pos = 3, col = col.ind.sup[nb.ind - 
                      nb.ind.actif + (i - 1) * nbre.grpe + j],cex=par("cex")*0.8)
                  if (chrono) {
                    if (j > 1) 
                      lines(c(coord.ind.partiel.sup[(i - 1) * 
                        nbre.grpe + (j - 1), 1], coord.ind.partiel.sup[(i - 
                        1) * nbre.grpe + j, 1]), c(coord.ind.partiel.sup[(i - 
                        1) * nbre.grpe + (j - 1), 2], coord.ind.partiel.sup[(i - 
                        1) * nbre.grpe + j, 2]), col = col.ind[nb.ind.actif + 
                        i])
                  }
                  else lines(c(coord.ind.sup[i, 1], coord.ind.partiel.sup[(i - 
                    1) * nbre.grpe + j, 1]), c(coord.ind.sup[i, 
                    2], coord.ind.partiel.sup[(i - 1) * nbre.grpe + 
                    j, 2]), col = col.ind.sup[nb.ind - nb.ind.actif + 
                    (i - 1) * nbre.grpe + j], lty = j)
                }
            }
        }
        if (!is.null(coord.quali) & is.na(test.invisible[3])) {
		    coo <- rbind(coo,coord.quali)
		    if (lab.var){ labe <- c(labe,rownames(coord.quali))
		    } else  labe <- c(labe,rep("",nrow(coord.quali)))
		    coll <- c(coll,col.quali[1:nrow.coord.quali])
		    ipch <- c(ipch,rep(15,nrow(coord.quali)))
		    fonte <- c(fonte,rep(2,nrow(coord.quali)))
            for (i in group.quali) {
                for (j in 1:nbre.grpe) {
                  points(coord.quali.partiel[(i - 1) * nbre.grpe +  j, ], pch = 15, col = col.quali[nrow.coord.quali + (i - 1) * nbre.grpe + j], cex = par("cex") * 0.8)
                  if (lab.var & lab.par) 
                    text(coord.quali.partiel[(i - 1) * nbre.grpe + j, 1], y = coord.quali.partiel[(i - 1) * 
                      nbre.grpe + j, 2], labels = rownames(coord.quali.partiel)[(i - 
                      1) * nbre.grpe + j], pos = 3, col = col.quali[nrow.coord.quali + (i - 1) * nbre.grpe + j],...)
                  if (chrono) {
                    if (j > 1) 
                      lines(c(coord.quali.partiel[(i - 1) * nbre.grpe + 
                        (j - 1), 1], coord.quali.partiel[(i - 
                        1) * nbre.grpe + j, 1]), c(coord.quali.partiel[(i - 
                        1) * nbre.grpe + (j - 1), 2], coord.quali.partiel[(i - 
                        1) * nbre.grpe + j, 2]), col = col.quali[i])
                  }
                  else lines(c(coord.quali[i, 1], coord.quali.partiel[(i - 
                    1) * nbre.grpe + j, 1]), c(coord.quali[i, 
                    2], coord.quali.partiel[(i - 1) * nbre.grpe + 
                    j, 2]), col = col.quali[nrow.coord.quali + 
                    (i - 1) * nbre.grpe + j], lty = j)
                }
            }
        }
        if (!is.null(coord.quali.sup) & is.na(test.invisible[3])) {
		    coo <- rbind(coo,coord.quali.sup)
		    if (lab.var){ labe <- c(labe,rownames(coord.quali.sup))
		    } else  labe <- c(labe,rep("",nrow(coord.quali.sup)))
		    coll <- c(coll,col.quali.sup[1:nrow(coord.quali.sup)])
		    ipch <- c(ipch,rep(22,nrow(coord.quali.sup)))
		    fonte <- c(fonte,rep(4,nrow(coord.quali.sup)))
            for (i in group.quali.sup) {
                for (j in 1:nbre.grpe) {
                  points(coord.quali.partiel.sup[(i - 1) * nbre.grpe + 
                    j, ], pch = 22, col = col.quali.sup[nrow(coord.quali.sup) + 
                    (i - 1) * nbre.grpe + j], cex = par("cex") * 0.8)
                  if (lab.var & lab.par) 
                    text(coord.quali.partiel.sup[(i - 1) * nbre.grpe + 
                      j, 1], y = coord.quali.partiel.sup[(i - 
                      1) * nbre.grpe + j, 2], labels = rownames(coord.quali.partiel.sup)[(i - 
                      1) * nbre.grpe + j], pos = 3, col = col.quali.sup[nrow(coord.quali.sup) + 
                      (i - 1) * nbre.grpe + j],...)
                  if (chrono) {
                    if (j > 1) 
                      lines(c(coord.quali.partiel.sup[(i - 1) * 
                        nbre.grpe + (j - 1), 1], coord.quali.partiel.sup[(i - 
                        1) * nbre.grpe + j, 1]), c(coord.quali.partiel.sup[(i - 
                        1) * nbre.grpe + (j - 1), 2], coord.quali.partiel.sup[(i - 
                        1) * nbre.grpe + j, 2]), col = col.quali[nrow.coord.quali + 
                        i])
                  }
                  else lines(c(coord.quali.sup[i, 1], coord.quali.partiel.sup[(i - 
                    1) * nbre.grpe + j, 1]), c(coord.quali.sup[i, 
                    2], coord.quali.partiel.sup[(i - 1) * nbre.grpe + 
                    j, 2]), col = col.quali.sup[nrow(coord.quali.sup) + 
                    (i - 1) * nbre.grpe + j], lty = j)
                }
            }
        }
	    if (shadowtext) points(coo[, 1], y = coo[, 2], pch = ipch, col = coll, ...)
        if (any(labe!="")){
	      if (autoLab=="auto") autoLab = (length(which(labe!=""))<50)
          if (autoLab ==TRUE) autoLab(coo[labe!="", 1], y = coo[labe!="", 2], labels = labe[labe!=""], col = coll[labe!=""],  font=fonte[labe!=""],shadotext=shadowtext,...)
          if (autoLab ==FALSE) text(coo[labe!="", 1], y = coo[labe!="", 2], labels = labe[labe!=""], col = coll[labe!=""],  font=fonte[labe!=""],pos=3,...)		
		}
	    if (!shadowtext) points(coo[, 1], y = coo[, 2], pch = ipch, col = coll, ...)
        if ((!is.null(partial)) & (habillage == "group")) 
            legend("topleft", legend = rownames(res.mfa$group$Lg)[-c(num.group.sup, 
                length(rownames(res.mfa$group$Lg)))], lty = 1:length(rownames(res.mfa$group$Lg)[-c(num.group.sup, 
                length(rownames(res.mfa$group$Lg)))]), text.col = col.hab, 
                col = col.hab, cex = par("cex")*0.8)
        if ((!is.null(partial)) & (habillage != "group")) 
            legend("topleft", legend = rownames(res.mfa$group$Lg)[-c(num.group.sup, 
                length(rownames(res.mfa$group$Lg)))], lty = 1:length(rownames(res.mfa$group$Lg)[-c(num.group.sup, 
                length(rownames(res.mfa$group$Lg)))]), cex = par("cex")*0.8)
        if ((habillage != "none") & (habillage != "ind") & (habillage != 
            "group")) 
            legend("topleft", legend = levels(res.mfa$call$X[, 
                habillage]), text.col = col.hab, cex = par("cex")*0.8)
        if (!is.null(coord.ellipse) & is.na(test.invisible[2])) {
            for (e in 1:nb.ind.actif) {
                debut <- ((nb.ind.actif - 1) * npoint.ellipse) + 1
                fin <- debut + npoint.ellipse - 1
                data.elli <- coord.ellipse[debut:fin, -1]
                lines(data.elli[, 1], y = data.elli[, 2], col = col.ellipse[e])
            }
        }
        if (!is.null(coord.ellipse)) {
            for (e in 1:nlevels(coord.ellipse[, 1])) {
                data.elli <- coord.ellipse[(npoint.ellipse * 
                  (e - 1) + 1):(npoint.ellipse * e), -1]
                lines(data.elli[, 1], y = data.elli[, 2], col = col.ellipse[e])
            }
        }
        if (!is.null(coord.ellipse.par)) {
            for (i in group.ind.actif) {
                for (j in 1:nbre.grpe) {
                  ind.e <- (i - 1) * nbre.grpe + j
                  data.elli <- coord.ellipse.par[(npoint.ellipse.par * 
                    (ind.e - 1) + 1):(npoint.ellipse.par * ind.e), -1]
                  lines(data.elli[, 1], y = data.elli[, 2], col = col.ellipse.par[ind.e], 
                    lty = 2)
                }
            }
        }
    }
}