% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBarH.R
\name{plotBarH}
\alias{plotBarH}
\title{Horizontal bar graph}
\usage{
plotBarH(
  .data,
  xvar = "",
  xlabel = "",
  yvar = "",
  ylabel = "",
  fill_color = EcdcColors(col_scale = "qual", n = 1),
  log10_scale = FALSE,
  xlabel_black = ""
)
}
\arguments{
\item{.data}{dataframe containing the variables to plot}

\item{xvar}{character string, name of the categorical variable to plot on the x-axis in quotes}

\item{xlabel}{character string, label of the x axis}

\item{yvar}{character string, name of the numerical variable to plot on the y-axis in quotes}

\item{ylabel}{character string, label of the y axis}

\item{fill_color}{character string, hexadecimal colour to use in the graph;
(default to ECDC green \code{"#65B32E"}, see \code{EcdcColors(col_scale = "qual", n = 1))}}

\item{log10_scale}{boolean, TRUE if y-axis should be log scale
(default \code{FALSE} ,see \code{ggplot2::scale_y_log10})}

\item{xlabel_black}{(optional) character string, value of the categorical variable
for which the bar should be black}
}
\description{
This function draws an horizontal bar graph of the values of variable 'Yvar'
with the categorical variable 'Xvar' on the x-axis. \cr
Expects aggregated data.
}
\examples{
# --- Create dummy data
mfratio <- data.frame( Country = sample(EpiReport::MSCode$Country, 28),
                       Ratio = runif(28, min = 0, max = 28))

# --- Plot the dummy data
plotBarH(mfratio,
         xvar = "Country",
         xlabel = "",
         yvar = "Ratio",
         ylabel = "Male-to-Female ratio",
         log10_scale = FALSE)
plotBarH(mfratio,
         xvar = "Country",
         xlabel = "",
         yvar = "Ratio",
         ylabel = "Male-to-Female ratio",
         log10_scale = TRUE,
         xlabel_black = "EU-EEA")

}
\seealso{
Internal function: \code{\link{EcdcColors}} \cr
Required Packages: \code{\link{ggplot2}}
}
\keyword{bargraph}
