% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{set_doFuture_strategy}
\alias{set_doFuture_strategy}
\title{Set a doFuture execution strategy}
\usage{
set_doFuture_strategy(
  strategy = c("sequential", "multisession", "multicore", "mixed"),
  n_workers = NULL
)
}
\arguments{
\item{strategy}{One of \code{"sequential"} (default), \code{"multisession"}, \code{"multicore"}, or \code{"mixed"}.}

\item{n_workers}{A positive numeric scalar or a function specifying the maximum number of parallel futures
that can be active at the same time before blocking.
If a function, it is called without arguments when the future is created and its value is used to configure the workers.
The function should return a numeric scalar.
Defaults to \code{\link[future:re-exports]{future::availableCores()}}\code{-1} if \code{NULL} (default), with \code{"multicore"} constraint in the relevant case.
Ignored if \code{strategy=="sequential"}.}
}
\value{
The appropriate \code{\link[=get_doFuture_operator]{get_doFuture_operator()}} operator to use in a \code{\link[foreach:foreach]{foreach::foreach()}} loop.
The \code{\link[foreach]{\%do\%}} operator is returned if \code{strategy=="sequential"}.
Otherwise, the \code{\link[foreach]{\%dopar\%}} operator is returned.
}
\description{
Set a doFuture execution strategy
}
\examples{
\donttest{
`\%fun\%` <- set_doFuture_strategy("multisession", n_workers=3)
# perform foreach::foreach loop using the \%fun\% operator
end_doFuture_strategy()
}
}
