% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EQRN.R
\name{EQRN_predict}
\alias{EQRN_predict}
\title{Predict function for an EQRN_iid fitted object}
\usage{
EQRN_predict(
  fit_eqrn,
  X,
  prob_lvls_predict,
  intermediate_quantiles,
  interm_lvl = fit_eqrn$interm_lvl,
  device = default_device()
)
}
\arguments{
\item{fit_eqrn}{Fitted \code{"EQRN_iid"} object.}

\item{X}{Matrix of covariates to predict the corresponding response's conditional quantiles.}

\item{prob_lvls_predict}{Vector of probability levels at which to predict the conditional quantiles.}

\item{intermediate_quantiles}{Vector of intermediate conditional quantiles at level \code{fit_eqrn$interm_lvl}.}

\item{interm_lvl}{Optional, checks that \code{interm_lvl == fit_eqrn$interm_lvl}.}

\item{device}{(optional) A \code{\link[torch:torch_device]{torch::torch_device()}}. Defaults to \code{\link[=default_device]{default_device()}}.}
}
\value{
Matrix of size \code{nrow(X)} times \code{prob_lvls_predict}
containing the conditional quantile estimates of the response associated to each covariate observation at each probability level.
Simplifies to a vector if \code{length(prob_lvls_predict)==1}.
}
\description{
Predict function for an EQRN_iid fitted object
}
