% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clust_it.R
\name{clust_it}
\alias{clust_it}
\title{Function for iterative clustering}
\usage{
clust_it(pop, m = 5, l = 4, g1 = 5, g2 = g1 * 0.5, d1 = 1000, d2 = d1 * 2)
}
\arguments{
\item{pop}{Population to attend (dataframe with three variables: x, y, and weight). x and y are plain coordinates in the defined CRS}

\item{m}{Number of iteration rounds. Default 5}

\item{l}{Number of iteration rounds with the first group size (g1). Default 4}

\item{g1}{Size of the groups for the first l iterations. Default 50}

\item{g2}{Size of the groups for the last m-l iterations. Default g1 * 0.5}

\item{d1}{Distance range of service for the first iterations Default 1000}

\item{d2}{Second distance range of service. Default double of d1}
}
\value{
Return a LIST with:
\item{Clustered}{Population assigned to created centers by clusterization}
\item{pop}{Remaining non-assigned population}
}
\description{
The function clusters population to create service's centers. Iterates EPP::clust_pop for the remaining population in each step. It allows to define two distances of service and two group sizes for several rounds of iteration.
}
\examples{
clu <- clust_it(pop = pop_epp)
}
