% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eml_validate.R
\name{eml_validate}
\alias{eml_validate}
\title{eml_validate}
\usage{
eml_validate(eml, encoding = "UTF-8", schema = NULL)
}
\arguments{
\item{eml}{an eml class object, file, or xml document}

\item{encoding}{optional, if eml is a file path / an eml and has special characters, one can
gives the encoding used by xmlParse.}

\item{schema}{path to schema}

\item{...}{additional arguments to eml_write, such as namespaces}
}
\value{
Whether the document is valid (logical)
}
\description{
eml_validate processes an EML document using the XSD schema for the
appropriate version of EML and determines if the document is schema-valid
as defined by the XSD specification
}
\examples{
\donttest{

 f <- system.file("xsd/test", "eml.xml", package = "EML")

 ## validate given a file name, without needing to parse first
 eml_validate(f)

## Validate given an "eml" object
eml <- read_eml(f)
eml_validate(eml)

}

}
