% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S_class_EARL.R
\docType{class}
\name{EARL-class}
\alias{EARL-class}
\title{Class \code{EARL}}
\description{
Class \code{EARL} contains results for an EARL analysis.
}
\section{Slots}{

\describe{
\item{\code{analysis}}{Contains a Learning or LearningMulti object.}

\item{\code{analysis@txInfo}}{Feasible tx information.}

\item{\code{analysis@propen}}{Propensity regression analysis.}

\item{\code{analysis@outcome}}{Outcome regression analysis.}

\item{\code{analysis@cvInfo}}{Cross-validation analysis if single regime.}

\item{\code{analysis@optim}}{Optimization analysis if single regime.}

\item{\code{analysis@optimResult}}{list of cross-validation and optimization results
if multiple regimes. optimResult[[i]]@cvInfo and optimResult[[i]]@optim.}

\item{\code{analysis@optimal}}{Estimated optimal Tx and value.}

\item{\code{analysis@call}}{Unevaluated call to statistical method.}
}}

\section{Methods For Post-Processing of Regression Analysis}{


 \describe{
   \item{outcome}{: 
      Retrieve value object returned by outcome regression methods.  }
}



 \describe{
   \item{propen}{: 
      Retrieve value object returned by propensity regression methods.  }
}



 \describe{
   \item{coef}{: 
     Retrieve parameter estimates for all regression steps. }
   \item{fitObject}{: 
      Retrieve value object returned by regression methods. }
   \item{plot}{: 
      Generate plots for regression analyses.  }
}
}

\section{Methods For Post-Processing of Optimization Analysis}{


 \describe{
   \item{cvInfo}{: 
      Retrieve cross-validation results.  }
   \item{optimObj}{: 
      Retrieve value object returned by optimization method(s).  }
   \item{regimeCoef}{: 
      Retrieve estimated parameters for optimal tx regime.  }
}
}

\section{Methods For Accessing Main Results}{


 \describe{
   \item{DTRstep}{: 
      Retrieve description of method used to create object. }
   \item{estimator}{: 
      Retrieve the estimated value of the estimated
      optimal regime for the training data set. }
   \item{optTx}{: 
      Retrieve/predict the estimated decision functions and/or optimal tx. }
   \item{print}{: 
      Print main results of analysis.}
   \item{show}{: 
      Show main results of analysis.}
   \item{summary}{: 
      Retrieve summary information.}
}
}

