% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{horse_colic_surgery_df}
\alias{horse_colic_surgery_df}
\title{Colic Horse Surgery}
\format{
A data frame with 300 observations and 31 variables:
\describe{
  \item{surgery}{Factor with 2 levels indicating surgical requirement}
  \item{age}{Factor with 1 level (age group)}
  \item{hospitalID}{Integer hospital identifier}
  \item{temp_rectal}{Numeric rectal temperature}
  \item{pulse}{Numeric pulse rate}
  \item{respiratory_rate}{Numeric respiratory rate}
  \item{temp_extreme}{Factor with 4 levels (temperature extremes)}
  \item{pulse_peripheral}{Factor with 4 levels (peripheral pulse)}
  \item{capillayr_refill_time}{Factor with 3 levels (capillary refill time)}
  \item{pain}{Numeric pain score}
  \item{peristalsis}{Numeric peristalsis measure}
  \item{abdominal_distension}{Numeric distension score}
  \item{nasogastric_tube}{Numeric tube measure}
  \item{nasogastric_reflux}{Numeric reflux quantity}
  \item{nasogastric_reflux_PH}{Numeric reflux pH}
  \item{rectal_examination}{Numeric exam result}
  \item{abdomen}{Numeric abdomen assessment}
  \item{cell_volume}{Numeric cell volume}
  \item{protein}{Numeric protein level}
  \item{abdominocentesis_appearance}{Numeric appearance score}
  \item{abdomcentesis_protein}{Numeric protein measure}
  \item{outcome}{Factor with 3 levels (outcome status)}
  \item{surgical_lesion}{Factor with 2 levels (lesion type)}
  \item{lesion_type1}{Factor with 60 levels (primary lesion type)}
  \item{lesion_type2}{Integer secondary lesion code}
  \item{lesion_type3}{Integer tertiary lesion code}
  \item{cp_data}{Factor with 2 levels (CP data)}
  \item{temp_extreme_ordered}{Ordered factor with 4 levels (temperature)}
  \item{temp_extreme_num}{Numeric temperature measure}
  \item{mucous_membranes_col}{Factor with 6 levels (membrane color)}
  \item{mucous_membranes_group}{Factor with 5 levels (membrane group)}
}
}
\source{
Data taken from the \pkg{VIM} package version 6.2.2 (originally from UCI repository).
}
\usage{
data(horse_colic_surgery_df)
}
\description{
This dataset, horse_colic_surgery_df, is a data frame containing clinical observations
of horses with colic, where the primary task is to determine if the lesion requires surgery.
The data consists of 300 cases with 31 clinical variables, modified from the original UCI
repository version with adjusted factor levels.
}
\details{
The dataset name has been kept as 'horse_colic_surgery_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
DigestiveDataSets package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not been modified
in any way beyond factor level adjustments.
}
