/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine.JRI;

import org.rosuda.JRI.Mutex;
import org.rosuda.JRI.RMainLoopCallbacks;
import org.rosuda.JRI.Rengine;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPDouble;
import org.rosuda.REngine.REXPEnvironment;
import org.rosuda.REngine.REXPFactor;
import org.rosuda.REngine.REXPGenericVector;
import org.rosuda.REngine.REXPInteger;
import org.rosuda.REngine.REXPJavaReference;
import org.rosuda.REngine.REXPLanguage;
import org.rosuda.REngine.REXPList;
import org.rosuda.REngine.REXPLogical;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REXPNull;
import org.rosuda.REngine.REXPRaw;
import org.rosuda.REngine.REXPReference;
import org.rosuda.REngine.REXPS4;
import org.rosuda.REngine.REXPString;
import org.rosuda.REngine.REXPSymbol;
import org.rosuda.REngine.REXPUnknown;
import org.rosuda.REngine.REngine;
import org.rosuda.REngine.REngineCallbacks;
import org.rosuda.REngine.REngineConsoleHistoryInterface;
import org.rosuda.REngine.REngineEvalException;
import org.rosuda.REngine.REngineException;
import org.rosuda.REngine.REngineInputInterface;
import org.rosuda.REngine.REngineOutputInterface;
import org.rosuda.REngine.REngineUIInterface;
import org.rosuda.REngine.RList;

public class JRIEngine
extends REngine
implements RMainLoopCallbacks {
    static final int NILSXP = 0;
    static final int SYMSXP = 1;
    static final int LISTSXP = 2;
    static final int CLOSXP = 3;
    static final int ENVSXP = 4;
    static final int PROMSXP = 5;
    static final int LANGSXP = 6;
    static final int SPECIALSXP = 7;
    static final int BUILTINSXP = 8;
    static final int CHARSXP = 9;
    static final int LGLSXP = 10;
    static final int INTSXP = 13;
    static final int REALSXP = 14;
    static final int CPLXSXP = 15;
    static final int STRSXP = 16;
    static final int DOTSXP = 17;
    static final int ANYSXP = 18;
    static final int VECSXP = 19;
    static final int EXPRSXP = 20;
    static final int BCODESXP = 21;
    static final int EXTPTRSXP = 22;
    static final int WEAKREFSXP = 23;
    static final int RAWSXP = 24;
    static final int S4SXP = 25;
    public static final long requiredAPIversion = 266L;
    static JRIEngine jriEngine = null;
    Rengine rni;
    REngineCallbacks callbacks;
    Mutex rniMutex;
    long R_UnboundValue;
    long R_NilValue;
    public REXPReference globalEnv;
    public REXPReference emptyEnv;
    public REXPReference baseEnv;
    public REXPReference nullValueRef;
    public REXPNull nullValue;

    public static REngine createEngine() throws REngineException {
        if (jriEngine == null) {
            jriEngine = new JRIEngine();
        }
        return jriEngine;
    }

    public static REngine createEngine(String[] stringArray, REngineCallbacks rEngineCallbacks, boolean bl) throws REngineException {
        if (jriEngine != null) {
            throw new REngineException(jriEngine, "engine already running - cannot use extended constructor on a running instance");
        }
        jriEngine = new JRIEngine(stringArray, rEngineCallbacks, bl);
        return jriEngine;
    }

    public Rengine getRni() {
        return this.rni;
    }

    public JRIEngine() throws REngineException {
        this(new String[]{"--no-save"}, (REngineCallbacks)null, false);
    }

    public JRIEngine(String[] stringArray) throws REngineException {
        this(stringArray, (REngineCallbacks)null, false);
    }

    public JRIEngine(String[] stringArray, RMainLoopCallbacks rMainLoopCallbacks) throws REngineException {
        this(stringArray, rMainLoopCallbacks, rMainLoopCallbacks != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JRIEngine(String[] stringArray, REngineCallbacks rEngineCallbacks, boolean bl) throws REngineException {
        block8: {
            this.rni = null;
            this.callbacks = null;
            this.rniMutex = null;
            if (!Rengine.jriLoaded) {
                throw new REngineException(null, "Cannot load JRI native library");
            }
            if (Rengine.getVersion() < 266L) {
                throw new REngineException(null, "JRI API version is too old, update rJava/JRI to match the REngine API");
            }
            this.callbacks = rEngineCallbacks;
            this.rni = new Rengine(stringArray, bl, (RMainLoopCallbacks)(rEngineCallbacks == null ? null : this));
            this.rniMutex = this.rni.getRsync();
            boolean bl2 = this.rniMutex.safeLock();
            try {
                if (!this.rni.waitForR()) {
                    throw new REngineException(this, "Unable to initialize R");
                }
                JRIEngine jRIEngine = this;
                if (jRIEngine.rni.rniGetVersion() < 266L) {
                    throw new REngineException(this, "JRI API version is too old, update rJava/JRI to match the REngine API");
                }
                this.globalEnv = new REXPReference((REngine)this, new Long(this.rni.rniSpecialObject(1)));
                this.R_NilValue = this.rni.rniSpecialObject(0);
                this.nullValueRef = new REXPReference((REngine)this, new Long(this.R_NilValue));
                this.emptyEnv = new REXPReference((REngine)this, new Long(this.rni.rniSpecialObject(2)));
                this.baseEnv = new REXPReference((REngine)this, new Long(this.rni.rniSpecialObject(3)));
                this.nullValue = new REXPNull();
                this.R_UnboundValue = this.rni.rniSpecialObject(4);
                Object var6_5 = null;
                if (!bl2) break block8;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (bl2) {
                    this.rniMutex.unlock();
                }
                throw throwable;
            }
            this.rniMutex.unlock();
        }
        lastEngine = this;
        if (jriEngine == null) {
            jriEngine = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JRIEngine(String[] stringArray, RMainLoopCallbacks rMainLoopCallbacks, boolean bl) throws REngineException {
        block8: {
            this.rni = null;
            this.callbacks = null;
            this.rniMutex = null;
            if (!Rengine.jriLoaded) {
                throw new REngineException(null, "Cannot load JRI native library");
            }
            if (Rengine.getVersion() < 266L) {
                throw new REngineException(null, "JRI API version is too old, update rJava/JRI to match the REngine API");
            }
            this.rni = new Rengine(stringArray, bl, rMainLoopCallbacks);
            this.rniMutex = this.rni.getRsync();
            boolean bl2 = this.rniMutex.safeLock();
            try {
                if (!this.rni.waitForR()) {
                    throw new REngineException(this, "Unable to initialize R");
                }
                JRIEngine jRIEngine = this;
                if (jRIEngine.rni.rniGetVersion() < 266L) {
                    throw new REngineException(this, "JRI API version is too old, update rJava/JRI to match the REngine API");
                }
                this.globalEnv = new REXPReference((REngine)this, new Long(this.rni.rniSpecialObject(1)));
                this.R_NilValue = this.rni.rniSpecialObject(0);
                this.nullValueRef = new REXPReference((REngine)this, new Long(this.R_NilValue));
                this.emptyEnv = new REXPReference((REngine)this, new Long(this.rni.rniSpecialObject(2)));
                this.baseEnv = new REXPReference((REngine)this, new Long(this.rni.rniSpecialObject(3)));
                this.nullValue = new REXPNull();
                this.R_UnboundValue = this.rni.rniSpecialObject(4);
                Object var6_5 = null;
                if (!bl2) break block8;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (bl2) {
                    this.rniMutex.unlock();
                }
                throw throwable;
            }
            this.rniMutex.unlock();
        }
        lastEngine = this;
        if (jriEngine == null) {
            jriEngine = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JRIEngine(Rengine rengine) throws REngineException {
        block6: {
            this.rni = null;
            this.callbacks = null;
            this.rniMutex = null;
            if (!Rengine.jriLoaded) {
                throw new REngineException(null, "Cannot load JRI native library");
            }
            this.rni = rengine;
            JRIEngine jRIEngine = this;
            if (jRIEngine.rni.rniGetVersion() < 265L) {
                throw new REngineException(this, "R JRI engine is too old - RNI API 1.9 (JRI 0.5) or newer is required");
            }
            this.rniMutex = this.rni.getRsync();
            boolean bl = this.rniMutex.safeLock();
            try {
                this.globalEnv = new REXPReference((REngine)this, new Long(this.rni.rniSpecialObject(1)));
                this.R_NilValue = this.rni.rniSpecialObject(0);
                this.nullValueRef = new REXPReference((REngine)this, new Long(this.R_NilValue));
                this.emptyEnv = new REXPReference((REngine)this, new Long(this.rni.rniSpecialObject(2)));
                this.baseEnv = new REXPReference((REngine)this, new Long(this.rni.rniSpecialObject(3)));
                this.nullValue = new REXPNull();
                this.R_UnboundValue = this.rni.rniSpecialObject(4);
                Object var4_3 = null;
                if (!bl) break block6;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (bl) {
                    this.rniMutex.unlock();
                }
                throw throwable;
            }
            this.rniMutex.unlock();
        }
        lastEngine = this;
        if (jriEngine == null) {
            jriEngine = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public REXP parse(String string, boolean bl) throws REngineException {
        void var3_6;
        Object var3_3 = null;
        boolean bl2 = this.rniMutex.safeLock();
        try {
            long l = this.rni.rniParse(string, -1);
            if (l == 0L || l == this.R_NilValue) {
                throw new REngineException(this, "Parse error");
            }
            this.rni.rniPreserve(l);
            REXPReference rEXPReference = new REXPReference((REngine)this, new Long(l));
            if (bl) {
                try {
                    REXP rEXP = this.resolveReference(rEXPReference);
                }
                catch (REXPMismatchException rEXPMismatchException) {
                }
            }
            Object var9_10 = null;
            if (!bl2) return var3_6;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (!bl2) throw throwable;
            this.rniMutex.unlock();
            throw throwable;
        }
        this.rniMutex.unlock();
        return var3_6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public REXP eval(REXP rEXP, REXP rEXP2, boolean bl) throws REngineException, REXPMismatchException {
        void var4_7;
        Object var4_4 = null;
        long l = 0L;
        if (rEXP2 != null && !rEXP2.isReference()) {
            if (!rEXP2.isEnvironment() || ((REXPEnvironment)rEXP2).getHandle() == null) {
                throw new REXPMismatchException(rEXP2, "environment");
            }
            l = ((JRIPointer)((REXPEnvironment)rEXP2).getHandle()).pointer();
        } else if (rEXP2 != null) {
            l = (Long)((REXPReference)rEXP2).getHandle();
        }
        if (rEXP == null) {
            throw new REngineException(this, "null object to evaluate");
        }
        if (!rEXP.isReference()) {
            if (!rEXP.isExpression() && !rEXP.isLanguage()) throw new REXPMismatchException(rEXP2, "reference, expression or language");
            rEXP = this.createReference(rEXP);
        }
        boolean bl2 = this.rniMutex.safeLock();
        try {
            long l2 = this.rni.rniEval(((Long)((REXPReference)rEXP).getHandle()).longValue(), l);
            if (l2 == -1L) {
                throw new REngineEvalException(this, "Eval error (invalid input)", -1);
            }
            if (l2 == -2L) {
                throw new REngineEvalException(this, "error during evaluation", -2);
            }
            this.rni.rniPreserve(l2);
            REXPReference rEXPReference = new REXPReference((REngine)this, new Long(l2));
            if (bl) {
                REXP rEXP3 = this.resolveReference(rEXPReference);
            }
            Object var11_11 = null;
            if (!bl2) return var4_7;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (!bl2) throw throwable;
            this.rniMutex.unlock();
            throw throwable;
        }
        this.rniMutex.unlock();
        return var4_7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void assign(String string, REXP rEXP, REXP rEXP2) throws REngineException, REXPMismatchException {
        boolean bl;
        block10: {
            long l = 0L;
            if (rEXP2 != null && !rEXP2.isReference()) {
                if (!rEXP2.isEnvironment() || ((REXPEnvironment)rEXP2).getHandle() == null) {
                    throw new REXPMismatchException(rEXP2, "environment");
                }
                l = ((JRIPointer)((REXPEnvironment)rEXP2).getHandle()).pointer();
            } else if (rEXP2 != null) {
                l = (Long)((REXPReference)rEXP2).getHandle();
            }
            if (rEXP == null) {
                rEXP = this.nullValueRef;
            }
            if (!rEXP.isReference()) {
                rEXP = this.createReference(rEXP);
            }
            boolean bl2 = this.rniMutex.safeLock();
            bl = false;
            try {
                bl = this.rni.rniAssign(string, ((Long)((REXPReference)rEXP).getHandle()).longValue(), l);
                Object var9_7 = null;
                if (!bl2) break block10;
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                if (bl2) {
                    this.rniMutex.unlock();
                }
                throw throwable;
            }
            this.rniMutex.unlock();
        }
        if (!bl) {
            throw new REngineException(this, "assign failed (probably locked binding");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public REXP get(String string, REXP rEXP, boolean bl) throws REngineException, REXPMismatchException {
        void var4_7;
        long l;
        boolean bl2;
        block10: {
            REXP rEXP2;
            Object var4_4 = null;
            long l2 = 0L;
            if (rEXP != null && !rEXP.isReference()) {
                if (!rEXP.isEnvironment() || ((REXPEnvironment)rEXP).getHandle() == null) {
                    throw new REXPMismatchException(rEXP, "environment");
                }
                l2 = ((JRIPointer)((REXPEnvironment)rEXP).getHandle()).pointer();
            } else if (rEXP != null) {
                l2 = (Long)((REXPReference)rEXP).getHandle();
            }
            bl2 = this.rniMutex.safeLock();
            try {
                l = this.rni.rniFindVar(string, l2);
                if (l != this.R_UnboundValue && l != 0L) break block10;
                rEXP2 = null;
                Object var12_13 = null;
                if (!bl2) return rEXP2;
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                if (!bl2) throw throwable;
                this.rniMutex.unlock();
                throw throwable;
            }
            this.rniMutex.unlock();
            return rEXP2;
        }
        this.rni.rniPreserve(l);
        REXPReference rEXPReference = new REXPReference((REngine)this, new Long(l));
        if (bl) {
            try {
                REXP rEXP3 = this.resolveReference(rEXPReference);
            }
            catch (REXPMismatchException rEXPMismatchException) {
            }
        }
        Object var12_14 = null;
        if (!bl2) return var4_7;
        this.rniMutex.unlock();
        return var4_7;
    }

    public REXP resolveReference(REXP rEXP) throws REngineException, REXPMismatchException {
        Object var2_2 = null;
        if (rEXP == null) {
            throw new REngineException(this, "resolveReference called on NULL input");
        }
        if (!rEXP.isReference()) {
            throw new REXPMismatchException(rEXP, "reference");
        }
        long l = (Long)((REXPReference)rEXP).getHandle();
        if (l == 0L) {
            return this.nullValue;
        }
        return this.resolvePointer(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    REXP resolvePointer(long l) throws REngineException, REXPMismatchException {
        boolean bl;
        REXP rEXP;
        block33: {
            REXPNull rEXPNull;
            block32: {
                REXPJavaReference rEXPJavaReference;
                block31: {
                    if (l == 0L) {
                        return this.nullValue;
                    }
                    rEXP = null;
                    bl = this.rniMutex.safeLock();
                    try {
                        int n;
                        String[] stringArray;
                        Object object;
                        int n2 = this.rni.rniExpType(l);
                        String[] stringArray2 = this.rni.rniGetAttrNames(l);
                        REXPList rEXPList = null;
                        if (stringArray2 != null && stringArray2.length > 0) {
                            long l2 = 0L;
                            object = null;
                            stringArray = new RList();
                            for (n = 0; n < stringArray2.length; ++n) {
                                REXP rEXP2;
                                long l3 = this.rni.rniGetAttr(l, stringArray2[n]);
                                if (l3 == 0L || l3 == this.R_NilValue) continue;
                                if (stringArray2[n].equals("jobj")) {
                                    l2 = l3;
                                }
                                if ((rEXP2 = this.resolvePointer(l3)) == null || rEXP2 == this.nullValue) continue;
                                stringArray.put(stringArray2[n], rEXP2);
                                if (!stringArray2[n].equals("class") || !rEXP2.isString()) continue;
                                object = rEXP2.asString();
                            }
                            if (stringArray.size() > 0) {
                                rEXPList = new REXPList((RList)stringArray);
                            }
                            if (l2 != 0L && object != null && (object.equals("jobjRef") || object.equals("jarrayRef") || object.equals("jrectRef"))) {
                                rEXPJavaReference = new REXPJavaReference(this.rni.rniXrefToJava(l2), rEXPList);
                                Object var19_22 = null;
                                if (!bl) return rEXPJavaReference;
                                break block31;
                            }
                        }
                        switch (n2) {
                            case 0: {
                                rEXPNull = this.nullValue;
                                break block32;
                            }
                            case 16: {
                                String[] stringArray3 = this.rni.rniGetStringArray(l);
                                rEXP = new REXPString(stringArray3, rEXPList);
                                break;
                            }
                            case 13: {
                                long l4;
                                if (this.rni.rniInherits(l, "factor") && (l4 = this.rni.rniGetAttr(l, "levels")) != 0L) {
                                    stringArray = null;
                                    n = this.rni.rniExpType(l4);
                                    if (n == 16) {
                                        stringArray = this.rni.rniGetStringArray(l4);
                                        int[] nArray = this.rni.rniGetIntArray(l);
                                        rEXP = new REXPFactor(nArray, stringArray, rEXPList);
                                    }
                                }
                                if (rEXP != null) break;
                                rEXP = new REXPInteger(this.rni.rniGetIntArray(l), rEXPList);
                                break;
                            }
                            case 14: {
                                rEXP = new REXPDouble(this.rni.rniGetDoubleArray(l), rEXPList);
                                break;
                            }
                            case 10: {
                                int[] nArray = this.rni.rniGetBoolArrayI(l);
                                object = new byte[nArray.length];
                                for (int i = 0; i < nArray.length; ++i) {
                                    object[i] = nArray[i] == 0 || nArray[i] == 1 ? (byte)nArray[i] : (byte)-128;
                                }
                                rEXP = new REXPLogical((byte[])object, rEXPList);
                                break;
                            }
                            case 19: {
                                long[] lArray = this.rni.rniGetVector(l);
                                object = new REXP[lArray.length];
                                long l5 = this.rni.rniGetAttr(l, "names");
                                String[] stringArray4 = null;
                                if (l5 != 0L && this.rni.rniExpType(l5) == 16) {
                                    stringArray4 = this.rni.rniGetStringArray(l5);
                                }
                                for (int i = 0; i < lArray.length; ++i) {
                                    object[i] = this.resolvePointer(lArray[i]);
                                }
                                RList rList = stringArray4 == null ? new RList((REXP[])object) : new RList((REXP[])object, stringArray4);
                                rEXP = new REXPGenericVector(rList, rEXPList);
                                break;
                            }
                            case 24: {
                                rEXP = new REXPRaw(this.rni.rniGetRawArray(l), rEXPList);
                                break;
                            }
                            case 2: 
                            case 6: {
                                RList rList = new RList();
                                long l6 = l;
                                while (l6 != 0L && l6 != this.R_NilValue) {
                                    long l7 = this.rni.rniCAR(l6);
                                    long l8 = this.rni.rniTAG(l6);
                                    String string = null;
                                    if (this.rni.rniExpType(l8) == 1) {
                                        string = this.rni.rniGetSymbolName(l8);
                                    }
                                    REXP rEXP3 = this.resolvePointer(l7);
                                    if (string == null) {
                                        rList.add(rEXP3);
                                    } else {
                                        rList.put(string, rEXP3);
                                    }
                                    l6 = this.rni.rniCDR(l6);
                                }
                                rEXP = n2 == 6 ? new REXPLanguage(rList, rEXPList) : new REXPList(rList, rEXPList);
                                break;
                            }
                            case 1: {
                                rEXP = new REXPSymbol(this.rni.rniGetSymbolName(l));
                                break;
                            }
                            case 4: {
                                if (l != 0L) {
                                    this.rni.rniPreserve(l);
                                }
                                rEXP = new REXPEnvironment(this, new JRIPointer(l, false));
                                break;
                            }
                            case 25: {
                                rEXP = new REXPS4(rEXPList);
                                break;
                            }
                            default: {
                                rEXP = new REXPUnknown(n2, rEXPList);
                                break;
                            }
                        }
                        break block33;
                    }
                    catch (Throwable throwable) {
                        Object var19_25 = null;
                        if (!bl) throw throwable;
                        this.rniMutex.unlock();
                        throw throwable;
                    }
                }
                this.rniMutex.unlock();
                return rEXPJavaReference;
            }
            Object var19_23 = null;
            if (!bl) return rEXPNull;
            this.rniMutex.unlock();
            return rEXPNull;
        }
        Object var19_24 = null;
        if (!bl) return rEXP;
        this.rniMutex.unlock();
        return rEXP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public REXP createReference(REXP rEXP) throws REngineException, REXPMismatchException {
        if (rEXP == null) {
            throw new REngineException(this, "createReference from a NULL value");
        }
        if (rEXP.isReference()) {
            return rEXP;
        }
        long l = this.createReferencePointer(rEXP);
        if (l == 0L) {
            return null;
        }
        boolean bl = this.rniMutex.safeLock();
        try {
            this.rni.rniPreserve(l);
            Object var6_4 = null;
            if (!bl) return new REXPReference((REngine)this, new Long(l));
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (!bl) throw throwable;
            this.rniMutex.unlock();
            throw throwable;
        }
        this.rniMutex.unlock();
        return new REXPReference((REngine)this, new Long(l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    long createReferencePointer(REXP rEXP) throws REngineException, REXPMismatchException {
        int n;
        boolean bl;
        block52: {
            long l;
            block55: {
                long l2;
                block54: {
                    long l3;
                    block53: {
                        long l4;
                        block51: {
                            long l5;
                            block50: {
                                long l6;
                                block47: {
                                    block48: {
                                        if (rEXP.isReference()) {
                                            REXPReference rEXPReference = (REXPReference)rEXP;
                                            if (rEXPReference.getEngine() == this) return (Long)rEXPReference.getHandle();
                                            throw new REXPMismatchException(rEXP, "reference (cross-engine reference is invalid)");
                                        }
                                        bl = this.rniMutex.safeLock();
                                        n = 0;
                                        try {
                                            long l7;
                                            long l8;
                                            Object object;
                                            int n2;
                                            long l9 = 0L;
                                            if (rEXP.isNull()) {
                                                l6 = this.R_NilValue;
                                                Object var21_15 = null;
                                                if (n <= 0) break block47;
                                                break block48;
                                            }
                                            if (rEXP.isLogical()) {
                                                int[] nArray = rEXP.asIntegers();
                                                for (int i = 0; i < nArray.length; ++i) {
                                                    nArray[i] = nArray[i] < 0 ? 2 : (nArray[i] == 0 ? 0 : 1);
                                                }
                                                l9 = this.rni.rniPutBoolArrayI(nArray);
                                            } else if (rEXP.isInteger()) {
                                                l9 = this.rni.rniPutIntArray(rEXP.asIntegers());
                                            } else if (rEXP.isRaw()) {
                                                l9 = this.rni.rniPutRawArray(rEXP.asBytes());
                                            } else if (rEXP.isNumeric()) {
                                                l9 = this.rni.rniPutDoubleArray(rEXP.asDoubles());
                                            } else if (rEXP.isString()) {
                                                l9 = this.rni.rniPutStringArray(rEXP.asStrings());
                                            } else if (rEXP.isEnvironment()) {
                                                JRIPointer jRIPointer = (JRIPointer)((REXPEnvironment)rEXP).getHandle();
                                                if (jRIPointer == null) {
                                                    long l10 = this.rni.rniParse("new.env(parent=baseenv())", 1);
                                                    l9 = this.rni.rniEval(l10, 0L);
                                                } else {
                                                    l9 = jRIPointer.pointer();
                                                }
                                            } else if (rEXP.isPairList()) {
                                                boolean bl2 = rEXP.isLanguage();
                                                RList rList = rEXP.asList();
                                                l9 = this.R_NilValue;
                                                n2 = rList.size();
                                                if (n2 == 0) {
                                                    l9 = this.rni.rniCons(this.R_NilValue, 0L, 0L, bl2);
                                                } else {
                                                    for (int i = n2 - 1; i >= 0; --i) {
                                                        object = rList.at(i);
                                                        String string = rList.keyAt(i);
                                                        long l11 = 0L;
                                                        if (string != null) {
                                                            l11 = this.rni.rniInstallSymbol(string);
                                                        }
                                                        if ((l8 = this.createReferencePointer((REXP)object)) == 0L) {
                                                            l8 = this.R_NilValue;
                                                        }
                                                        l7 = this.rni.rniCons(l8, l9, l11, i == 0 && bl2);
                                                        this.rni.rniPreserve(l7);
                                                        this.rni.rniRelease(l9);
                                                        l9 = l7;
                                                    }
                                                }
                                            } else if (rEXP.isList()) {
                                                int n3 = n;
                                                RList rList = rEXP.asList();
                                                long[] lArray = new long[rList.size()];
                                                for (int i = 0; i < lArray.length; ++i) {
                                                    object = rList.at(i);
                                                    if (object == null || ((REXP)object).isNull()) {
                                                        lArray[i] = this.R_NilValue;
                                                        continue;
                                                    }
                                                    long l12 = this.createReferencePointer((REXP)object);
                                                    if (l12 != 0L && l12 != this.R_NilValue) {
                                                        this.rni.rniProtect(l12);
                                                        ++n;
                                                    } else {
                                                        l12 = this.R_NilValue;
                                                    }
                                                    lArray[i] = l12;
                                                }
                                                l9 = this.rni.rniPutVector(lArray);
                                                if (n3 > n) {
                                                    this.rni.rniUnprotect(n - n3);
                                                    n = n3;
                                                }
                                            } else {
                                                if (rEXP.isSymbol()) {
                                                    l5 = this.rni.rniInstallSymbol(rEXP.asString());
                                                    break block50;
                                                }
                                                if (rEXP instanceof REXPJavaReference) {
                                                    Object object2 = ((REXPJavaReference)rEXP).getObject();
                                                    long l13 = this.rni.rniJavaToXref(object2);
                                                    this.rni.rniProtect(l13);
                                                    long l14 = this.rni.rniInstallSymbol("jobj");
                                                    long l15 = this.rni.rniInstallSymbol("jclass");
                                                    String string = "java/lang/Object";
                                                    if (object2 != null) {
                                                        string = object2.getClass().getName();
                                                        string = string.replace('.', '/');
                                                    }
                                                    l8 = this.rni.rniPutString(string);
                                                    this.rni.rniProtect(l8);
                                                    l7 = this.rni.rniPutString("jobjRef");
                                                    this.rni.rniProtect(l7);
                                                    long l16 = this.rni.rniEval(this.rni.rniLCons(this.rni.rniInstallSymbol("new"), this.rni.rniCons(l7, this.rni.rniCons(l13, this.rni.rniCons(l8, this.R_NilValue, l15, false), l14, false))), 0L);
                                                    this.rni.rniUnprotect(3);
                                                    l9 = l16;
                                                }
                                            }
                                            if (l9 == this.R_NilValue) {
                                                l4 = l9;
                                                break block51;
                                            }
                                            if (l9 == 0L) break block52;
                                            REXPList rEXPList = rEXP._attr();
                                            if (rEXPList == null || !rEXPList.isPairList()) {
                                                l3 = l9;
                                                break block53;
                                            }
                                            RList rList = rEXPList.asList();
                                            if (rList == null || rList.size() < 1 || !rList.isNamed()) {
                                                l2 = l9;
                                                break block54;
                                            }
                                            this.rni.rniProtect(l9);
                                            ++n;
                                            for (n2 = 0; n2 < rList.size(); ++n2) {
                                                long l17;
                                                REXP rEXP2 = rList.at(n2);
                                                object = rList.keyAt(n2);
                                                if (object == null || (l17 = this.createReferencePointer(rEXP2)) == 0L || l17 == this.R_NilValue) continue;
                                                this.rni.rniSetAttr(l9, (String)object, l17);
                                            }
                                            l = l9;
                                            break block55;
                                        }
                                        catch (Throwable throwable) {
                                            Object var21_22 = null;
                                            if (n > 0) {
                                                this.rni.rniUnprotect(n);
                                            }
                                            if (!bl) throw throwable;
                                            this.rniMutex.unlock();
                                            throw throwable;
                                        }
                                    }
                                    this.rni.rniUnprotect(n);
                                }
                                if (!bl) return l6;
                                this.rniMutex.unlock();
                                return l6;
                            }
                            Object var21_16 = null;
                            if (n > 0) {
                                this.rni.rniUnprotect(n);
                            }
                            if (!bl) return l5;
                            this.rniMutex.unlock();
                            return l5;
                        }
                        Object var21_17 = null;
                        if (n > 0) {
                            this.rni.rniUnprotect(n);
                        }
                        if (!bl) return l4;
                        this.rniMutex.unlock();
                        return l4;
                    }
                    Object var21_18 = null;
                    if (n > 0) {
                        this.rni.rniUnprotect(n);
                    }
                    if (!bl) return l3;
                    this.rniMutex.unlock();
                    return l3;
                }
                Object var21_19 = null;
                if (n > 0) {
                    this.rni.rniUnprotect(n);
                }
                if (!bl) return l2;
                this.rniMutex.unlock();
                return l2;
            }
            Object var21_20 = null;
            if (n > 0) {
                this.rni.rniUnprotect(n);
            }
            if (!bl) return l;
            this.rniMutex.unlock();
            return l;
        }
        Object var21_21 = null;
        if (n > 0) {
            this.rni.rniUnprotect(n);
        }
        if (!bl) return 0L;
        this.rniMutex.unlock();
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void finalizeReference(REXP rEXP) throws REngineException, REXPMismatchException {
        if (rEXP == null || !rEXP.isReference()) return;
        long l = (Long)((REXPReference)rEXP).getHandle();
        boolean bl = this.rniMutex.safeLock();
        try {
            this.rni.rniRelease(l);
            Object var6_4 = null;
            if (!bl) return;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (!bl) throw throwable;
            this.rniMutex.unlock();
            throw throwable;
        }
        this.rniMutex.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public REXP getParentEnvironment(REXP rEXP, boolean bl) throws REngineException, REXPMismatchException {
        void var3_6;
        long l;
        boolean bl2;
        block8: {
            REXP rEXP2;
            Object var3_3 = null;
            long l2 = 0L;
            if (rEXP != null && !rEXP.isReference()) {
                if (!rEXP.isEnvironment() || ((REXPEnvironment)rEXP).getHandle() == null) {
                    throw new REXPMismatchException(rEXP, "environment");
                }
                l2 = ((JRIPointer)((REXPEnvironment)rEXP).getHandle()).pointer();
            } else if (rEXP != null) {
                l2 = (Long)((REXPReference)rEXP).getHandle();
            }
            bl2 = this.rniMutex.safeLock();
            try {
                l = this.rni.rniParentEnv(l2);
                if (l != 0L && l != this.R_NilValue) break block8;
                rEXP2 = null;
                Object var11_11 = null;
                if (!bl2) return rEXP2;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                if (!bl2) throw throwable;
                this.rniMutex.unlock();
                throw throwable;
            }
            this.rniMutex.unlock();
            return rEXP2;
        }
        this.rni.rniPreserve(l);
        REXPReference rEXPReference = new REXPReference((REngine)this, new Long(l));
        if (bl) {
            REXP rEXP3 = this.resolveReference(rEXPReference);
        }
        Object var11_12 = null;
        if (!bl2) return var3_6;
        this.rniMutex.unlock();
        return var3_6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public REXP newEnvironment(REXP rEXP, boolean bl) throws REXPMismatchException, REngineException {
        void var3_6;
        Object var3_3 = null;
        boolean bl2 = this.rniMutex.safeLock();
        try {
            long l;
            long l2 = 0L;
            if (rEXP != null && !rEXP.isReference()) {
                if (!rEXP.isEnvironment() || ((REXPEnvironment)rEXP).getHandle() == null) {
                    throw new REXPMismatchException(rEXP, "environment");
                }
                l2 = ((JRIPointer)((REXPEnvironment)rEXP).getHandle()).pointer();
            } else if (rEXP != null) {
                l2 = (Long)((REXPReference)rEXP).getHandle();
            }
            if (l2 == 0L) {
                l2 = (Long)this.globalEnv.getHandle();
            }
            if ((l = this.rni.rniEval(this.rni.rniLCons(this.rni.rniInstallSymbol("new.env"), this.rni.rniCons(l2, this.R_NilValue, this.rni.rniInstallSymbol("parent"), false)), 0L)) != 0L) {
                this.rni.rniPreserve(l);
            }
            REXPReference rEXPReference = new REXPReference((REngine)this, new Long(l));
            if (bl) {
                REXP rEXP2 = this.resolveReference(rEXPReference);
            }
            Object var10_10 = null;
            if (!bl2) return var3_6;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (!bl2) throw throwable;
            this.rniMutex.unlock();
            throw throwable;
        }
        this.rniMutex.unlock();
        return var3_6;
    }

    public boolean close() {
        if (this.rni == null) {
            return false;
        }
        this.rni.end();
        return true;
    }

    public synchronized int tryLock() {
        int n = this.rniMutex.tryLock();
        return n == 1 ? 0 : (n == -1 ? 2 : 1);
    }

    public synchronized int lock() {
        return this.rniMutex.safeLock() ? 1 : 2;
    }

    public synchronized void unlock(int n) {
        if (n == 1) {
            this.rniMutex.unlock();
        }
    }

    public boolean supportsReferences() {
        return true;
    }

    public boolean supportsEnvironments() {
        return true;
    }

    public boolean supportsLocking() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public REXPReference createRJavaRef(Object object) throws REngineException {
        if (object == null) {
            return null;
        }
        REXPReference rEXPReference = null;
        boolean bl = this.rniMutex.safeLock();
        try {
            org.rosuda.JRI.REXP rEXP = this.rni.createRJavaRef(object);
            if (rEXP == null) {
                throw new REngineException(this, "Could not push java Object to R");
            }
            long l = rEXP.xp;
            this.rni.rniPreserve(l);
            rEXPReference = new REXPReference((REngine)this, new Long(l));
            Object var8_6 = null;
            if (!bl) return rEXPReference;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (!bl) throw throwable;
            this.rniMutex.unlock();
            throw throwable;
        }
        this.rniMutex.unlock();
        return rEXPReference;
    }

    public void rWriteConsole(Rengine rengine, String string, int n) {
        if (this.callbacks != null && this.callbacks instanceof REngineOutputInterface) {
            ((REngineOutputInterface)((Object)this.callbacks)).RWriteConsole(this, string, n);
        }
    }

    public void rBusy(Rengine rengine, int n) {
        if (this.callbacks != null && this.callbacks instanceof REngineUIInterface) {
            ((REngineUIInterface)((Object)this.callbacks)).RBusyState(this, n);
        }
    }

    public synchronized String rReadConsole(Rengine rengine, String string, int n) {
        if (this.callbacks != null && this.callbacks instanceof REngineInputInterface) {
            return ((REngineInputInterface)((Object)this.callbacks)).RReadConsole(this, string, n);
        }
        try {
            this.wait();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public void rShowMessage(Rengine rengine, String string) {
        if (this.callbacks != null && this.callbacks instanceof REngineOutputInterface) {
            ((REngineOutputInterface)((Object)this.callbacks)).RShowMessage(this, string);
        }
    }

    public String rChooseFile(Rengine rengine, int n) {
        if (this.callbacks != null && this.callbacks instanceof REngineUIInterface) {
            return ((REngineUIInterface)((Object)this.callbacks)).RChooseFile(this, n == 0);
        }
        return null;
    }

    public void rFlushConsole(Rengine rengine) {
        if (this.callbacks != null && this.callbacks instanceof REngineOutputInterface) {
            ((REngineOutputInterface)((Object)this.callbacks)).RFlushConsole(this);
        }
    }

    public void rSaveHistory(Rengine rengine, String string) {
        if (this.callbacks != null && this.callbacks instanceof REngineConsoleHistoryInterface) {
            ((REngineConsoleHistoryInterface)((Object)this.callbacks)).RSaveHistory(this, string);
        }
    }

    public void rLoadHistory(Rengine rengine, String string) {
        if (this.callbacks != null && this.callbacks instanceof REngineConsoleHistoryInterface) {
            ((REngineConsoleHistoryInterface)((Object)this.callbacks)).RLoadHistory(this, string);
        }
    }

    class JRIPointer {
        long ptr;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        JRIPointer(long l, boolean bl) {
            this.ptr = l;
            if (!bl || l == 0L || l == JRIEngine.this.R_NilValue) return;
            boolean bl2 = JRIEngine.this.rniMutex.safeLock();
            try {
                JRIEngine.this.rni.rniPreserve(l);
                Object var7_5 = null;
                if (!bl2) return;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (!bl2) throw throwable;
                JRIEngine.this.rniMutex.unlock();
                throw throwable;
            }
            JRIEngine.this.rniMutex.unlock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void finalize() throws Throwable {
            try {
                block5: {
                    if (this.ptr != 0L && this.ptr != JRIEngine.this.R_NilValue) {
                        boolean bl = JRIEngine.this.rniMutex.safeLock();
                        try {
                            JRIEngine.this.rni.rniRelease(this.ptr);
                            Object var3_2 = null;
                            if (!bl) break block5;
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            if (!bl) throw throwable;
                            JRIEngine.this.rniMutex.unlock();
                            throw throwable;
                        }
                        JRIEngine.this.rniMutex.unlock();
                    }
                }
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                super.finalize();
                throw throwable;
            }
            super.finalize();
        }

        long pointer() {
            return this.ptr;
        }
    }
}

