#' Package ‘DTDA.ni’
#'
#' Documentation for package ‘DTDA.ni’ version 1.0
#'
#' @description
#' Non-iterative estimator for the cumulative distribution of a doubly truncated variable, see de Uña-Álvarez (2018).
#' Restricted to interval sampling.
#'
#'
#' @details
#' \itemize{
#' \item{Package: DTDA.ni}
#' \item{Version: 1.0}
#' \item{Maintainer: José Carlos Soage González \email{jsoage@@uvigo.es}}
#' \item{License: GPL-2}
#' }
#'
#' @return
#' \itemize{
#' \item{DTDAni: Implements a non-iterative estimator for the cumulative distribution of a doubly truncated variable}
#' \item{plot.DTDAni: S3 method to plot a DTDAni object by using the generic plot function.}
#' }
#'
#' @section Acknowledgements:
#' \itemize{
#' \item{Jacobo de Uña-Álvarez was supported by Grant MTM2014-55966-P, Spanish Ministry of Economy and Competitiveness.}
#' \item{José Carlos Soage was supported by Red Tecnológica de Matemática Industrial (Red TMATI), Cons. de Cultura, Educación e OU, Xunta de Galicia (ED341D R2016/051) and by Grupos de Referencia Competitiva, Consolidación y Estructuración de Unidades de Investigación Competitivas del SUG, Cons. de Cultura, Educación e OU, Xunta de Galicia (GRC ED431C 2016/040).}
#' }
#'
#' @references de Uña-Álvarez J. (2018) A Non-iterative Estimator for Interval Sampling and
#' Doubly Truncated Data. In: Gil E., Gil E., Gil J., Gil M. (eds)
#' The Mathematics of the Uncertain. Studies in Systems, Decision and Control,
#' vol 142. Springer, Cham, pp. 387-400.
#'
#' @author
#' \itemize{
#'  \item{de Uña-Álvarez, Jacobo.}
#'  \item{Soage González, José Carlos.}
#' }
"_PACKAGE"
#> [1] "_PACKAGE"


