#' DHS All Women dataset
#'
#' Example for a DHS data based on all women.
#'
#'
#' @format A data frame with 3024 rows and 27 variables:
#' \describe{
#'   \item{v005}{Women individual sample weight}
#'   \item{v007}{Year of interview}
#'   \item{v008}{Date of interview (CMC)}
#'   \item{v011}{Date of birth (CMC)}
#'   \item{v021}{Primary sampling unit}
#'   \item{v022}{Sample strata for sampling error}
#'   \item{v025}{Type of residence urban/rural}
#'   \item{b3_01}{Date of birth (CMC) birth 1}
#'   \item{b3_02}{Date of birth (CMC) birth 2}
#'   \item{b3_03}{Date of birth (CMC) birth 3}
#'   \item{b3_04}{Date of birth (CMC) birth 4}
#'   \item{b3_05}{Date of birth (CMC) birth 5}
#'   \item{b3_06}{Date of birth (CMC) birth 6}
#'   \item{b3_07}{Date of birth (CMC) birth 7}
#'   \item{b3_08}{Date of birth (CMC) birth 8}
#'   \item{b3_09}{Date of birth (CMC) birth 9}
#'   \item{b3_10}{Date of birth (CMC) birth 10}
#'   \item{b3_11}{Date of birth (CMC) birth 11}
#'   \item{b3_12}{Date of birth (CMC) birth 12}
#'   \item{b3_13}{Date of birth (CMC) birth 13}
#'   \item{b3_14}{Date of birth (CMC) birth 14}
#'   \item{b3_15}{Date of birth (CMC) birth 15}
#'   \item{b3_16}{Date of birth (CMC) birth 16}
#'   \item{b3_17}{Date of birth (CMC) birth 17}
#'   \item{b3_18}{Date of birth (CMC) birth 18}
#'   \item{b3_19}{Date of birth (CMC) birth 19}
#'   \item{b3_20}{Date of birth (CMC) birth 20}
#' }
#' @source \url{https://dhsprogram.com/data/available-datasets.cfm}
"AWIR70"
#' DHS Ever-Married Women dataset
#'
#' Example for a DHS data based on ever-married women.
#'
#'
#' @format A data frame with 3014 rows and 30 variables:
#' \describe{
#'   \item{v005}{Women individual sample weight}
#'   \item{v007}{Year of interview}
#'   \item{v008}{Date of interview (CMC)}
#'   \item{v011}{Date of birth (CMC)}
#'   \item{v021}{Primary sampling unit}
#'   \item{v022}{Sample strata for sampling error}
#'   \item{v025}{Type of residence urban/rural}
#'   \item{awfactt}{All woman factor - total}
#'   \item{awfactu}{All woman factor - urban/rural}
#'   \item{awfactr}{All woman factor - regional}
#'   \item{b3_01}{Date of birth (CMC) birth 1}
#'   \item{b3_02}{Date of birth (CMC) birth 2}
#'   \item{b3_03}{Date of birth (CMC) birth 3}
#'   \item{b3_04}{Date of birth (CMC) birth 4}
#'   \item{b3_05}{Date of birth (CMC) birth 5}
#'   \item{b3_06}{Date of birth (CMC) birth 6}
#'   \item{b3_07}{Date of birth (CMC) birth 7}
#'   \item{b3_08}{Date of birth (CMC) birth 8}
#'   \item{b3_09}{Date of birth (CMC) birth 9}
#'   \item{b3_10}{Date of birth (CMC) birth 10}
#'   \item{b3_11}{Date of birth (CMC) birth 11}
#'   \item{b3_12}{Date of birth (CMC) birth 12}
#'   \item{b3_13}{Date of birth (CMC) birth 13}
#'   \item{b3_14}{Date of birth (CMC) birth 14}
#'   \item{b3_15}{Date of birth (CMC) birth 15}
#'   \item{b3_16}{Date of birth (CMC) birth 16}
#'   \item{b3_17}{Date of birth (CMC) birth 17}
#'   \item{b3_18}{Date of birth (CMC) birth 18}
#'   \item{b3_19}{Date of birth (CMC) birth 19}
#'   \item{b3_20}{Date of birth (CMC) birth 20}
#' }
#' @source \url{https://dhsprogram.com/data/available-datasets.cfm}
"EMIR70"
#' DHS Births dataset
#'
#' Example for a DHS data of births.
#'
#'
#' @format A data frame with 2753 rows and 8 variables:
#' \describe{
#'   \item{v005}{Women individual sample weight}
#'   \item{v007}{Year of interview}
#'   \item{v008}{Date of interview (CMC)}
#'   \item{v021}{Primary sampling unit}
#'   \item{v022}{Sample strata for sampling error}
#'   \item{v025}{Type of residence urban/rural}
#'   \item{b3}{Date of birth (CMC)}
#'   \item{b7}{Age at death}
#' }
#' @source \url{https://dhsprogram.com/data/available-datasets.cfm}
"ADBR70"

