% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.R
\name{create_relabel_field}
\alias{create_relabel_field}
\title{Create a new metadata field by renaming existing levels of an existing field.}
\usage{
create_relabel_field(target_column, new_column_name)
}
\arguments{
\item{target_column}{Column name in targets data to be included in the new column. String.}

\item{new_column_name}{Name for the new column that will be created. String.}
}
\value{
This function returns target data containing the newly created label field.
}
\description{
This function, given a target metadata field, will create a new column based on that field that has different labels.
This is particularly useful when cleaning figures for publication quality, as often labels will contain abbreviations or
delimiting characters such as "_".  This function allows for a new column to be generated with more human-friendly labels
that can be fed into visualizations instead of the defaults.
Requires that target data has been prepared with prep_targets().
}
\examples{
\dontrun{

myCounts <- prep_counts(count_input="master_count_data.txt", delim="t")
myTargets <- prep_targets(target_input="master_count_data.txt", delim="t")

#Create a  field based on the "treatment_time" fields with new labels.
myTargets <- create_relabel_field(target_column="treatment_time",
                                 new_column_name="treatment_time_relabel")

}
}
\seealso{
\code{\link{prep_targets}}
}
\keyword{aggregate}
\keyword{metadata}
