\name{dd_KI_ML}
\alias{dd_KI_ML}
\title{ Maximization of the loglikelihood under a diversity-dependent diversification model with decoupling of a subclade's diversication dynamics from the main clade's dynamics
}
\description{
   This function computes the maximum likelihood estimates of the parameters of a
   diversity-dependent diversification model with decoupling of the diversification dynamics of
   a subclade from the dynamics of the main clade for a given set of phylogenetic branching times
   of main clade and subclade and the time of splitting of the lineage that will form the subclade.
   It also outputs the corresponding loglikelihood that can be used in model comparisons.
}
\usage{
dd_KI_ML(brtsM, brtsS, tsplit, initparsopt = c(0.5, 0.1, 2 * (1 + length(brtsM) + 
    missnumspec[1]), 2 * (1 + length(brtsS) + missnumspec[length(missnumspec)]), 
    (tsplit + max(brtsS))/2), parsfix = NULL, idparsopt = c(1:3, 6:7), idparsfix = NULL,
    idparsnoshift = (1:7)[c(-idparsopt, (-1)^(length(idparsfix) != 0) * idparsfix)],
    res = 10 * (1 + length(c(brtsM, brtsS)) + sum(missnumspec)), ddmodel = 1, 
    missnumspec = 0, cond = TRUE, soc = 2, tol = c(1E-3,1E-4,1E-6), maxiter = 1000 * 
    round((1.25)^length(idparsopt)))
}
\arguments{
  \item{brtsM}{A set of branching times of the main clade in a phylogeny, all positive }
  \item{brtsS}{A set of branching times of the subclade in a phylogeny, all positive }
  \item{tsplit}{The branching time at which the lineage forming the subclade branches off, positive}
  \item{initparsopt}{The initial values of the parameters that must be optimized }
  \item{parsfix}{The values of the parameters that should not be optimized }
  \item{idparsopt}{
   The ids of the parameters that must be optimized, e.g. 1:7 for all parameters.
   The ids are defined as follows: \cr
   id == 1 corresponds to lambda_M (speciation rate) of the main clade \cr
   id == 2 corresponds to mu_M (extinction rate) of the main clade \cr
   id == 3 corresponds to K_M (clade-level carrying capacity) of the main clade \cr
   id == 4 corresponds to lambda_S (speciation rate) of the subclade \cr
   id == 5 corresponds to mu_S (extinction rate) of the subclade \cr
   id == 6 corresponds to K_S (clade-level carrying capacity) of the subclade \cr
   id == 7 corresponds to t_d (the time of decoupling)
   }
  \item{idparsfix}{
The ids of the parameters that should not be optimized, e.g. c(1,3,4,6) if lambda and K
should not be optimized, but only mu. In that case idparsopt must be c(2,5,7). The default is to fix all parameters
not specified in idparsopt.
  }
  \item{idparsnoshift}{ The ids of the parameters that should not shift; 
This can only apply to ids 4, 5 and 6, e.g. idparsnoshift = c(4,5) means that lambda and mu have the same values before and after tshift }
  \item{res}{ sets the maximum number of species for which a probability must be computed, must be larger than 1 + max(length(brtsM),length(brtsS)) }
  \item{ddmodel}{ sets the model of diversity-dependence: \cr
   ddmodel == 1 : linear dependence in speciation rate \cr
   ddmodel == 2 : exponential dependence in speciation rate \cr
   ddmodel == 3 : linear dependence in extinction rate \cr
   ddmodel == 4 : exponential dependence in extinction rate
  }
  \item{missnumspec}{The number of species that are in the clade but missing in the phylogeny. One can specify the sum of the missing species in main clade and subclade or a vector c(missnumspec_M,missnumspec_S) with missing species in main clade and subclade respectively.} 
  \item{cond}{Conditioning on non-extinction of the phylogeny (TRUE or FALSE)}
  \item{soc}{Sets whether stem or crown age should be used (1 or 2); stem age only works when cond = 0 }
  \item{tol}{Sets the tolerances in the optimization. Consists of: \cr
   reltolx = relative tolerance of parameter values in optimization \cr
   reltolf = relative tolerance of function value in optimization \cr
   abstolx = absolute tolerance of parameter values in optimization
  }
  \item{maxiter}{Sets the maximum number of iterations in the optimization}
}
\details{
The output is a dataframe containing estimated parameters and maximum loglikelihood.
The computed loglikelihood contains the factor
q! m!/(q + m)!
where q is the number of species in the phylogeny and m is the number of missing species,
as explained in the supplementary material to Etienne et al. 2012.
}
\value{
 \item{lambda_M}{ gives the maximum likelihood estimate of lambda of the main clade}
 \item{mu_M}{ gives the maximum likelihood estimate of mu of the main clade}
 \item{K_M}{ gives the maximum likelihood estimate of K of the main clade}
 \item{lambda_2}{ gives the maximum likelihood estimate of lambda of the subclade}
 \item{mu_S}{ gives the maximum likelihood estimate of mu of the subclade}
 \item{K_S}{ gives the maximum likelihood estimate of K of the subclade}
 \item{t_d}{ gives the time of the decoupling event}
 \item{loglik}{ gives the maximum loglikelihood}
 \item{df}{ gives the number of estimated parameters, i.e. degrees of feedom}
 \item{conv}{ gives a message on convergence of optimization; conv = 0 means convergence}}
\references{
- Etienne et al. 2012, Proc. Roy. Soc. B 279: 1300-1309, doi: 10.1098/rspb.2011.1439 \cr
- Etienne & Haegeman 2012. Am. Nat. 180: E75-E89, doi: 10.1086/667574
}
\author{Rampal S. Etienne & Bart Haegeman }
\note{The optimization may get trapped in local optima. Try different starting values to search for the global optimum.
}
\seealso{
 \code{\link{dd_KI_loglik}},
 \code{\link{dd_ML}},
 \code{\link{dd_SR_ML}},
}
\examples{
\donttest{
cat("Estimating parameters for two sets of branching times brtsM, brtsS with the default settings:")
brtsM = 1:20
brtsS = seq(0.1,3.9,0.5)
t_split = 5;
dd_KI_ML(brtsM,brtsS,tsplit)
}
}
\keyword{ models }
