% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods_DCS.R
\name{plot.dcs}
\alias{plot.dcs}
\title{Contour Plot for the Double Conditional Smoothing}
\usage{
\method{plot}{dcs}(x, ...)
}
\arguments{
\item{x}{an object of class "dcs_options", usually, a result of a call to 
\code{\link{set.options}}.}

\item{...}{Additional arguments passed to \code{print.dcs_options}. The
argument \code{plot_choice} overrides the prompt to specify a plot, can be 
\code{c(1, 2, 3)}.}
}
\value{
No return value.
}
\description{
\code{plot} method for class \code{"dcs"}
}
\section{Details}{

\code{plot.dcs} provides a contour plot of either the original data (1),
 smoothed surface (2) or residuals (3).
}

\examples{
## Contour plot of smoothed surface
y <- y.norm1 + matrix(rnorm(101^2), nrow = 101, ncol = 101)
dcs_object <- dcs(y)
plot(dcs_object, plot_choice = 2)

}
\seealso{
\code{\link{surface.dcs}} to plot the surface.
}
