% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.Methodology.R
\name{Methodology}
\alias{Methodology}
\title{Abstract class to compute the probability prediction based on
combination between metrics.}
\description{
Abstract class used as a template to define new customized
strategies to combine the probability predictions made by different metrics.
}
\seealso{
\code{\link{ProbBasedMethodology}}
}
\keyword{math}
\keyword{misc}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Methodology-new}{\code{Methodology$new()}}
\item \href{#method-Methodology-getRequiredMetrics}{\code{Methodology$getRequiredMetrics()}}
\item \href{#method-Methodology-compute}{\code{Methodology$compute()}}
\item \href{#method-Methodology-clone}{\code{Methodology$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Methodology-new"></a>}}
\if{latex}{\out{\hypertarget{method-Methodology-new}{}}}
\subsection{Method \code{new()}}{
Method for initializing the object arguments during runtime.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Methodology$new(required.metrics)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{required.metrics}}{A \link{character} vector of length greater than
2 with the name of the required metrics.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Methodology-getRequiredMetrics"></a>}}
\if{latex}{\out{\hypertarget{method-Methodology-getRequiredMetrics}{}}}
\subsection{Method \code{getRequiredMetrics()}}{
The function returns the required metrics that will
participate in the methodology to compute a metric based on all of them.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Methodology$getRequiredMetrics()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{character} vector of length greater than 2 with the name
of the required metrics.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Methodology-compute"></a>}}
\if{latex}{\out{\hypertarget{method-Methodology-compute}{}}}
\subsection{Method \code{compute()}}{
Function to compute the probability of the final prediction
based on different metrics.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Methodology$compute(raw.pred, prob.pred, positive.class, negative.class)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{raw.pred}}{A \link{character} list of length greater than 2 with the
class value of the predictions made by the metrics.}

\item{\code{prob.pred}}{A \link{numeric} list of length greater than 2 with the
probability of the predictions made by the metrics.}

\item{\code{positive.class}}{A \link{character} with the value of the positive
class.}

\item{\code{negative.class}}{A \link{character} with the value of the negative
class.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \link{numeric} value indicating the probability of the instance
is predicted as positive class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Methodology-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Methodology-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Methodology$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
