% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Coxmos_plot_functions.R
\name{plot_evaluation}
\alias{plot_evaluation}
\title{plot_evaluation}
\usage{
plot_evaluation(
  eval_results,
  evaluation = "AUC",
  pred.attr = "mean",
  y.min = NULL,
  type = "both",
  round_times = FALSE,
  decimals = 2,
  title = NULL,
  title_size_text = 15,
  subtitle = NULL,
  subtitle_size_text = 12,
  legend.position = "bottom",
  legend_title = "Method",
  legend_size_text = 12,
  x_axis_size_text = 10,
  y_axis_size_text = 10,
  label_x_axis_size = 10,
  label_y_axis_size = 10,
  txt.x.angle = 0
)
}
\arguments{
\item{eval_results}{Coxmos evaluation object from \code{eval_Coxmos_models()}.}

\item{evaluation}{Character. Perform the evaluation using the "AUC" or "IBS" (Integrative Brier Score)
metric (default: "AUC").}

\item{pred.attr}{Character. Way to evaluate the metric selected. Must be one of the following:
"mean" or "median" (default: "mean").}

\item{y.min}{Numeric. Minimum Y value for establish the Y axis value. If y.min = NULL, automatic
detection is performed (default: NULL).}

\item{type}{Character. Plot type. Must be one of the following: "both", "line" or "mean". In other
case, "both" will be selected (default: "both").}

\item{round_times}{Logical. Whether times x value should be rounded (default: FALSE).}

\item{decimals}{Numeric. Number of decimals to use in round times. Must be a value greater or equal
zero (default = 2).}

\item{title}{Character. Plot title (default: NULL).}

\item{title_size_text}{Numeric. Text size for title (default: 15).}

\item{subtitle}{Character. Plot subtitle (default: NULL).}

\item{subtitle_size_text}{Numeric. Text size for subtitle (default: 12).}

\item{legend.position}{Character. Legend position. Must be one of the following: "top", "bottom", "right" or "left (default: "right").}

\item{legend_title}{Character. Legend title (default: "Method").}

\item{legend_size_text}{Numeric. Text size for legend title (default: 12).}

\item{x_axis_size_text}{Numeric. Text size for x axis (default: 10).}

\item{y_axis_size_text}{Numeric. Text size for y axis (default: 10).}

\item{label_x_axis_size}{Numeric. Text size for x label axis (default: 10).}

\item{label_y_axis_size}{Numeric. Text size for y label axis (default: 10).}

\item{txt.x.angle}{Numeric. Angle of X text (default: 0).}
}
\value{
A list of lst_eval_results length. Each element is a list of three elements.
\code{lst_plots}: A list of two plots. The evaluation over the time, and the extension adding the
mean or median on the right.
\code{lst_plot_comparisons}: A list of comparative boxplots by t.test, anova, wilcoxon, kruscal.
\code{df}: Data.frame of evaluation result.
}
\description{
Generates a comprehensive evaluation of the performance of a given Coxmos evaluation
object from \code{eval_Coxmos_models()}, offering both statistical tests and visual plots for assessment.
}
\details{
The \code{plot_evaluation} function is designed to facilitate a rigorous evaluation of the
performance of models, specifically in the context of survival analysis. This function is tailored
to work with a Coxmos evaluation object, which encapsulates the results of survival models. The
primary objective is to provide both statistical and visual insights into the model's performance.

The function offers flexibility in the evaluation metric, allowing users to choose between the
Area Under the Curve (AUC) and the Brier score. The chosen metric is then evaluated based on either
its mean or median value, as specified by the "pred.attr" parameter. The resulting plots can be
tailored to display continuous performance over time or aggregated mean performance, based on the
"type" parameter.

A salient feature of this function is its ability to conduct statistical tests to compare the
performance across different methods. Supported tests include the t-test, ANOVA, Wilcoxon rank-sum
test, and Kruskal-Wallis test. These tests provide a quantitative measure of the differences in
performance, aiding in the objective assessment of the models.

The visual outputs are generated using the 'ggplot2' package, ensuring high-quality and interpretable
plots. The function also offers extensive customization options for the plots, including axis
labels, title, and text sizes, ensuring that the outputs align with the user's preferences and the
intended audience's expectations.
}
\examples{
data("X_proteomic")
data("Y_proteomic")
set.seed(123)
index_train <- caret::createDataPartition(Y_proteomic$event, p = .5, list = FALSE, times = 1)
X_train <- X_proteomic[index_train,1:50]
Y_train <- Y_proteomic[index_train,]
X_test <- X_proteomic[-index_train,1:50]
Y_test <- Y_proteomic[-index_train,]
coxEN.model <- coxEN(X_train, Y_train, x.center = TRUE, x.scale = TRUE)
eval_results <- eval_Coxmos_models(lst_models = list("coxEN" = coxEN.model), X_test = X_test,
Y_test = Y_test)
plot_eval_results <- plot_evaluation(eval_results)
}
\author{
Pedro Salguero Garcia. Maintainer: pedsalga@upv.edu.es
}
