% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cBern.R
\name{cBern}
\alias{cBern}
\title{Main function}
\usage{
cBern(n, p, rho, type, k = NULL)
}
\arguments{
\item{n}{number of observations}

\item{p}{the vector of marginal probabilities with dimension m}

\item{rho}{For the first three types, rho is either a non-negative value indecating the shared correlation coefficient
or and m-1 vector indicating the correlation coefficients between adjacent
variables. For the general case, rho should be a list, the i-th element of which specifies the coefficients on the i-th minor diagnal.}

\item{type}{including 4 types.

type="exchange"

type="DCP"

type="1-dependent"

type="General"}

\item{k}{(for 'General' use only). The number of layers setting for k-dependent structure. k=m-1 for the general case.}
}
\value{
an n*p matrix of binary data
}
\description{
The main function of our package, through which we can simulate
correlated binary data under different settings.
}
\examples{
X <- cBern(10, rep(0.5,3), 0.5, type="exchange")

X <- cBern(10, rep(0.5,3), c(0.2,0.2), type="DCP")

X <- cBern(5, c(0.4,0.5,0.6), c(0.2,0.3), type="1-dependent")

rho <- list()
rho[[1]] <- c(0.2,0.3)
rho[[2]] <- 0.1
X <- cBern(2, c(0.7,0.8,0.9),rho=rho,type="General", k=2)
}
\references{
Jiang, W., Song, S.,  Hou, L. and Zhao, H. A set of efficient methods to generate high-dimensional binary data with correlation structures. \emph{Submitted}.
}
\seealso{
\code{\link{cBernEx}}, \code{\link{cBernDCP}}, \code{\link{cBern1dep}}
}
