% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seedNeed.R
\name{seedNeed}
\alias{seedNeed}
\title{Required seed amount in a tricot project}
\usage{
seedNeed(npackages = 100, ncomp = 3, nitems = 10, nseeds = 0.15, unit = "kg")
}
\arguments{
\item{npackages}{an integer for the number of trial packages to be produced}

\item{ncomp}{an integer for the number of items to be assigned to each package}

\item{nitems}{number of items tested in the project}

\item{nseeds}{an integer for the metric of seeds each bag receives}

\item{unit}{optional, a character specifying the metric unit used}
}
\value{
a dataframe with required number of seeds
}
\description{
Calculate the required amount of seeds (or other technology) required 
for a triadic comparison of technologies (tricot) project.
}
\examples{
  
# allocate 0.2 kg of seeds per variety in a project with 500 
# participants and 14 varieties
seedNeed(npackages = 500,
          ncomp = 3,
          nitems = 14, 
          nseeds = 0.2)

# allocate 100 seedlings per variety in a project with 400 
# participants, 8 varieties and 3 comparisons between varieties
seedNeed(npackages = 400,
          ncomp = 3,
          nitems = 9, 
          nseeds = 100,
          unit = "unit")
}
\author{
Kauê de Sousa
}
