/*
 * Decompiled with CFR 0.152.
 */
package core.model;

import core.model.Couple;
import core.model.GraphAction;
import core.model.ScoredGraphAction;

public class PValueScoredGraphAction
extends ScoredGraphAction {
    protected long nDF;
    protected double entropy;

    public PValueScoredGraphAction(GraphAction.ActionType type, int v1, int v2, double score, long nDF, double entropy) {
        super(type, v1, v2, score);
        this.nDF = nDF;
        this.entropy = entropy;
    }

    public PValueScoredGraphAction(GraphAction.ActionType type, Couple<Integer> edge, double score, long nDF, double entropy) {
        super(type, edge, score);
        this.nDF = nDF;
        this.entropy = entropy;
    }

    @Override
    public int compareTo(GraphAction o) {
        if (o instanceof PValueScoredGraphAction) {
            PValueScoredGraphAction os = (PValueScoredGraphAction)o;
            int res = Double.compare(this.score, os.score);
            if (res != 0) {
                return res;
            }
            res = Long.compare(this.nDF, os.nDF);
            if (res != 0) {
                return res;
            }
            res = -1 * Double.compare(this.entropy, os.entropy);
            if (res != 0) {
                return res;
            }
        }
        return super.compareTo(o);
    }

    @Override
    public String toString() {
        String res = super.toString();
        res = String.valueOf(res) + "p=" + this.score + "\t";
        res = String.valueOf(res) + "df=" + this.nDF + "\t";
        res = String.valueOf(res) + "H=" + this.entropy;
        return res;
    }

    public double getEntropy() {
        return this.entropy;
    }

    public long getNDF() {
        return this.nDF;
    }
}

