/*
 * Decompiled with CFR 0.152.
 */
package core.stats;

import core.model.Couple;
import core.model.DecomposableModel;
import core.model.GraphAction;
import core.model.ScoredGraphAction;
import core.stats.scorer.GraphActionScorer;
import java.util.ArrayList;
import java.util.PriorityQueue;

public class MyPriorityQueue
extends PriorityQueue<ScoredGraphAction> {
    private static final long serialVersionUID = 6863099646496386231L;
    DecomposableModel model;
    GraphActionScorer scorer;
    ScoredGraphAction[][] actionsByEdge;
    ArrayList<Couple<Integer>> toDelete;
    ArrayList<Couple<Integer>> toAdd;
    ArrayList<Couple<Integer>> toUpdate;
    public ArrayList<Integer> nbScoredEdgesPerStep = new ArrayList();
    public ArrayList<Integer> nbEdgesAvailablePerStep = new ArrayList();

    public MyPriorityQueue(int nbVariables, DecomposableModel model, GraphActionScorer scorer) {
        super(nbVariables * nbVariables / 2);
        this.model = model;
        this.scorer = scorer;
        this.actionsByEdge = new ScoredGraphAction[nbVariables][nbVariables];
        this.toDelete = new ArrayList();
        this.toAdd = new ArrayList();
        this.toUpdate = new ArrayList();
    }

    public void enableEdge(Integer a, Integer b) {
        this.toAdd.add(new Couple<Integer>(a, b));
    }

    public void updateEdge(Integer a, Integer b) {
        this.toUpdate.add(new Couple<Integer>(a, b));
    }

    public void disableEdge(Integer a, Integer b) {
        this.toDelete.add(new Couple<Integer>(a, b));
    }

    public void processStoredModifications() {
        ScoredGraphAction scoredEdge;
        int b;
        int a;
        int nbScoredEdges = 0;
        for (Couple<Integer> c : this.toDelete) {
            a = c.getV1();
            b = c.getV2();
            this.remove(this.actionsByEdge[a][b]);
            this.actionsByEdge[a][b] = null;
            this.actionsByEdge[b][a] = this.actionsByEdge[a][b];
        }
        for (Couple<Integer> c : this.toAdd) {
            a = c.getV1();
            b = c.getV2();
            this.actionsByEdge[a][b] = scoredEdge = this.scorer.scoreEdge(this.model, new GraphAction(GraphAction.ActionType.ADD, a, b));
            this.actionsByEdge[b][a] = this.actionsByEdge[a][b];
            this.offer(scoredEdge);
            ++nbScoredEdges;
        }
        for (Couple<Integer> c : this.toUpdate) {
            a = c.getV1();
            b = c.getV2();
            this.remove(this.actionsByEdge[a][b]);
            this.actionsByEdge[a][b] = scoredEdge = this.scorer.scoreEdge(this.model, new GraphAction(GraphAction.ActionType.ADD, a, b));
            this.actionsByEdge[b][a] = this.actionsByEdge[a][b];
            this.offer(scoredEdge);
            ++nbScoredEdges;
        }
        this.toDelete.clear();
        this.toAdd.clear();
        this.toUpdate.clear();
        this.nbScoredEdgesPerStep.add(nbScoredEdges);
        this.nbEdgesAvailablePerStep.add(this.size());
    }

    @Override
    public String toString() {
        ScoredGraphAction a;
        String res = "";
        ArrayList<ScoredGraphAction> polled = new ArrayList<ScoredGraphAction>();
        while ((a = (ScoredGraphAction)this.poll()) != null) {
            polled.add(a);
            res = String.valueOf(res) + a.toString() + "\n";
        }
        for (ScoredGraphAction action : polled) {
            this.offer(action);
        }
        return res;
    }
}

