% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspectLvls.R
\name{inspectLvls}
\alias{inspectLvls}
\title{Inspect Levels for Contour Plots of Spectra2D Objects}
\usage{
inspectLvls(spectra, which = 1, ...)
}
\arguments{
\item{spectra}{An object of S3 class \code{\link{Spectra2D}}.}

\item{which}{Integer.  The spectrum/spectra to be analyzed.  If a vector,
the intensities are combined.}

\item{\dots}{Arguments to be passed downstream to \code{\link{calcLvls}} and/or
the plot function (e.g. \code{ylim}).}
}
\value{
A numeric vector giving the levels (invisibly).
}
\description{
Given a \code{Spectra2D} object, this function will assist in selecting levels
for preparing contour and image type plots.
Any of the arguments to \code{\link{calcLvls}} can be used
to compute the levels, or you can choose your own by inspection.
}
\examples{

data(MUD1)
inspectLvls(MUD1, ylim = c(0, 300), main = "MUD1 Spectrum 1, mode = even")
inspectLvls(MUD1, ylim = c(0, 300), mode = "NMR", main = "MUD1 Spectrum 1, mode = NMR")
}
\seealso{
See \code{\link{pfacSpectra2D}} for further examples.
}
\author{
Bryan A. Hanson, DePauw University. \email{hanson@depauw.edu}
}
\keyword{utilities}
