% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{define_library}
\alias{define_library}
\title{Defining Kernel Library}
\usage{
define_library(kern_par = NULL)
}
\arguments{
\item{kern_par}{(dataframe, K*3) A dataframe indicating the parameters of
base kernels to fit kernel effect. See Details.}
}
\value{
\item{kern_func_list}{(list of length K) A list of kernel functions 
given by user. Will be overwritten to linear kernel if kern_par is NULL.}
}
\description{
Generate the expected kernel library based on user-specified dataframe.
}
\details{
It creates a kernel library according to the parameters given in kern_par.

* kern_par: for a library of K kernels, the dimension of this dataframe is
  K*3. Each row represents a kernel. The first column is method, with entries
  of character class. The second and the third are l and p respectively, both
  with entries of numeric class.
}
\seealso{
method: \code{\link{generate_kernel}}
}
\author{
Wenying Deng
}
