% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_regen.R
\name{regen}
\alias{regen}
\title{Regenerate COIN object}
\usage{
regen(COINold, quietly = FALSE)
}
\arguments{
\item{COINold}{COIN object containing specifications on how to regenerate.}

\item{quietly}{Logical: if \code{TRUE} suppresses all messages from COINr functions (warnings may still occur though).}
}
\value{
An updated COIN object, with all data sets recalculated according to specifications in \code{.$Method}. Weight sets will be passed through.
}
\description{
Function to regenerate the results of the COIN, using the methodological parameters stored in
\code{.$Method}. This function calls the construction functions of COINr in the order that they are
found in \code{.$Method}, along with any custom code found in \code{.$Method$Custom}.
}
\details{
Note that while sets of weights will be passed to the regenerated COIN, anything in \code{.$Analysis} will be removed and will have to be recalculated.

For more details on regeneration of COINs, comparisons and adjustments, see the \href{https://bluefoxr.github.io/COINrDoc/adjustments-and-comparisons.html}{online documentation}.
}
\examples{
ASEM <- build_ASEM()
# Make a copy
ASEMAltNorm <- ASEM
# Edit .$Method
ASEMAltNorm$Method$normalise$ntype <- "borda"
# Regenerate
ASEMAltNorm <- regen(ASEMAltNorm, quietly = TRUE)

}
\seealso{
\itemize{
\item \code{\link[=compTable]{compTable()}} compare two different COINs
\item \code{\link[=compTableMulti]{compTableMulti()}} compare multiple COINs
}
}
