% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_normalise.R
\name{normalise}
\alias{normalise}
\title{Normalise indicator data sets}
\usage{
normalise(
  COIN,
  ntype = "minmax",
  npara = NULL,
  dset = NULL,
  directions = NULL,
  individual = NULL,
  indiv_only = NULL,
  out2 = NULL
)
}
\arguments{
\item{COIN}{Either the COIN object, or a data frame of indicator data}

\item{ntype}{The type of normalisation method. Either \code{"minmax"}, \code{"zscore"}, \code{"scaled"}, \code{"goalposts"}, \code{"rank"}, \code{"borda"}, \code{"prank"},
\code{"fracmax"}, \code{"dist2targ"}, \code{"dist2ref"}, \code{"dist2max"}, \code{"custom"} or \code{"none"}.
See the \href{https://bluefoxr.github.io/COINrDoc/normalisation.html}{online documentation}.}

\item{npara}{Supporting object for \code{ntype}. This is a list of the form \code{list(ntype = parameters_for_ntype)}. So,
if \code{ntype = "minmax"}, \code{npara} could be \code{list(minmax = c(0, 100))} to scale into the 0 to 100 interval.
If \code{ntype = "zscore"}, \code{npara} could be \code{list(zscore = c(0, 1))} to scale to mean zero and standard deviation 1.
This means you can store parameters for more than one normalisation type side by side, which helps in
comparisons, adjustments, and sensitivity analyses.}

\item{dset}{The data set to normalise.}

\item{directions}{A vector specifying the direction assigned to each indicator.
Needs to be the same length as the number of indicators, or the number of indicators in \code{icodes}, if specified.}

\item{individual}{A list of named lists specifying individual normalisation to apply to specific indicators. Should be structured as follows:
The name of each sub-list should be the indicator code. The the list elements are:
\itemize{
\item .\verb{$ntype} is the type of normalisation to apply
\item .\verb{$npara} is a corresponding object or parameters that are used by \code{ntype}, in the same format as \code{npara} above.
}}

\item{indiv_only}{Logical: if \code{FALSE} (default), indicators not specified in individual are subjected to default normalisation.
Otherwise if \code{TRUE} they are not normalised.}

\item{out2}{Where to output the results. If \code{"COIN"} (default for COIN input), appends to updated COIN,
otherwise if \code{"df"} outputs to data frame.}
}
\value{
If \code{out2 = "COIN"} (default for COIN input), returns an updated COIN object with a data frame \code{.$Data$Normalised}
added. Else if \code{out2 = "df"} outputs a data frame of normalised data.
}
\description{
A dataset of indicators is normalised using one of several methods. This function also supports custom normalisation.
}
\details{
Normalisation refers to the operation of bringing variables (indicators) onto a common scale. This is typically done by matching
one or more indicator statistics. For example, the \emph{min-max} method operates a linear transformation to make the minimum and
maximum values of each indicator to be equal. The \emph{z-score} method makes the standard deviation and variance equal. And so on.

This function supports a range of normalisation methods - see \code{ntype}. Some of these require supporting parameters or similar -
to see full details check the \href{https://bluefoxr.github.io/COINrDoc/normalisation.html}{online documentation}.

Indicators can also be each normalised by a different method. See \code{individual}.
}
\examples{
# build ASEM COIN
ASEM <- assemble(IndData = ASEMIndData, IndMeta = ASEMIndMeta, AggMeta = ASEMAggMeta)
# directly normalise raw data using min-max, onto 0-10 interval
ASEM <- normalise(ASEM, dset = "Raw", ntype = "minmax", npara = list(minmax = c(0,10)))
# Check: get indicator data first
NormData <- getIn(ASEM, dset = "Normalised")$ind_data_only
# ensure that min is 0 and max is 10 for all columns
stopifnot(
all(apply(NormData, MARGIN = 2, min, na.rm = TRUE) == 0),
all(apply(NormData, MARGIN = 2, max, na.rm = TRUE) == 10)
)

}
