% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_resultsdash.R
\name{iplotTable}
\alias{iplotTable}
\title{Results table}
\usage{
iplotTable(
  COIN,
  dset = "Raw",
  isel = NULL,
  aglev = NULL,
  nround = 1,
  extra_cols = FALSE
)
}
\arguments{
\item{COIN}{The COIN object, or a data frame of indicator data.}

\item{dset}{The data set to use in the table}

\item{isel}{The selected indicator codes (default all in \code{dset})}

\item{aglev}{The aggregation level to select data from}

\item{nround}{The number of decimal places to round scores to (default 1).}

\item{extra_cols}{If \code{FALSE} (default), excludes group columns and similar. If \code{TRUE}, includes them.}
}
\value{
An interactive table generated by reactable.
}
\description{
Generates an interactive table of data. For use in e.g. Shiny or HTML documents.
}
\details{
This function is a wrapper for the \strong{reactable} package and offers a fast way to make interactive tables. It also applies
conditional formatting (colouring by cell value), and sorts by the first column by default. Like other \strong{COINr} functions,
it can target subsets of indicators.
}
\examples{
# assemble ASEM COIN
ASEM <- assemble(IndData = ASEMIndData, IndMeta = ASEMIndMeta, AggMeta = ASEMAggMeta)
# table of indicators in "Poltical" pillar
iplotTable(ASEM, dset = "Raw", isel = "Political", aglev = 1)

}
\seealso{
\itemize{
\item \code{\link[=colourTable]{colourTable()}} Conditionally-formatted table for any data frame
\item \code{\link[=resultsDash]{resultsDash()}} interactive dashboard of indicator data
\item \code{\link[=getResults]{getResults()}} results summary tables
}
}
