% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_resultsdash.R
\name{iplotRadar}
\alias{iplotRadar}
\title{Radar chart}
\usage{
iplotRadar(
  COIN,
  dset = "Raw",
  usel = NULL,
  aglev = NULL,
  isel = NULL,
  addstat = "none",
  statgroup = NULL,
  statgroup_name = NULL
)
}
\arguments{
\item{COIN}{The COIN object, or a data frame of indicator data.}

\item{dset}{The data set to use in the table}

\item{usel}{Character vector of unit code(s) to plot data from}

\item{aglev}{The selected aggregation level to take indicator data from,
where 1 is the base indicator level, and 2, 3 etc are higher aggregation levels}

\item{isel}{The indicator or aggregation code(s) to plot}

\item{addstat}{Adds the statistic of the scores in each dimension as a separate trace. If \code{"mean"} adds the overall
mean for each dimension/indicator. If \code{"median"} adds the overall median. If \code{"groupmean"} or \code{"groupmedian"}, adds the
group mean or median respectively of the first unit specified in \code{usel}, using the group specified by \code{statgroup}. Default \code{"none"}, i.e. no extra trace.
Using a group mean or median won't make sense unless all of selected units are from the same group.}

\item{statgroup}{A grouping variable (must be present in \code{dset}) if \code{addstat = "groupmean"} or \code{"groupmedian"}}

\item{statgroup_name}{An optional name to display for \code{statgroup.} In the legend this will appear as e.g. \code{"statgroup_name group mean"}.
Defaults to \code{statgroup}.}
}
\value{
Interactive radar chart generated using plotly.
}
\description{
Generates an interactive radar chart for a specified unit or set of units.
}
\details{
This function uses \strong{plotly} to generate a radar chart for showing one or more units, compared using a specified set of indicators.
Optionally, you can add mean/median or group mean/median as an extra trace. The point being to show how a particular unit compares to
its peers.
}
\examples{
# build ASEM COIN up to aggregation
ASEM <- build_ASEM()
# radar chart of Austria vs. China in Political indicators
iplotRadar(ASEM, dset = "Aggregated", usel = c("AUT", "CHN"), isel = "Political", aglev = 1)

}
\seealso{
\itemize{
\item \code{\link[=resultsDash]{resultsDash()}} Interactive results dashboard.
}
}
